/**
 * Check if Given Url Is a Valid Url
 *
 * @param url
 * @returns {boolean}
 */
function isValidUrl (url)
{
  var pattern = new RegExp('^(https?:\\/\\/)?' + // protocol
    '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + // domain name
    '((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
    '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
    '(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
    '(\\#[-a-z\\d_]*)?$', 'i') // fragment locator
  return !!pattern.test(url)
}

/**
 * Redirect user based on event
 *
 * @param evt
 */
function redirect (evt)
{
  const value = evt.currentTarget.value
  if (!value) {
    return
  }

  if (!isValidUrl(value)) {
    return
  }

  evt.preventDefault()
  evt.stopImmediatePropagation()

  window.location.href = value
}

/**
 * Quick Links
 *
 * @type {QuickLinks}
 */
export const QuickLinks = class QuickLinks
{
  /**
   * Initialize Quick Links
   */
  static initialize ()
  {
    const element = document.querySelector('#mlp_quicklinks_redirect_selection')
    if (!element) {
      return
    }

    const submit = document.querySelector('.mlp-quicklinks-form__submit')
    submit && submit.parentNode.removeChild(submit)

    element.addEventListener('change', redirect)
  }
}
