!function(e){var t={};function s(n){if(t[n])return t[n].exports;var c=t[n]={i:n,l:!1,exports:{}};return e[n].call(c.exports,c,c.exports,s),c.l=!0,c.exports}s.m=e,s.c=t,s.d=function(e,t,n){s.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},s.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},s.t=function(e,t){if(1&t&&(e=s(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(s.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var c in e)s.d(n,c,function(t){return e[t]}.bind(null,c));return n},s.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return s.d(t,"a",t),t},s.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},s.p="",s(s.s=0)}([function(module,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleNoticeHtmlElement.js\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ScheduleNoticeHtmlElement =\n/*#__PURE__*/\nfunction () {\n  function ScheduleNoticeHtmlElement(htmlElement) {\n    _classCallCheck(this, ScheduleNoticeHtmlElement);\n\n    // TODO Check where the property is accessed and try to change it with a method\n    this.htmlElement = htmlElement;\n  }\n\n  _createClass(ScheduleNoticeHtmlElement, [{\n    key: "estimatedRemainingTimeElement",\n    value: function estimatedRemainingTimeElement() {\n      return this.htmlElement.querySelector(\'.mlp-new-site-schedule-steps__estimated-remaining-time\');\n    }\n  }, {\n    key: "totalAttachmentsElement",\n    value: function totalAttachmentsElement() {\n      return this.htmlElement.querySelector(\'.mlp-new-site-schedule-steps__total-attachments\');\n    }\n  }, {\n    key: "contentElement",\n    value: function contentElement() {\n      return this.htmlElement.querySelector(\'.mlp-attachment-schedule-notice__content\');\n    }\n  }, {\n    key: "progressBarElement",\n    value: function progressBarElement() {\n      var progressEl = this.htmlElement.querySelector(\'.mlp-new-site-schedule-notice-progress\');\n      var progressBarEl = progressEl.querySelector(\'.mlp-new-site-schedule-notice-progress__bar\');\n      return progressBarEl;\n    }\n  }, {\n    key: "remove",\n    value: function remove() {\n      this.htmlElement.remove();\n    }\n  }]);\n\n  return ScheduleNoticeHtmlElement;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/EventDispatcher.js\nfunction EventDispatcher_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction EventDispatcher_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction EventDispatcher_createClass(Constructor, protoProps, staticProps) { if (protoProps) EventDispatcher_defineProperties(Constructor.prototype, protoProps); if (staticProps) EventDispatcher_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar EVENT_SCHEDULE_ERROR = \'multilingualpress.schedule_error\';\nvar EventDispatcher =\n/*#__PURE__*/\nfunction () {\n  function EventDispatcher(jQuery) {\n    EventDispatcher_classCallCheck(this, EventDispatcher);\n\n    this.jQuery = jQuery;\n  }\n\n  EventDispatcher_createClass(EventDispatcher, [{\n    key: "dispatchScheduleError",\n    value: function dispatchScheduleError(args) {\n      this.jQuery(document).trigger(EVENT_SCHEDULE_ERROR, args);\n    }\n  }, {\n    key: "dispatchEvent",\n    value: function dispatchEvent(eventName) {\n      var _this$jQuery;\n\n      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n        args[_key - 1] = arguments[_key];\n      }\n\n      (_this$jQuery = this.jQuery(document)).trigger.apply(_this$jQuery, [eventName].concat(args));\n    }\n  }]);\n\n  return EventDispatcher;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleNotice.js\nfunction ScheduleNotice_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleNotice_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleNotice_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleNotice_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleNotice_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ACTION_SCHEDULE_NOTICE_UPDATED = \'multilingualpress.schedule_notice_updated\';\nvar ScheduleNotice =\n/*#__PURE__*/\nfunction () {\n  /**\n   *\n   * @param {jQuery} jQuery\n   * @param eventDispatcher\n   * @param {ScheduleNoticeHtmlElement} scheduleNoticeHtmlElement\n   */\n  function ScheduleNotice(jQuery, eventDispatcher, scheduleNoticeHtmlElement) {\n    ScheduleNotice_classCallCheck(this, ScheduleNotice);\n\n    this.jQuery = jQuery;\n    this.eventDispatcher = eventDispatcher;\n    this.scheduleNoticeHtmlElement = scheduleNoticeHtmlElement;\n  }\n  /**\n   * Remove the schedule admin notice element from the DOM\n   *\n   * @returns void\n   */\n\n\n  ScheduleNotice_createClass(ScheduleNotice, [{\n    key: "removeScheduleNoticeElement",\n    value: function removeScheduleNoticeElement() {\n      this.scheduleNoticeHtmlElement.remove();\n    }\n    /**\n     * Update the admin notice with a message\n     *\n     * @param {string} message\n     * @param {string} type\n     * @returns void\n     */\n\n  }, {\n    key: "updateScheduleNoticeWithMessage",\n    value: function updateScheduleNoticeWithMessage(message, type) {\n      if (!message) {\n        return;\n      }\n\n      var scheduleNoticeContent = this.scheduleNoticeHtmlElement.contentElement();\n      scheduleNoticeContent.innerHTML = message;\n\n      if (type) {\n        // TODO Need regexp to remove the previous `notice-` class\n        this.jQuery(this.scheduleNoticeHtmlElement).removeClass(\'notice-info\');\n        this.jQuery(this.scheduleNoticeHtmlElement).addClass("notice-".concat(type));\n      }\n    }\n    /**\n     * Update the schedule notice with new information for schedule by the server\n     *\n     * @param {ScheduleStatus} scheduleStatus\n     *\n     * @returns void\n     */\n\n  }, {\n    key: "updateScheduleNoticeByStatus",\n    value: function updateScheduleNoticeByStatus(scheduleStatus) {\n      var schedule = scheduleStatus.schedule;\n      var scheduleArguments = schedule.scheduleArguments;\n      var estimatedRemainingTimeEl = this.scheduleNoticeHtmlElement.estimatedRemainingTimeElement();\n      var attachmentsNumberEl = this.scheduleNoticeHtmlElement.totalAttachmentsElement();\n\n      if (attachmentsNumberEl && scheduleArguments.attachmentsNumber) {\n        attachmentsNumberEl.innerText = scheduleArguments.attachmentsNumber;\n      }\n\n      if (estimatedRemainingTimeEl && scheduleStatus.estimatedRemainingTime) {\n        estimatedRemainingTimeEl.innerText = scheduleStatus.estimatedRemainingTime;\n      }\n\n      updateProgressBar(this.scheduleNoticeHtmlElement.progressBarElement(), schedule);\n      this.eventDispatcher.dispatchEvent(ACTION_SCHEDULE_NOTICE_UPDATED, [schedule]);\n    }\n    /**\n     * @returns void\n     */\n\n  }, {\n    key: "show",\n    value: function show() {\n      var htmlElement = this.scheduleNoticeHtmlElement.htmlElement;\n      htmlElement.style.setProperty(\'display\', \'flex\');\n    }\n    /**\n     * @returns void\n     */\n\n  }, {\n    key: "hide",\n    value: function hide() {\n      var htmlElement = this.scheduleNoticeHtmlElement.htmlElement;\n      htmlElement.style.setProperty(\'display\', \'none\');\n    }\n  }, {\n    key: "scheduleData",\n    value: function scheduleData() {\n      var data = JSON.parse(this.scheduleNoticeHtmlElement.htmlElement.dataset.currentSchedule);\n      return data;\n    }\n  }]);\n\n  return ScheduleNotice;\n}();\n/**\n * @param progressBar\n * @param schedule\n */\n\nfunction updateProgressBar(progressBar, schedule) {\n  var stepsDone = schedule.hasOwnProperty(\'stepsDone\') ? parseInt(schedule.stepsDone) : 0;\n  var allSteps = schedule.hasOwnProperty(\'allSteps\') ? parseInt(schedule.allSteps) : 0;\n\n  if (!stepsDone || !allSteps) {\n    return;\n  }\n\n  var progressPercentage = Math.floor(stepsDone / allSteps * 100);\n  progressBar.style.setProperty(\'width\', progressPercentage + \'%\');\n}\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleStatus.js\nfunction ScheduleStatus_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar ScheduleStatus = function ScheduleStatus(scheduleId, schedule, stepToFinish, estimatedRemainingTime) {\n  ScheduleStatus_classCallCheck(this, ScheduleStatus);\n\n  // TODO This need to throw so in ScheduleStatusRequest.statusSuccessHandler we can try/catch\n  this.scheduleId = scheduleId;\n  this.schedule = schedule;\n  this.stepToFinish = stepToFinish;\n  this.estimatedRemainingTime = estimatedRemainingTime;\n};\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleStatusFactory.js\nfunction ScheduleStatusFactory_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusFactory_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusFactory_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusFactory_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusFactory_defineProperties(Constructor, staticProps); return Constructor; }\n\n\nvar ScheduleStatusFactory_ScheduleStatusFactory =\n/*#__PURE__*/\nfunction () {\n  /**\n   * @param {ScheduleFactory} scheduleFactory\n   */\n  function ScheduleStatusFactory(scheduleFactory) {\n    ScheduleStatusFactory_classCallCheck(this, ScheduleStatusFactory);\n\n    this.scheduleFactory = scheduleFactory;\n  }\n  /**\n   * @param scheduleId\n   * @param schedule\n   * @param stepToFinish\n   * @param estimatedRemainingTime\n   * @returns {ScheduleStatus}\n   */\n\n\n  ScheduleStatusFactory_createClass(ScheduleStatusFactory, [{\n    key: "create",\n    value: function create(scheduleId, schedule, stepToFinish, estimatedRemainingTime) {\n      schedule = this.scheduleFactory.create(schedule);\n      return new ScheduleStatus(scheduleId, schedule, stepToFinish, estimatedRemainingTime);\n    }\n  }]);\n\n  return ScheduleStatusFactory;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/Form.js\nfunction Form_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction Form_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction Form_createClass(Constructor, protoProps, staticProps) { if (protoProps) Form_defineProperties(Constructor.prototype, protoProps); if (staticProps) Form_defineProperties(Constructor, staticProps); return Constructor; }\n\n\n/**\n * Form Class\n */\n\nvar Form_Form =\n/*#__PURE__*/\nfunction () {\n  function Form(jQuery, formElement, translations) {\n    Form_classCallCheck(this, Form);\n\n    this.jQuery = jQuery;\n    this.formElement = formElement;\n    this.translations = translations;\n    this.eventCallback = this.preventFormSubmission.bind(this);\n  }\n  /**\n   * Block the submission of the form that are within the page\n   */\n\n\n  Form_createClass(Form, [{\n    key: "blockFormSubmission",\n    value: function blockFormSubmission() {\n      var _this = this;\n\n      this.formElement.addEventListener(\'submit\', this.eventCallback);\n      this.jQuery(document).on(EVENT_SCHEDULE_ERROR, function () {\n        return _this.releaseFormSubmission();\n      });\n    }\n    /**\n     * Release Form Submission, allowing to submit forms again\n     */\n\n  }, {\n    key: "releaseFormSubmission",\n    value: function releaseFormSubmission() {\n      this.formElement.removeEventListener(\'submit\', this.eventCallback);\n    }\n  }, {\n    key: "preventFormSubmission",\n    value: function preventFormSubmission(evt) {\n      evt.preventDefault();\n      evt.stopImmediatePropagation();\n\n      if (this.translations.hasOwnProperty(\'preventFormSubmissionMessage\')) {\n        alert(this.translations.preventFormSubmissionMessage);\n      }\n    }\n  }]);\n\n  return Form;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleStatusRequest.js\nfunction ScheduleStatusRequest_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusRequest_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusRequest_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusRequest_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusRequest_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ScheduleStatusRequest =\n/*#__PURE__*/\nfunction () {\n  /**\n   * @param {jQuery} jQuery\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {ScheduleStatusResponseHandler} scheduleStatusResponseHandler\n   * @param {Form} form\n   * @param ajaxUrl\n   */\n  function ScheduleStatusRequest(jQuery, scheduleNotice, scheduleStatusResponseHandler, form, ajaxUrl) {\n    ScheduleStatusRequest_classCallCheck(this, ScheduleStatusRequest);\n\n    this.jQuery = jQuery;\n    this.scheduleNotice = scheduleNotice;\n    this.scheduleStatusResponseHandler = scheduleStatusResponseHandler;\n    this.form = form;\n    this.ajaxUrl = ajaxUrl;\n    this.ajaxEvent = null;\n  }\n  /**\n   * Retrieve information for the current cron job by the server\n   *\n   * @returns void\n   */\n\n\n  ScheduleStatusRequest_createClass(ScheduleStatusRequest, [{\n    key: "status",\n    value: function status() {\n      var _this = this;\n\n      // TODO Would be nice to have it sync using async/await instead of a promise\n      this.ajaxEvent = this.jQuery.ajax({\n        url: this.ajaxUrl,\n        complete: function complete(jqXHR, textStatus) {\n          return _this.scheduleStatusResponseHandler.completeHandler(jqXHR, textStatus, function () {\n            return _this.status();\n          });\n        },\n        success: function success(response) {\n          return _this.scheduleStatusResponseHandler.statusSuccessHandler(response);\n        },\n        error: function error() {\n          return _this.scheduleStatusResponseHandler.statusErrorHandler();\n        }\n      });\n    }\n    /**\n     * Detach ajax event\n     *\n     * @return void\n     */\n\n  }, {\n    key: "detachAjaxEvent",\n    value: function detachAjaxEvent() {\n      this.ajaxEvent && this.jQuery(document).off(\'ajaxSend\', this.ajaxEvent);\n    }\n  }]);\n\n  return ScheduleStatusRequest;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleStatusResponseHandler.js\nfunction ScheduleStatusResponseHandler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusResponseHandler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusResponseHandler_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusResponseHandler_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusResponseHandler_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ScheduleStatusResponseHandler =\n/*#__PURE__*/\nfunction () {\n  /**\n   *\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {EventDispatcher} eventDispatcher\n   * @param {ScheduleStatusFactory} scheduleStatusFactory\n   * @param form\n   * @param {*} translations\n   */\n  function ScheduleStatusResponseHandler(scheduleNotice, eventDispatcher, scheduleStatusFactory, form, translations) {\n    ScheduleStatusResponseHandler_classCallCheck(this, ScheduleStatusResponseHandler);\n\n    this.scheduleNotice = scheduleNotice;\n    this.eventDispatcher = eventDispatcher;\n    this.scheduleStatusFactory = scheduleStatusFactory;\n    this.form = form;\n    this.translations = translations;\n  }\n  /**\n   * @param jqXHR\n   * @param textStatus\n   * @param callback\n   */\n\n\n  ScheduleStatusResponseHandler_createClass(ScheduleStatusResponseHandler, [{\n    key: "completeHandler",\n    value: function completeHandler(jqXHR, textStatus, callback) {\n      var statusesWhichStopLoop = [\'error\', \'abort\', \'parsererror\'];\n\n      if (statusesWhichStopLoop.includes(textStatus)) {\n        return;\n      }\n\n      if (jqXHR.responseJSON.success === false) {\n        return;\n      }\n\n      callback();\n    }\n    /**\n     * @param response\n     */\n\n  }, {\n    key: "statusSuccessHandler",\n    value: function statusSuccessHandler(response) {\n      var _ref = response.data || {\n        data: {}\n      },\n          scheduleId = _ref.scheduleId,\n          schedule = _ref.schedule,\n          stepToFinish = _ref.stepToFinish,\n          estimatedRemainingTime = _ref.estimatedRemainingTime;\n      /*\n       * There\'s not case for schedule succeed.\n       * When the schedule ends it will not exists, means this catch also\n       * the case when the schedule succeed.\n       */\n\n\n      if (!response.success) {\n        this.scheduleNotice.removeScheduleNoticeElement();\n        this.eventDispatcher.dispatchScheduleError();\n        return;\n      }\n\n      this.scheduleNotice.show();\n      this.form.blockFormSubmission();\n      var scheduleStatus = this.scheduleStatusFactory.create(scheduleId, schedule, stepToFinish, estimatedRemainingTime);\n      this.scheduleNotice.updateScheduleNoticeByStatus(scheduleStatus);\n    }\n    /**\n     * @param jqXHR\n     * @param textStatus\n     * @param errorThrown\n     */\n\n  }, {\n    key: "statusErrorHandler",\n    value: function statusErrorHandler(jqXHR, textStatus, errorThrown) {\n      this.scheduleNotice.updateScheduleNoticeWithMessage(this.translations.scheduleInfoErrorMessage, \'error\');\n      this.eventDispatcher.dispatchScheduleError({\n        message: errorThrown\n      });\n    }\n  }]);\n\n  return ScheduleStatusResponseHandler;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/Spinner.js\nfunction Spinner_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction Spinner_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction Spinner_createClass(Constructor, protoProps, staticProps) { if (protoProps) Spinner_defineProperties(Constructor.prototype, protoProps); if (staticProps) Spinner_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar template = \'<span class="spinner is-active"></span>\';\nvar selector = \'.spinner\';\nvar Spinner =\n/*#__PURE__*/\nfunction () {\n  function Spinner() {\n    Spinner_classCallCheck(this, Spinner);\n  }\n\n  Spinner_createClass(Spinner, [{\n    key: "replace",\n    value: function replace(where) {\n      this.remove(where);\n      this.insert(where);\n    }\n  }, {\n    key: "insert",\n    value: function insert(where) {\n      where.insertAdjacentHTML(\'beforeend\', template);\n    }\n  }, {\n    key: "remove",\n    value: function remove(from) {\n      var existingSpinner = from.querySelector(selector);\n      existingSpinner && existingSpinner.remove();\n    }\n  }]);\n\n  return Spinner;\n}();\n// CONCATENATED MODULE: ./resources/js/siteDuplication/action/StopAttachmentDuplicationProcessAction.js\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction StopAttachmentDuplicationProcessAction_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction StopAttachmentDuplicationProcessAction_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction StopAttachmentDuplicationProcessAction_createClass(Constructor, protoProps, staticProps) { if (protoProps) StopAttachmentDuplicationProcessAction_defineProperties(Constructor.prototype, protoProps); if (staticProps) StopAttachmentDuplicationProcessAction_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar StopAttachmentDuplicationProcessAction =\n/*#__PURE__*/\nfunction () {\n  /**\n   * @param jQuery\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {ScheduleStatusRequest} scheduleStatusRequest\n   * @param {Form} form\n   * @param {Spinner} spinner\n   * @param {String} ajaxUrl\n   * @param {String} action\n   * @param {String} nonceAction\n   * @param {String} nonce\n   */\n  function StopAttachmentDuplicationProcessAction(jQuery, scheduleNotice, scheduleStatusRequest, form, spinner, ajaxUrl, nonce, nonceAction, action) {\n    StopAttachmentDuplicationProcessAction_classCallCheck(this, StopAttachmentDuplicationProcessAction);\n\n    this.scheduleStatusRequest = scheduleStatusRequest;\n    this.jQuery = jQuery;\n    this.scheduleNotice = scheduleNotice;\n    this.form = form;\n    this.spinner = spinner;\n    this.ajaxUrl = ajaxUrl;\n    this.action = action;\n    this.nonceAction = nonceAction;\n    this.nonce = nonce;\n  }\n  /**\n   * @returns void\n   */\n\n\n  StopAttachmentDuplicationProcessAction_createClass(StopAttachmentDuplicationProcessAction, [{\n    key: "stopDuplication",\n    value: function stopDuplication(event) {\n      var _data,\n          _this = this;\n\n      try {\n        var _this$scheduleNotice$ = this.scheduleNotice.scheduleData(),\n            scheduleId = _this$scheduleNotice$.id,\n            siteId = _this$scheduleNotice$.scheduleArguments.newSiteId;\n      } catch (error) {\n        this.scheduleNotice.updateScheduleNoticeWithMessage(error.message, \'error\');\n        return;\n      }\n\n      var data = (_data = {\n        action: this.action\n      }, _defineProperty(_data, this.action, \'stop_attachments_copy\'), _defineProperty(_data, this.nonceAction, this.nonce), _defineProperty(_data, "scheduleId", scheduleId), _defineProperty(_data, "siteId", siteId), _data);\n      this.scheduleStatusRequest.detachAjaxEvent();\n      this.jQuery.ajax({\n        url: this.ajaxUrl,\n        data: data,\n        method: \'POST\',\n        beforeSend: function beforeSend() {\n          _this.spinner.replace(eventTarget(event).parentNode);\n        },\n        complete: function complete() {\n          _this.spinner.remove(eventTarget(event).parentNode);\n        },\n        success: function success(response) {\n          var content = response.content;\n          var isError = response.success === false;\n          !isError && _this.form.releaseFormSubmission();\n\n          _this.scheduleNotice.updateScheduleNoticeWithMessage(content, isError ? \'error\' : \'success\');\n        },\n        error: function error(jqXHR, textStatus, errorThrown) {\n          _this.scheduleNotice.updateScheduleNoticeWithMessage("".concat(textStatus, " : ").concat(errorThrown), \'error\');\n        }\n      });\n    }\n  }]);\n\n  return StopAttachmentDuplicationProcessAction;\n}();\n\nfunction eventTarget(event) {\n  return event.currentTarget || event.target;\n}\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleArguments.js\nfunction ScheduleArguments_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar ScheduleArguments = function ScheduleArguments(sourceSiteId, newSiteId, attachmentsNumber) {\n  ScheduleArguments_classCallCheck(this, ScheduleArguments);\n\n  // TODO Must throw if given values are not what we expect.\n  //      The same have to do the other classes with their properties\n  this.sourceSiteId = sourceSiteId;\n  this.newSiteId = newSiteId;\n  this.attachmentsNumber = attachmentsNumber;\n};\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/Schedule.js\nfunction Schedule_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar Schedule = function Schedule(id, stepsDone, allSteps, started, lastUpdate, scheduleArguments) {\n  Schedule_classCallCheck(this, Schedule);\n\n  this.id = id;\n  this.stepsDone = stepsDone;\n  this.allSteps = allSteps;\n  this.started = started;\n  this.lastUpdate = lastUpdate;\n  this.scheduleArguments = scheduleArguments;\n};\n// CONCATENATED MODULE: ./resources/js/siteDuplication/schedule/ScheduleFactory.js\nfunction ScheduleFactory_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleFactory_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleFactory_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleFactory_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleFactory_defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\nvar ScheduleFactory_ScheduleFactory =\n/*#__PURE__*/\nfunction () {\n  function ScheduleFactory() {\n    ScheduleFactory_classCallCheck(this, ScheduleFactory);\n  }\n\n  ScheduleFactory_createClass(ScheduleFactory, [{\n    key: "create",\n\n    /**\n     * @param scheduleData\n     * @returns {Schedule}\n     */\n    value: function create(scheduleData) {\n      var id = scheduleData.id,\n          stepsDone = scheduleData.stepsDone,\n          allSteps = scheduleData.allSteps,\n          started = scheduleData.started,\n          lastUpdate = scheduleData.lastUpdate,\n          args = scheduleData.args;\n      var scheduleArguments = createScheduleArguments(args);\n      return new Schedule(id, stepsDone, allSteps, started, lastUpdate, scheduleArguments);\n    }\n  }]);\n\n  return ScheduleFactory;\n}();\n/**\n * @param {*} args\n * @returns {ScheduleArguments}\n */\n\nfunction createScheduleArguments(args) {\n  var _ref = args || {},\n      sourceSiteId = _ref.sourceSiteId,\n      newSiteId = _ref.newSiteId,\n      attachmentsNumber = _ref.attachmentsNumber;\n\n  return new ScheduleArguments(sourceSiteId, newSiteId, attachmentsNumber);\n}\n// CONCATENATED MODULE: ./resources/js/siteDuplication/admin.js\n\n\n\n\n\n\n\n\n\n\n\n(function (jQuery, adminpage, siteDuplicatorScheduleData) {\n  /**\n   * Create the admin notice UI where to show the information about the current\n   * tasks performed by the server.\n   *\n   * @returns {*}\n   */\n  function initializeScheduleNoticeUI() {\n    var scheduleNoticeTemplate = document.querySelector(\'#mlp_new_site_schedule_tmpl\');\n\n    if (!scheduleNoticeTemplate) {\n      return undefined;\n    }\n\n    document.querySelector(\'#add-new-site\').insertAdjacentHTML(\'afterend\', scheduleNoticeTemplate.innerHTML);\n  }\n  /**\n   * ScheduleNoticeHtmlElement Factory\n   *\n   * @returns {ScheduleNoticeHtmlElement}\n   */\n\n\n  function scheduleNoticeHtmlElementFactory() {\n    var scheduleNoticeHtmlElement = document.querySelector(\'.mlp-attachment-schedule-notice\');\n\n    if (!scheduleNoticeHtmlElement) {\n      throw new TypeError(\'Impossible to retrieve the schedule notice html element. Element does not exists\');\n    }\n\n    scheduleNoticeHtmlElement = new ScheduleNoticeHtmlElement(scheduleNoticeHtmlElement);\n    return scheduleNoticeHtmlElement;\n  }\n  /**\n   * @returns {HTMLFormElement}\n   */\n\n\n  function formHtmlElementFactory() {\n    // TODO May be a better selector to prevent to get wrong form\n    var formHtmlElement = document.querySelector(\'form\');\n\n    if (!formHtmlElement) {\n      throw new TypeError(\'No form exists in this page.\');\n    }\n\n    return formHtmlElement;\n  }\n  /**\n   * @returns {*}\n   */\n\n\n  function translationsFactory() {\n    var hasTranslations = siteDuplicatorScheduleData.hasOwnProperty(\'attachmentDuplicatorTranslations\');\n\n    if (!hasTranslations) {\n      throw new Error(\'Translations for Site Duplication Schedule are missing\');\n    }\n\n    return siteDuplicatorScheduleData.attachmentDuplicatorTranslations;\n  }\n  /**\n   * @returns {*}\n   */\n\n\n  function initializeContainer() {\n    var scheduleUrl = siteDuplicatorScheduleData.scheduleUrl,\n        _siteDuplicatorSchedu = siteDuplicatorScheduleData.ajaxUrl,\n        ajaxUrl = _siteDuplicatorSchedu === void 0 ? \'\' : _siteDuplicatorSchedu; // TODO Create a lazy loader container because right know dependencies have to be\n    //      created before them are used and maintenance will be difficult.\n\n    if (!ajaxUrl) {\n      throw new TypeError(\'ajaxUrl must be set or schedule notice will not work\');\n    }\n\n    var translations = translationsFactory();\n    var form = new Form_Form(jQuery, formHtmlElementFactory(), translations);\n    var eventDispatcher = new EventDispatcher(jQuery);\n    var spinner = new Spinner();\n    var scheduleFactory = new ScheduleFactory_ScheduleFactory();\n    var scheduleNoticeHtmlElement = scheduleNoticeHtmlElementFactory();\n    var scheduleNotice = new ScheduleNotice(jQuery, eventDispatcher, scheduleNoticeHtmlElement);\n    var scheduleStatusFactory = new ScheduleStatusFactory_ScheduleStatusFactory(scheduleFactory);\n    var scheduleStatusResponseHandler = new ScheduleStatusResponseHandler(scheduleNotice, eventDispatcher, scheduleStatusFactory, form, translations);\n    var scheduleStatusRequest = new ScheduleStatusRequest(jQuery, scheduleNotice, scheduleStatusResponseHandler, form, scheduleUrl);\n    var _siteDuplicatorSchedu2 = siteDuplicatorScheduleData.attachmentDuplicatorActions,\n        nonce = _siteDuplicatorSchedu2.nonce,\n        nonceAction = _siteDuplicatorSchedu2.nonceAction,\n        nameAjaxHook = _siteDuplicatorSchedu2.nameAjaxHook;\n    var stopAttachmentDuplicationProcessAction = new StopAttachmentDuplicationProcessAction(jQuery, scheduleNotice, scheduleStatusRequest, form, spinner, ajaxUrl, nonce, nonceAction, nameAjaxHook);\n    return {\n      scheduleNoticeHtmlElement: scheduleNoticeHtmlElement,\n      scheduleNotice: scheduleNotice,\n      eventDispatcher: eventDispatcher,\n      scheduleStatusFactory: scheduleStatusFactory,\n      form: form,\n      translations: translations,\n      scheduleStatusResponseHandler: scheduleStatusResponseHandler,\n      scheduleStatusRequest: scheduleStatusRequest,\n      spinner: spinner,\n      ajaxUrl: ajaxUrl,\n      stopAttachmentDuplicationProcessAction: stopAttachmentDuplicationProcessAction\n    };\n  }\n  /**\n   * Bootstrap Schedule Actions\n   *\n   * @params {*} container\n   *\n   * @returns void\n   */\n\n\n  function bootstrapScheduleActions(container) {\n    var stopAttachmentDuplicationProcessAction = container.stopAttachmentDuplicationProcessAction;\n    var remover = document.querySelector(\'#mlp_kill_attachment_duplication\');\n    remover && remover.addEventListener(\'click\', function (evt) {\n      return stopAttachmentDuplicationProcessAction.stopDuplication(evt);\n    });\n  }\n  /**\n   * Bootstrap the package\n   *\n   * @returns void\n   */\n\n\n  function bootstrap(container) {\n    var scheduleNotice = container.scheduleNotice,\n        scheduleStatusRequest = container.scheduleStatusRequest,\n        scheduleNoticeHtmlElement = container.scheduleNoticeHtmlElement;\n    scheduleNotice.hide();\n    window.addEventListener(\'load\', function () {\n      return scheduleStatusRequest.status();\n    }, {\n      once: true\n    });\n    jQuery(document).on( // TODO Why constant wont work\n    \'multilingualpress.schedule_notice_updated\', function (evt, schedule) {\n      var scheduleJson = JSON.stringify(schedule);\n      scheduleNoticeHtmlElement.htmlElement.dataset.currentSchedule = scheduleJson;\n    });\n    bootstrapScheduleActions(container);\n  }\n\n  if (adminpage !== \'site-new-php\') {\n    return;\n  }\n\n  if (!siteDuplicatorScheduleData) {\n    console.warn(\'No schedule data available, duplication notice will not work as expected.\');\n    return;\n  }\n\n  initializeScheduleNoticeUI();\n\n  try {\n    var container = initializeContainer();\n    bootstrap(container);\n  } catch (error) {\n    console.warn(error.message);\n  }\n})(jQuery, adminpage, window.siteDuplicatorScheduleData);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///0\n')}]);
//# sourceMappingURL=site-duplication-admin.min.js.map