<?php
namespace Inpsyde\MultilingualPress;

const AUTOLOAD_MAP = [
    Framework\Admin\AdminNotice::class => '/src/framework/Admin/AdminNotice.php',
    Framework\Admin\EditSiteTab::class => '/src/framework/Admin/EditSiteTab.php',
    Framework\Admin\Metabox\Action::class => '/src/framework/Admin/Metabox/Action.php',
    Framework\Admin\Metabox\Auth::class => '/src/framework/Admin/Metabox/Auth.php',
    Framework\Admin\Metabox\Entity::class => '/src/framework/Admin/Metabox/Entity.php',
    Framework\Admin\Metabox\Info::class => '/src/framework/Admin/Metabox/Info.php',
    Framework\Admin\Metabox\Metabox::class => '/src/framework/Admin/Metabox/Metabox.php',
    Framework\Admin\Metabox\Metaboxes::class => '/src/framework/Admin/Metabox/Metaboxes.php',
    Framework\Admin\Metabox\NoopAction::class => '/src/framework/Admin/Metabox/NoopAction.php',
    Framework\Admin\Metabox\NoopView::class => '/src/framework/Admin/Metabox/NoopView.php',
    Framework\Admin\Metabox\PostAuth::class => '/src/framework/Admin/Metabox/PostAuth.php',
    Framework\Admin\Metabox\PostMetabox::class => '/src/framework/Admin/Metabox/PostMetabox.php',
    Framework\Admin\Metabox\TermAuth::class => '/src/framework/Admin/Metabox/TermAuth.php',
    Framework\Admin\Metabox\TermMetabox::class => '/src/framework/Admin/Metabox/TermMetabox.php',
    Framework\Admin\Metabox\View::class => '/src/framework/Admin/Metabox/View.php',
    Framework\Admin\PersistentAdminNotices::class => '/src/framework/Admin/PersistentAdminNotices.php',
    Framework\Admin\SettingsPage::class => '/src/framework/Admin/SettingsPage.php',
    Framework\Admin\SettingsPageTab::class => '/src/framework/Admin/SettingsPageTab.php',
    Framework\Admin\SettingsPageTabData::class => '/src/framework/Admin/SettingsPageTabData.php',
    Framework\Admin\SettingsPageTabDataAccess::class => '/src/framework/Admin/SettingsPageTabDataAccess.php',
    Framework\Admin\SettingsPageView::class => '/src/framework/Admin/SettingsPageView.php',
    Framework\Admin\SitesListTableColumn::class => '/src/framework/Admin/SitesListTableColumn.php',
    Framework\Api\ContentRelations::class => '/src/framework/Api/ContentRelations.php',
    Framework\Api\Languages::class => '/src/framework/Api/Languages.php',
    Framework\Api\SiteRelations::class => '/src/framework/Api/SiteRelations.php',
    Framework\Api\Translation::class => '/src/framework/Api/Translation.php',
    Framework\Api\Translations::class => '/src/framework/Api/Translations.php',
    Framework\Api\TranslationSearchArgs::class => '/src/framework/Api/TranslationSearchArgs.php',
    Framework\Asset\Asset::class => '/src/framework/Asset/Asset.php',
    Framework\Asset\AssetLocation::class => '/src/framework/Asset/AssetLocation.php',
    Framework\Asset\AssetManager::class => '/src/framework/Asset/AssetManager.php',
    Framework\Asset\AssetUrl::class => '/src/framework/Asset/AssetUrl.php',
    Framework\Asset\MaybeMinifiedAssetUrl::class => '/src/framework/Asset/MaybeMinifiedAssetUrl.php',
    Framework\Asset\Script::class => '/src/framework/Asset/Script.php',
    Framework\Asset\Style::class => '/src/framework/Asset/Style.php',
    Framework\BasePathAdapter::class => '/src/framework/BasePathAdapter.php',
    Framework\Cache\CacheFactory::class => '/src/framework/Cache/CacheFactory.php',
    Framework\Cache\Driver\CacheDriver::class => '/src/framework/Cache/Driver/CacheDriver.php',
    Framework\Cache\Driver\EphemeralCacheDriver::class => '/src/framework/Cache/Driver/EphemeralCacheDriver.php',
    Framework\Cache\Driver\WpObjectCacheDriver::class => '/src/framework/Cache/Driver/WpObjectCacheDriver.php',
    Framework\Cache\Driver\WpTransientDriver::class => '/src/framework/Cache/Driver/WpTransientDriver.php',
    Framework\Cache\Exception\BadCacheItemRegistration::class => '/src/framework/Cache/Exception/BadCacheItemRegistration.php',
    Framework\Cache\Exception\Exception::class => '/src/framework/Cache/Exception/Exception.php',
    Framework\Cache\Exception\InvalidCacheArgument::class => '/src/framework/Cache/Exception/InvalidCacheArgument.php',
    Framework\Cache\Exception\InvalidCacheDriver::class => '/src/framework/Cache/Exception/InvalidCacheDriver.php',
    Framework\Cache\Exception\NotRegisteredCacheItem::class => '/src/framework/Cache/Exception/NotRegisteredCacheItem.php',
    Framework\Cache\Item\CacheItem::class => '/src/framework/Cache/Item/CacheItem.php',
    Framework\Cache\Item\Value::class => '/src/framework/Cache/Item/Value.php',
    Framework\Cache\Item\WpCacheItem::class => '/src/framework/Cache/Item/WpCacheItem.php',
    Framework\Cache\Pool\CachePool::class => '/src/framework/Cache/Pool/CachePool.php',
    Framework\Cache\Pool\WpCachePool::class => '/src/framework/Cache/Pool/WpCachePool.php',
    Framework\Cache\Server\Facade::class => '/src/framework/Cache/Server/Facade.php',
    Framework\Cache\Server\ItemLogic::class => '/src/framework/Cache/Server/ItemLogic.php',
    Framework\Cache\Server\Server::class => '/src/framework/Cache/Server/Server.php',
    Framework\Database\Exception\InvalidTable::class => '/src/framework/Database/Exception/InvalidTable.php',
    Framework\Database\Exception\NonexistentTable::class => '/src/framework/Database/Exception/NonexistentTable.php',
    Framework\Database\Table::class => '/src/framework/Database/Table.php',
    Framework\Database\TableDuplicator::class => '/src/framework/Database/TableDuplicator.php',
    Framework\Database\TableInstaller::class => '/src/framework/Database/TableInstaller.php',
    Framework\Database\TableList::class => '/src/framework/Database/TableList.php',
    Framework\Database\TableReplacer::class => '/src/framework/Database/TableReplacer.php',
    Framework\Database\TableStringReplacer::class => '/src/framework/Database/TableStringReplacer.php',
    Framework\Factory\ClassResolver::class => '/src/framework/Factory/ClassResolver.php',
    Framework\Factory\ErrorFactory::class => '/src/framework/Factory/ErrorFactory.php',
    Framework\Factory\Exception\InvalidClass::class => '/src/framework/Factory/Exception/InvalidClass.php',
    Framework\Factory\LanguageFactory::class => '/src/framework/Factory/LanguageFactory.php',
    Framework\Factory\NonceFactory::class => '/src/framework/Factory/NonceFactory.php',
    Framework\Factory\UrlFactory::class => '/src/framework/Factory/UrlFactory.php',
    Framework\Filesystem::class => '/src/framework/Filesystem.php',
    Framework\Filter\Filter::class => '/src/framework/Filter/Filter.php',
    Framework\Filter\FilterTrait::class => '/src/framework/Filter/FilterTrait.php',
    Framework\Http\PhpServerRequest::class => '/src/framework/Http/PhpServerRequest.php',
    Framework\Http\Request::class => '/src/framework/Http/Request.php',
    Framework\Http\RequestGlobalsManipulator::class => '/src/framework/Http/RequestGlobalsManipulator.php',
    Framework\Http\ServerRequest::class => '/src/framework/Http/ServerRequest.php',
    Framework\Http\ServerUrl::class => '/src/framework/Http/ServerUrl.php',
    Framework\Integration\Integration::class => '/src/framework/Integration/Integration.php',
    Framework\Language\Language::class => '/src/framework/Language/Language.php',
    Framework\Language\NullLanguage::class => '/src/framework/Language/NullLanguage.php',
    Framework\Module\Exception\InvalidModule::class => '/src/framework/Module/Exception/InvalidModule.php',
    Framework\Module\Exception\ModuleAlreadyRegistered::class => '/src/framework/Module/Exception/ModuleAlreadyRegistered.php',
    Framework\Module\FileLocator::class => '/src/framework/Module/FileLocator.php',
    Framework\Module\Module::class => '/src/framework/Module/Module.php',
    Framework\Module\ModuleLocator::class => '/src/framework/Module/ModuleLocator.php',
    Framework\Module\ModuleManager::class => '/src/framework/Module/ModuleManager.php',
    Framework\Module\ModuleServiceProvider::class => '/src/framework/Module/ModuleServiceProvider.php',
    Framework\NetworkState::class => '/src/framework/NetworkState.php',
    Framework\Nonce\ArrayContext::class => '/src/framework/Nonce/ArrayContext.php',
    Framework\Nonce\Context::class => '/src/framework/Nonce/Context.php',
    Framework\Nonce\Exception\ContextValueManipulationNotAllowed::class => '/src/framework/Nonce/Exception/ContextValueManipulationNotAllowed.php',
    Framework\Nonce\Exception\ContextValueNotSet::class => '/src/framework/Nonce/Exception/ContextValueNotSet.php',
    Framework\Nonce\Nonce::class => '/src/framework/Nonce/Nonce.php',
    Framework\Nonce\ReadOnlyContextTrait::class => '/src/framework/Nonce/ReadOnlyContextTrait.php',
    Framework\Nonce\ServerRequestContext::class => '/src/framework/Nonce/ServerRequestContext.php',
    Framework\Nonce\SiteAwareNonce::class => '/src/framework/Nonce/SiteAwareNonce.php',
    Framework\Nonce\WpNonce::class => '/src/framework/Nonce/WpNonce.php',
    Framework\PluginProperties::class => '/src/framework/PluginProperties.php',
    Framework\SemanticVersionNumber::class => '/src/framework/SemanticVersionNumber.php',
    Framework\Service\BootstrappableServiceProvider::class => '/src/framework/Service/BootstrappableServiceProvider.php',
    Framework\Service\Container::class => '/src/framework/Service/Container.php',
    Framework\Service\Exception\ContainerException::class => '/src/framework/Service/Exception/ContainerException.php',
    Framework\Service\Exception\ExtendingResolvedNotAllowed::class => '/src/framework/Service/Exception/ExtendingResolvedNotAllowed.php',
    Framework\Service\Exception\InvalidValueAccess::class => '/src/framework/Service/Exception/InvalidValueAccess.php',
    Framework\Service\Exception\InvalidValueReadAccess::class => '/src/framework/Service/Exception/InvalidValueReadAccess.php',
    Framework\Service\Exception\LateAccessToNotSharedService::class => '/src/framework/Service/Exception/LateAccessToNotSharedService.php',
    Framework\Service\Exception\NameNotFound::class => '/src/framework/Service/Exception/NameNotFound.php',
    Framework\Service\Exception\NameOverwriteNotAllowed::class => '/src/framework/Service/Exception/NameOverwriteNotAllowed.php',
    Framework\Service\Exception\UnsetNotAllowed::class => '/src/framework/Service/Exception/UnsetNotAllowed.php',
    Framework\Service\Exception\WriteAccessOnLockedContainer::class => '/src/framework/Service/Exception/WriteAccessOnLockedContainer.php',
    Framework\Service\IntegrationServiceProvider::class => '/src/framework/Service/IntegrationServiceProvider.php',
    Framework\Service\ServiceProvider::class => '/src/framework/Service/ServiceProvider.php',
    Framework\Service\ServiceProvidersCollection::class => '/src/framework/Service/ServiceProvidersCollection.php',
    Framework\Setting\SettingsBoxView::class => '/src/framework/Setting/SettingsBoxView.php',
    Framework\Setting\SettingsBoxViewModel::class => '/src/framework/Setting/SettingsBoxViewModel.php',
    Framework\Setting\Site\SiteSetting::class => '/src/framework/Setting/Site/SiteSetting.php',
    Framework\Setting\Site\SiteSettingMultiView::class => '/src/framework/Setting/Site/SiteSettingMultiView.php',
    Framework\Setting\Site\SiteSettingSingleView::class => '/src/framework/Setting/Site/SiteSettingSingleView.php',
    Framework\Setting\Site\SiteSettingsSectionView::class => '/src/framework/Setting/Site/SiteSettingsSectionView.php',
    Framework\Setting\Site\SiteSettingsSectionViewModel::class => '/src/framework/Setting/Site/SiteSettingsSectionViewModel.php',
    Framework\Setting\Site\SiteSettingUpdater::class => '/src/framework/Setting/Site/SiteSettingUpdater.php',
    Framework\Setting\Site\SiteSettingView::class => '/src/framework/Setting/Site/SiteSettingView.php',
    Framework\Setting\Site\SiteSettingViewModel::class => '/src/framework/Setting/Site/SiteSettingViewModel.php',
    Framework\Setting\SiteSettingsUpdatable::class => '/src/framework/Setting/SiteSettingsUpdatable.php',
    Framework\Setting\User\UserSetting::class => '/src/framework/Setting/User/UserSetting.php',
    Framework\Setting\User\UserSettingUpdater::class => '/src/framework/Setting/User/UserSettingUpdater.php',
    Framework\Setting\User\UserSettingView::class => '/src/framework/Setting/User/UserSettingView.php',
    Framework\Setting\User\UserSettingViewModel::class => '/src/framework/Setting/User/UserSettingViewModel.php',
    Framework\SwitchSiteTrait::class => '/src/framework/SwitchSiteTrait.php',
    Framework\Translator\NullTranslator::class => '/src/framework/Translator/NullTranslator.php',
    Framework\Translator\Translator::class => '/src/framework/Translator/Translator.php',
    Framework\Url\EscapedUrl::class => '/src/framework/Url/EscapedUrl.php',
    Framework\Url\Url::class => '/src/framework/Url/Url.php',
    Framework\Widget\Dashboard\Options::class => '/src/framework/Widget/Dashboard/Options.php',
    Framework\Widget\Dashboard\View::class => '/src/framework/Widget/Dashboard/View.php',
    Framework\Widget\Dashboard\Widget::class => '/src/framework/Widget/Dashboard/Widget.php',
    Framework\Widget\Sidebar\SelfRegisteringWidgetTrait::class => '/src/framework/Widget/Sidebar/SelfRegisteringWidgetTrait.php',
    Framework\Widget\Sidebar\View::class => '/src/framework/Widget/Sidebar/View.php',
    Framework\Widget\Sidebar\Widget::class => '/src/framework/Widget/Sidebar/Widget.php',
    Framework\WordpressContext::class => '/src/framework/WordpressContext.php',
    Module\AltLanguageTitleInAdminBar\AdminBarCustomizer::class => '/src/modules/AltLanguageTitleInAdminBar/AdminBarCustomizer.php',
    Module\AltLanguageTitleInAdminBar\ServiceProvider::class => '/src/modules/AltLanguageTitleInAdminBar/ServiceProvider.php',
    Module\AltLanguageTitleInAdminBar\SettingsRepository::class => '/src/modules/AltLanguageTitleInAdminBar/SettingsRepository.php',
    Module\LanguageManager\Db::class => '/src/modules/LanguageManager/Db.php',
    Module\LanguageManager\LanguageInstaller::class => '/src/modules/LanguageManager/LanguageInstaller.php',
    Module\LanguageManager\PageView::class => '/src/modules/LanguageManager/PageView.php',
    Module\LanguageManager\RequestHandler::class => '/src/modules/LanguageManager/RequestHandler.php',
    Module\LanguageManager\ServiceProvider::class => '/src/modules/LanguageManager/ServiceProvider.php',
    Module\LanguageManager\TableFormView::class => '/src/modules/LanguageManager/TableFormView.php',
    Module\LanguageManager\Updater::class => '/src/modules/LanguageManager/Updater.php',
    Module\Redirect\AcceptLanguageParser::class => '/src/modules/Redirect/AcceptLanguageParser.php',
    Module\Redirect\JsRedirector::class => '/src/modules/Redirect/JsRedirector.php',
    Module\Redirect\LanguageNegotiator::class => '/src/modules/Redirect/LanguageNegotiator.php',
    Module\Redirect\NoRedirectObjectCacheStorage::class => '/src/modules/Redirect/NoRedirectObjectCacheStorage.php',
    Module\Redirect\NoredirectPermalinkFilter::class => '/src/modules/Redirect/NoredirectPermalinkFilter.php',
    Module\Redirect\NoRedirectSessionStorage::class => '/src/modules/Redirect/NoRedirectSessionStorage.php',
    Module\Redirect\NoRedirectStorage::class => '/src/modules/Redirect/NoRedirectStorage.php',
    Module\Redirect\PhpRedirector::class => '/src/modules/Redirect/PhpRedirector.php',
    Module\Redirect\Redirector::class => '/src/modules/Redirect/Redirector.php',
    Module\Redirect\RedirectRequestChecker::class => '/src/modules/Redirect/RedirectRequestChecker.php',
    Module\Redirect\RedirectSiteSetting::class => '/src/modules/Redirect/RedirectSiteSetting.php',
    Module\Redirect\RedirectTarget::class => '/src/modules/Redirect/RedirectTarget.php',
    Module\Redirect\RedirectUserSetting::class => '/src/modules/Redirect/RedirectUserSetting.php',
    Module\Redirect\ServiceProvider::class => '/src/modules/Redirect/ServiceProvider.php',
    Module\Redirect\SettingsRepository::class => '/src/modules/Redirect/SettingsRepository.php',
    Module\Trasher\ServiceProvider::class => '/src/modules/Trasher/ServiceProvider.php',
    Module\Trasher\Trasher::class => '/src/modules/Trasher/Trasher.php',
    Module\Trasher\TrasherSettingRepository::class => '/src/modules/Trasher/TrasherSettingRepository.php',
    Module\Trasher\TrasherSettingUpdater::class => '/src/modules/Trasher/TrasherSettingUpdater.php',
    Module\Trasher\TrasherSettingView::class => '/src/modules/Trasher/TrasherSettingView.php',
    Module\WooCommerce\ArchiveProducts::class => '/src/modules/WooCommerce/ArchiveProducts.php',
    Module\WooCommerce\AttributesRelationship::class => '/src/modules/WooCommerce/AttributesRelationship.php',
    Module\WooCommerce\AttributeTermTranslateUrl::class => '/src/modules/WooCommerce/AttributeTermTranslateUrl.php',
    Module\WooCommerce\AvailableTaxonomiesAttributes::class => '/src/modules/WooCommerce/AvailableTaxonomiesAttributes.php',
    Module\WooCommerce\PermalinkStructure::class => '/src/modules/WooCommerce/PermalinkStructure.php',
    Module\WooCommerce\ProductMetaboxesBehaviorActivator::class => '/src/modules/WooCommerce/ProductMetaboxesBehaviorActivator.php',
    Module\WooCommerce\ServiceProvider::class => '/src/modules/WooCommerce/ServiceProvider.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideAttributes::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideAttributes.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideCrossellsProducts::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideCrossellsProducts.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideDownloadableFiles::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideDownloadableFiles.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideGroupedProducts::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideGroupedProducts.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideProductGallery::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideProductGallery.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideProductType::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideProductType.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideUpsellsProducts::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideUpsellsProducts.php',
    Module\WooCommerce\TranslationUi\Product\Field\OverrideVariations::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/OverrideVariations.php',
    Module\WooCommerce\TranslationUi\Product\Field\ProductUrl::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/ProductUrl.php',
    Module\WooCommerce\TranslationUi\Product\Field\ProductUrlButtonText::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/ProductUrlButtonText.php',
    Module\WooCommerce\TranslationUi\Product\Field\PurchaseNote::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/PurchaseNote.php',
    Module\WooCommerce\TranslationUi\Product\Field\RegularPrice::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/RegularPrice.php',
    Module\WooCommerce\TranslationUi\Product\Field\SalePrice::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/SalePrice.php',
    Module\WooCommerce\TranslationUi\Product\Field\ShortDescription::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/ShortDescription.php',
    Module\WooCommerce\TranslationUi\Product\Field\Sku::class => '/src/modules/WooCommerce/TranslationUi/Product/Field/Sku.php',
    Module\WooCommerce\TranslationUi\Product\FieldsAwareOfProductType::class => '/src/modules/WooCommerce/TranslationUi/Product/FieldsAwareOfProductType.php',
    Module\WooCommerce\TranslationUi\Product\MetaboxAction::class => '/src/modules/WooCommerce/TranslationUi/Product/MetaboxAction.php',
    Module\WooCommerce\TranslationUi\Product\MetaboxField::class => '/src/modules/WooCommerce/TranslationUi/Product/MetaboxField.php',
    Module\WooCommerce\TranslationUi\Product\MetaboxFields::class => '/src/modules/WooCommerce/TranslationUi/Product/MetaboxFields.php',
    Module\WooCommerce\TranslationUi\Product\MetaboxTab::class => '/src/modules/WooCommerce/TranslationUi/Product/MetaboxTab.php',
    Module\WooCommerce\TranslationUi\Product\PanelView::class => '/src/modules/WooCommerce/TranslationUi/Product/PanelView.php',
    Module\WooCommerce\TranslationUi\Product\ProductRelationSaveHelper::class => '/src/modules/WooCommerce/TranslationUi/Product/ProductRelationSaveHelper.php',
    Module\WooCommerce\TranslationUi\Product\SettingView::class => '/src/modules/WooCommerce/TranslationUi/Product/SettingView.php',
    Module\WooCommerce\TranslationUi\Product\WooCommerceMetaboxField::class => '/src/modules/WooCommerce/TranslationUi/Product/WooCommerceMetaboxField.php',
    Module\WooCommerce\TranslationUi\Product\WooCommerceMetaboxFields::class => '/src/modules/WooCommerce/TranslationUi/Product/WooCommerceMetaboxFields.php',
    Activation\Activator::class => '/src/multilingualpress/Activation/Activator.php',
    Activation\ServiceProvider::class => '/src/multilingualpress/Activation/ServiceProvider.php',
    Api\ServiceProvider::class => '/src/multilingualpress/Api/ServiceProvider.php',
    Api\Translations::class => '/src/multilingualpress/Api/Translations.php',
    Api\WpdbContentRelations::class => '/src/multilingualpress/Api/WpdbContentRelations.php',
    Api\WpdbLanguages::class => '/src/multilingualpress/Api/WpdbLanguages.php',
    Api\WpdbSiteRelations::class => '/src/multilingualpress/Api/WpdbSiteRelations.php',
    Asset\AssetFactory::class => '/src/multilingualpress/Asset/AssetFactory.php',
    Asset\ServiceProvider::class => '/src/multilingualpress/Asset/ServiceProvider.php',
    Asset\StandardWpScript::class => '/src/multilingualpress/Asset/StandardWpScript.php',
    Asset\StandardWpStyle::class => '/src/multilingualpress/Asset/StandardWpStyle.php',
    Attachment\AttachmentData::class => '/src/multilingualpress/Attachment/AttachmentData.php',
    Attachment\Collection::class => '/src/multilingualpress/Attachment/Collection.php',
    Attachment\Copier::class => '/src/multilingualpress/Attachment/Copier.php',
    Attachment\DatabaseDataReplacer::class => '/src/multilingualpress/Attachment/DatabaseDataReplacer.php',
    Attachment\Duplicator::class => '/src/multilingualpress/Attachment/Duplicator.php',
    Cache\NavMenuItemsSerializer::class => '/src/multilingualpress/Cache/NavMenuItemsSerializer.php',
    Cache\ServiceProvider::class => '/src/multilingualpress/Cache/ServiceProvider.php',
    Core\Admin\AltLanguageTitleSiteSetting::class => '/src/multilingualpress/Core/Admin/AltLanguageTitleSiteSetting.php',
    Core\Admin\LanguagesAjaxSearch::class => '/src/multilingualpress/Core/Admin/LanguagesAjaxSearch.php',
    Core\Admin\LanguageSiteSetting::class => '/src/multilingualpress/Core/Admin/LanguageSiteSetting.php',
    Core\Admin\LicenseSettingsTabView::class => '/src/multilingualpress/Core/Admin/LicenseSettingsTabView.php',
    Core\Admin\LicenseSettingsUpdater::class => '/src/multilingualpress/Core/Admin/LicenseSettingsUpdater.php',
    Core\Admin\ModuleSettingsTabView::class => '/src/multilingualpress/Core/Admin/ModuleSettingsTabView.php',
    Core\Admin\ModuleSettingsUpdater::class => '/src/multilingualpress/Core/Admin/ModuleSettingsUpdater.php',
    Core\Admin\NewSiteSettings::class => '/src/multilingualpress/Core/Admin/NewSiteSettings.php',
    Core\Admin\PluginSettingsPageView::class => '/src/multilingualpress/Core/Admin/PluginSettingsPageView.php',
    Core\Admin\PluginSettingsUpdater::class => '/src/multilingualpress/Core/Admin/PluginSettingsUpdater.php',
    Core\Admin\Pointers\Pointers::class => '/src/multilingualpress/Core/Admin/Pointers/Pointers.php',
    Core\Admin\Pointers\Repository::class => '/src/multilingualpress/Core/Admin/Pointers/Repository.php',
    Core\Admin\PostTypeSettingsTabView::class => '/src/multilingualpress/Core/Admin/PostTypeSettingsTabView.php',
    Core\Admin\PostTypeSettingsUpdater::class => '/src/multilingualpress/Core/Admin/PostTypeSettingsUpdater.php',
    Core\Admin\PostTypeSlugSetting::class => '/src/multilingualpress/Core/Admin/PostTypeSlugSetting.php',
    Core\Admin\PostTypeSlugsSettingsRepository::class => '/src/multilingualpress/Core/Admin/PostTypeSlugsSettingsRepository.php',
    Core\Admin\PostTypeSlugsSettingsSectionView::class => '/src/multilingualpress/Core/Admin/PostTypeSlugsSettingsSectionView.php',
    Core\Admin\PostTypeSlugsSettingsTabView::class => '/src/multilingualpress/Core/Admin/PostTypeSlugsSettingsTabView.php',
    Core\Admin\PostTypeSlugsSettingsUpdater::class => '/src/multilingualpress/Core/Admin/PostTypeSlugsSettingsUpdater.php',
    Core\Admin\PostTypeSlugsSettingsUpdateRequestHandler::class => '/src/multilingualpress/Core/Admin/PostTypeSlugsSettingsUpdateRequestHandler.php',
    Core\Admin\RelationshipsSiteSetting::class => '/src/multilingualpress/Core/Admin/RelationshipsSiteSetting.php',
    Core\Admin\Screen::class => '/src/multilingualpress/Core/Admin/Screen.php',
    Core\Admin\SettingsPageTabsBuilder::class => '/src/multilingualpress/Core/Admin/SettingsPageTabsBuilder.php',
    Core\Admin\SiteSettings::class => '/src/multilingualpress/Core/Admin/SiteSettings.php',
    Core\Admin\SiteSettingsRepository::class => '/src/multilingualpress/Core/Admin/SiteSettingsRepository.php',
    Core\Admin\SiteSettingsRepositoryTrait::class => '/src/multilingualpress/Core/Admin/SiteSettingsRepositoryTrait.php',
    Core\Admin\SiteSettingsTabView::class => '/src/multilingualpress/Core/Admin/SiteSettingsTabView.php',
    Core\Admin\SiteSettingsUpdater::class => '/src/multilingualpress/Core/Admin/SiteSettingsUpdater.php',
    Core\Admin\SiteSettingsUpdateRequestHandler::class => '/src/multilingualpress/Core/Admin/SiteSettingsUpdateRequestHandler.php',
    Core\Admin\TaxonomySettingsTabView::class => '/src/multilingualpress/Core/Admin/TaxonomySettingsTabView.php',
    Core\Admin\TaxonomySettingsUpdater::class => '/src/multilingualpress/Core/Admin/TaxonomySettingsUpdater.php',
    Core\Admin\XDefaultSiteSetting::class => '/src/multilingualpress/Core/Admin/XDefaultSiteSetting.php',
    Core\Entity\ActivePostTypes::class => '/src/multilingualpress/Core/Entity/ActivePostTypes.php',
    Core\Entity\ActiveTaxonomies::class => '/src/multilingualpress/Core/Entity/ActiveTaxonomies.php',
    Core\Frontend\AlternateLanguages::class => '/src/multilingualpress/Core/Frontend/AlternateLanguages.php',
    Core\Frontend\AltLanguageController::class => '/src/multilingualpress/Core/Frontend/AltLanguageController.php',
    Core\Frontend\AltLanguageHtmlLinkTagRenderer::class => '/src/multilingualpress/Core/Frontend/AltLanguageHtmlLinkTagRenderer.php',
    Core\Frontend\AltLanguageHttpHeaderRenderer::class => '/src/multilingualpress/Core/Frontend/AltLanguageHttpHeaderRenderer.php',
    Core\Frontend\AltLanguageRenderer::class => '/src/multilingualpress/Core/Frontend/AltLanguageRenderer.php',
    Core\Frontend\PostTypeLinkUrlFilter::class => '/src/multilingualpress/Core/Frontend/PostTypeLinkUrlFilter.php',
    Core\License\Activator::class => '/src/multilingualpress/Core/License/Activator.php',
    Core\License\Settings::class => '/src/multilingualpress/Core/License/Settings.php',
    Core\License\Updater::class => '/src/multilingualpress/Core/License/Updater.php',
    Core\License\Value::class => '/src/multilingualpress/Core/License/Value.php',
    Core\Locations::class => '/src/multilingualpress/Core/Locations.php',
    Core\ModuleDeactivator::class => '/src/multilingualpress/Core/ModuleDeactivator.php',
    Core\PostTypeRepository::class => '/src/multilingualpress/Core/PostTypeRepository.php',
    Core\ServiceProvider::class => '/src/multilingualpress/Core/ServiceProvider.php',
    Core\SiteDataDeletor::class => '/src/multilingualpress/Core/SiteDataDeletor.php',
    Core\TaxonomyRepository::class => '/src/multilingualpress/Core/TaxonomyRepository.php',
    Database\ServiceProvider::class => '/src/multilingualpress/Database/ServiceProvider.php',
    Database\Table\ContentRelationsTable::class => '/src/multilingualpress/Database/Table/ContentRelationsTable.php',
    Database\Table\LanguagesTable::class => '/src/multilingualpress/Database/Table/LanguagesTable.php',
    Database\Table\RelationshipsTable::class => '/src/multilingualpress/Database/Table/RelationshipsTable.php',
    Database\Table\SiteRelationsTable::class => '/src/multilingualpress/Database/Table/SiteRelationsTable.php',
    Database\Table\TableTrait::class => '/src/multilingualpress/Database/Table/TableTrait.php',
    Factory\ServiceProvider::class => '/src/multilingualpress/Factory/ServiceProvider.php',
    Installation\InstallationChecker::class => '/src/multilingualpress/Installation/InstallationChecker.php',
    Installation\Installer::class => '/src/multilingualpress/Installation/Installer.php',
    Installation\NetworkPluginDeactivator::class => '/src/multilingualpress/Installation/NetworkPluginDeactivator.php',
    Installation\PluginDeactivator::class => '/src/multilingualpress/Installation/PluginDeactivator.php',
    Installation\ServiceProvider::class => '/src/multilingualpress/Installation/ServiceProvider.php',
    Installation\SiteRelationsChecker::class => '/src/multilingualpress/Installation/SiteRelationsChecker.php',
    Installation\SystemChecker::class => '/src/multilingualpress/Installation/SystemChecker.php',
    Installation\Uninstaller::class => '/src/multilingualpress/Installation/Uninstaller.php',
    Installation\Updater::class => '/src/multilingualpress/Installation/Updater.php',
    Integration\ServiceProvider::class => '/src/multilingualpress/Integration/ServiceProvider.php',
    Integration\WpCli::class => '/src/multilingualpress/Integration/WpCli.php',
    Language\EmbeddedLanguage::class => '/src/multilingualpress/Language/EmbeddedLanguage.php',
    Language\Language::class => '/src/multilingualpress/Language/Language.php',
    MultilingualPress::class => '/src/multilingualpress/MultilingualPress.php',
    NavMenu\AjaxHandler::class => '/src/multilingualpress/NavMenu/AjaxHandler.php',
    NavMenu\ItemDeletor::class => '/src/multilingualpress/NavMenu/ItemDeletor.php',
    NavMenu\ItemFilter::class => '/src/multilingualpress/NavMenu/ItemFilter.php',
    NavMenu\ItemRepository::class => '/src/multilingualpress/NavMenu/ItemRepository.php',
    NavMenu\LanguagesMetaboxView::class => '/src/multilingualpress/NavMenu/LanguagesMetaboxView.php',
    NavMenu\ServiceProvider::class => '/src/multilingualpress/NavMenu/ServiceProvider.php',
    Onboarding\Notice::class => '/src/multilingualpress/Onboarding/Notice.php',
    Onboarding\Onboarding::class => '/src/multilingualpress/Onboarding/Onboarding.php',
    Onboarding\ServiceProvider::class => '/src/multilingualpress/Onboarding/ServiceProvider.php',
    Onboarding\State::class => '/src/multilingualpress/Onboarding/State.php',
    Schedule\AjaxScheduleHandler::class => '/src/multilingualpress/Schedule/AjaxScheduleHandler.php',
    Schedule\Delay\AverageMicrosecondsDuration::class => '/src/multilingualpress/Schedule/Delay/AverageMicrosecondsDuration.php',
    Schedule\Delay\Delay::class => '/src/multilingualpress/Schedule/Delay/Delay.php',
    Schedule\Delay\MaxDelay::class => '/src/multilingualpress/Schedule/Delay/MaxDelay.php',
    Schedule\Delay\OneSecondEveryGivenSteps::class => '/src/multilingualpress/Schedule/Delay/OneSecondEveryGivenSteps.php',
    Schedule\Delay\Zero::class => '/src/multilingualpress/Schedule/Delay/Zero.php',
    Schedule\Schedule::class => '/src/multilingualpress/Schedule/Schedule.php',
    Schedule\Scheduler::class => '/src/multilingualpress/Schedule/Scheduler.php',
    Schedule\ServiceProvider::class => '/src/multilingualpress/Schedule/ServiceProvider.php',
    SiteDuplication\ActivatePluginsSetting::class => '/src/multilingualpress/SiteDuplication/ActivatePluginsSetting.php',
    SiteDuplication\ActivePlugins::class => '/src/multilingualpress/SiteDuplication/ActivePlugins.php',
    SiteDuplication\BasedOnSiteSetting::class => '/src/multilingualpress/SiteDuplication/BasedOnSiteSetting.php',
    SiteDuplication\Schedule\AttachmentDuplicatorHandler::class => '/src/multilingualpress/SiteDuplication/Schedule/AttachmentDuplicatorHandler.php',
    SiteDuplication\Schedule\AttachmentDuplicatorScheduler::class => '/src/multilingualpress/SiteDuplication/Schedule/AttachmentDuplicatorScheduler.php',
    SiteDuplication\Schedule\NewSiteScheduleTemplate::class => '/src/multilingualpress/SiteDuplication/Schedule/NewSiteScheduleTemplate.php',
    SiteDuplication\Schedule\ScheduleAssetManager::class => '/src/multilingualpress/SiteDuplication/Schedule/ScheduleAssetManager.php',
    SiteDuplication\Schedule\ScheduleOption::class => '/src/multilingualpress/SiteDuplication/Schedule/ScheduleOption.php',
    SiteDuplication\SearchEngineVisibilitySetting::class => '/src/multilingualpress/SiteDuplication/SearchEngineVisibilitySetting.php',
    SiteDuplication\ServiceProvider::class => '/src/multilingualpress/SiteDuplication/ServiceProvider.php',
    SiteDuplication\SiteDuplicator::class => '/src/multilingualpress/SiteDuplication/SiteDuplicator.php',
    TranslationUi\MetaboxFieldsHelper::class => '/src/multilingualpress/TranslationUi/MetaboxFieldsHelper.php',
    TranslationUi\Post\Ajax\ContextBuilder::class => '/src/multilingualpress/TranslationUi/Post/Ajax/ContextBuilder.php',
    TranslationUi\Post\Ajax\RelationshipUpdater::class => '/src/multilingualpress/TranslationUi/Post/Ajax/RelationshipUpdater.php',
    TranslationUi\Post\Ajax\Search::class => '/src/multilingualpress/TranslationUi/Post/Ajax/Search.php',
    TranslationUi\Post\Field\Base::class => '/src/multilingualpress/TranslationUi/Post/Field/Base.php',
    TranslationUi\Post\Field\CopyContent::class => '/src/multilingualpress/TranslationUi/Post/Field/CopyContent.php',
    TranslationUi\Post\Field\CopyFeaturedImage::class => '/src/multilingualpress/TranslationUi/Post/Field/CopyFeaturedImage.php',
    TranslationUi\Post\Field\CopyTaxonomies::class => '/src/multilingualpress/TranslationUi/Post/Field/CopyTaxonomies.php',
    TranslationUi\Post\Field\EditLink::class => '/src/multilingualpress/TranslationUi/Post/Field/EditLink.php',
    TranslationUi\Post\Field\Excerpt::class => '/src/multilingualpress/TranslationUi/Post/Field/Excerpt.php',
    TranslationUi\Post\Field\Relation::class => '/src/multilingualpress/TranslationUi/Post/Field/Relation.php',
    TranslationUi\Post\Field\Status::class => '/src/multilingualpress/TranslationUi/Post/Field/Status.php',
    TranslationUi\Post\Field\Taxonomies::class => '/src/multilingualpress/TranslationUi/Post/Field/Taxonomies.php',
    TranslationUi\Post\Field\TaxonomySlugs::class => '/src/multilingualpress/TranslationUi/Post/Field/TaxonomySlugs.php',
    TranslationUi\Post\Field\TaxonomyWalker::class => '/src/multilingualpress/TranslationUi/Post/Field/TaxonomyWalker.php',
    TranslationUi\Post\Metabox::class => '/src/multilingualpress/TranslationUi/Post/Metabox.php',
    TranslationUi\Post\MetaboxAction::class => '/src/multilingualpress/TranslationUi/Post/MetaboxAction.php',
    TranslationUi\Post\MetaboxField::class => '/src/multilingualpress/TranslationUi/Post/MetaboxField.php',
    TranslationUi\Post\MetaboxFields::class => '/src/multilingualpress/TranslationUi/Post/MetaboxFields.php',
    TranslationUi\Post\MetaboxFillable::class => '/src/multilingualpress/TranslationUi/Post/MetaboxFillable.php',
    TranslationUi\Post\MetaboxTab::class => '/src/multilingualpress/TranslationUi/Post/MetaboxTab.php',
    TranslationUi\Post\MetaboxView::class => '/src/multilingualpress/TranslationUi/Post/MetaboxView.php',
    TranslationUi\Post\PostMetaboxField::class => '/src/multilingualpress/TranslationUi/Post/PostMetaboxField.php',
    TranslationUi\Post\PostModifiedDateFilter::class => '/src/multilingualpress/TranslationUi/Post/PostModifiedDateFilter.php',
    TranslationUi\Post\PostRelationSaveHelper::class => '/src/multilingualpress/TranslationUi/Post/PostRelationSaveHelper.php',
    TranslationUi\Post\RelationshipContext::class => '/src/multilingualpress/TranslationUi/Post/RelationshipContext.php',
    TranslationUi\Post\RelationshipPermission::class => '/src/multilingualpress/TranslationUi/Post/RelationshipPermission.php',
    TranslationUi\Post\SourcePostSaveContext::class => '/src/multilingualpress/TranslationUi/Post/SourcePostSaveContext.php',
    TranslationUi\Post\TableList::class => '/src/multilingualpress/TranslationUi/Post/TableList.php',
    TranslationUi\ServiceProvider::class => '/src/multilingualpress/TranslationUi/ServiceProvider.php',
    TranslationUi\Term\Ajax\ContextBuilder::class => '/src/multilingualpress/TranslationUi/Term/Ajax/ContextBuilder.php',
    TranslationUi\Term\Ajax\RelationshipUpdater::class => '/src/multilingualpress/TranslationUi/Term/Ajax/RelationshipUpdater.php',
    TranslationUi\Term\Ajax\Search::class => '/src/multilingualpress/TranslationUi/Term/Ajax/Search.php',
    TranslationUi\Term\Field\Base::class => '/src/multilingualpress/TranslationUi/Term/Field/Base.php',
    TranslationUi\Term\Field\Description::class => '/src/multilingualpress/TranslationUi/Term/Field/Description.php',
    TranslationUi\Term\Field\ParentTerm::class => '/src/multilingualpress/TranslationUi/Term/Field/ParentTerm.php',
    TranslationUi\Term\Field\Relation::class => '/src/multilingualpress/TranslationUi/Term/Field/Relation.php',
    TranslationUi\Term\Metabox::class => '/src/multilingualpress/TranslationUi/Term/Metabox.php',
    TranslationUi\Term\MetaboxAction::class => '/src/multilingualpress/TranslationUi/Term/MetaboxAction.php',
    TranslationUi\Term\MetaboxField::class => '/src/multilingualpress/TranslationUi/Term/MetaboxField.php',
    TranslationUi\Term\MetaboxFields::class => '/src/multilingualpress/TranslationUi/Term/MetaboxFields.php',
    TranslationUi\Term\MetaboxTab::class => '/src/multilingualpress/TranslationUi/Term/MetaboxTab.php',
    TranslationUi\Term\MetaboxView::class => '/src/multilingualpress/TranslationUi/Term/MetaboxView.php',
    TranslationUi\Term\RelationshipContext::class => '/src/multilingualpress/TranslationUi/Term/RelationshipContext.php',
    TranslationUi\Term\RelationshipPermission::class => '/src/multilingualpress/TranslationUi/Term/RelationshipPermission.php',
    TranslationUi\Term\TableList::class => '/src/multilingualpress/TranslationUi/Term/TableList.php',
    TranslationUi\Term\TermRelationSaveHelper::class => '/src/multilingualpress/TranslationUi/Term/TermRelationSaveHelper.php',
    Translator\DateTranslator::class => '/src/multilingualpress/Translator/DateTranslator.php',
    Translator\HomeTranslator::class => '/src/multilingualpress/Translator/HomeTranslator.php',
    Translator\PostTranslator::class => '/src/multilingualpress/Translator/PostTranslator.php',
    Translator\PostTypeTranslator::class => '/src/multilingualpress/Translator/PostTypeTranslator.php',
    Translator\SearchTranslator::class => '/src/multilingualpress/Translator/SearchTranslator.php',
    Translator\ServiceProvider::class => '/src/multilingualpress/Translator/ServiceProvider.php',
    Translator\TermTranslator::class => '/src/multilingualpress/Translator/TermTranslator.php',
    Translator\UrlBlogFragmentTrailingTrait::class => '/src/multilingualpress/Translator/UrlBlogFragmentTrailingTrait.php',
];

function autoloadClasses($class) {
	$file = AUTOLOAD_MAP[$class] ?? '';
	$file and require_once __DIR__ . $file;
}
spl_autoload_register(__NAMESPACE__ . '\\autoloadClasses');

require_once __DIR__ . '/src/inc/api.php';
require_once __DIR__ . '/src/inc/functions.php';
require_once __DIR__ . '/src/inc/utils.php';

