<?php
namespace XSDigital;

class License_manager {
	
	const CAPABILITY_REQUIRED_TO_SEE_NOTICE = 'activate_plugins';
	
	var $REQUIRED_PLUGINS = array(
		'Gravity Forms' => 'gravity-forms/gravityforms.php',
	);
	
	
	var $list_plugins = false;
	var $has_required_plugins = false;
	var $license_key = false;
	var $license_status = false;
	var $responsebody = '';
	var $plugin_key = false;
	var $missing_plugin_names = false;
	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string $plugin_name The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;
	protected $plugin_folder;
	protected $plugin_location;
	protected $license_page;
	
	function __construct( $plugin_name, $plugin_key,  $plugin_location, $license_page, $license_key = false , $construct_parent) {
		
		$this->plugin_folder     = dirname(dirname(dirname(__FILE__)));
		$this->plugin_key     = $plugin_key;
		$this->plugin_name     = $plugin_name;
		$this->plugin_location = $plugin_location;
		$this->license_page    = $license_page;
		$this->license_key = $license_key;
	}
	
	public function check_plugins() {
		
		$this->missing_plugin_names = $this->get_missing_plugin_list();
		
		if ( ! empty( $this->missing_plugin_names ) ) {
			
			add_action( 'admin_notices', array( $this, 'display_admin_notice' ) );
			$this->has_required_plugins = false;
			
			return;
		}
		$this->has_required_plugins = true;
		
		return;
	}
	
	private function get_missing_plugin_list() {
		// Only get the plugins that are *not* active.
		$missing_plugins = array_filter(
			$this->REQUIRED_PLUGINS,
			array( $this, 'is_plugin_inactive' ),
			ARRAY_FILTER_USE_BOTH
		);
		
		return array_keys( $missing_plugins );
	}
	
	public function check_license() {
		if ( $this->get_license_key() ) {
		 
			if ( $this->get_license_status() ) {
				
				require_once $this->plugin_folder . '/vendor/autoload.php';
				add_filter('puc_request_info_query_args-' . $this->plugin_key, function($args){
					$args['license'] = $this->get_license_key();
					return $args;
				});
				$MyUpdateChecker = \Puc_v4_Factory::buildUpdateChecker(
					'https://kernl.us/api/v1/updates/6005963b9138de53009d2f2d/',
					dirname( dirname( plugin_dir_path( __FILE__ ) ) ) . '/gravityformspostcodenl.php',
					$this->plugin_key
				);
				
				$MyUpdateChecker->license = $this->get_license_key(); // <--- important!
				
				$this->license_status = $this->get_license_status();
			} else {
				
				$domain = get_site_url();
				$domain = parse_url($domain);
				$url      = 'https://kernl.us/api/v2/public/license/validate-with-domain?license=' . $this->get_license_key() . '&domain='.$domain['host'];
				$response = wp_remote_get( $url );
				
				$this->license_status = false;
				if(wp_remote_retrieve_response_code($response) == '404'){
					//License not valid
					$this->license_status = false;
					add_filter($this->plugin_key . '_license_message', function() {
						return __('License not valid', $this->plugin_key);
					});
					
				} elseif(wp_remote_retrieve_response_code($response) == '403'){
					
					//License not activated for domain
					
					$url      = 'https://kernl.us/api/v2/public/license/activate?license=' . $this->get_license_key() . '&domain='.$domain['host'];
					$response = wp_remote_get( $url);
					$this->responsebody = wp_remote_retrieve_body($response);
					
					
					if(wp_remote_retrieve_response_code($response) == '200'){
						//License activated for domain
						$this->license_status = true;
						
					} elseif(wp_remote_retrieve_response_code($response) == '400') {
						//License activation limit has already been reached.
						$this->license_status = false;
						add_filter($this->plugin_key . '_license_message', function() {
							return __(esc_attr($this->responsebody), $this->plugin_key);
						});
					} elseif(wp_remote_retrieve_response_code($response) == '404') {
						//License not found.
						$this->license_status = false;
						add_filter($this->plugin_key . '_license_message', function() {
							return  __(esc_attr($this->responsebody), $this->plugin_key);
						});
					}
					
				} elseif(wp_remote_retrieve_response_code($response) == '200'){
					$this->license_status = true;
				}
				
				if ( $this->license_status ) {
					
					if ( is_multisite() && set_site_transient( $this->plugin_key . '-activelicense', true, 300 ) ) {
						$this->license_status = true;
					} elseif ( set_transient( $this->plugin_key . '-activelicense', true, 300 ) ) {
						$this->license_status = true;
					}
					
				} else {
					//Show notice of invalid license key
					add_action( 'admin_notices', array( $this, 'display_admin_notice_license' ) );
					
					
					add_action( 'after_plugin_row_' . $this->plugin_location, array( $this, 'after_plugin_row' ), 10, 3 );
				}
			}
			// Add settings link
			
		} else {
			
			
			
			//Show notice of invalid license key
			add_action( 'admin_notices', array( $this, 'display_admin_notice_license' ) );
			
			
			add_action( 'after_plugin_row_' . $this->plugin_location, array( $this, 'after_plugin_row' ), 10, 3 );
		}
		
		
	}
	
	public function get_license_key() {
		
		
		if ( defined( 'GFPCHNTV_KEY' ) && GFPCHNTV_KEY) {
			return GFPCHNTV_KEY;
		} elseif ( is_multisite() && get_site_option( $this->plugin_key . '-license' ) ) {
			return get_site_option( $this->plugin_key . '-license' );
		}
		if ( $this->license_key ) {
			return $this->license_key;
		}
		
		return false;
	}
	
	public function get_license_status() {
		
		//CHeck if transient is active
		if ( is_multisite() && get_site_transient( $this->plugin_key . '-activelicense' ) ) {
			return $this->license_status = true;
			
		} elseif ( get_transient( $this->plugin_key . '-activelicense' ) ) {
			return $this->license_status = true;
			
		}
		
		return $this->license_status;
	}
	
	public function has_required_plugins() {
		return $this->has_required_plugins;
	}
	
	public function display_admin_notice() {
		if ( current_user_can( self::CAPABILITY_REQUIRED_TO_SEE_NOTICE ) ) {
			$this->render_template();
			
		}
	}
	
	private function render_template() {
		
		
		$action                = 'install-plugin';
		$slug                  = 'woocommerce';
		$wc_install            = wp_nonce_url(
			add_query_arg(
				array(
					'action' => $action,
					'plugin' => $slug
				),
				admin_url( 'update.php' )
			),
			$action . '_' . $slug
		);
		$this->list_plugins    = array(
			'Gravity Forms' => [
				'url'    => 'https://xs.digital/gravityforms',
				'text'   => 'Buy direct on Gravity Forms',
				'target' => '_blank'
			],
			'WooCommerce'   => [
				'url'    => $wc_install,
				'text'   => 'Direct install WooCommerce',
				'target' => '_self'
			],
		);
		$list_followup         = $this->list_plugins;
		$list_required_plugins = $this->REQUIRED_PLUGINS;
		$installed_plugins     = get_plugins();
		?>

        <div class="error notice">
            <p>
				<?php if ( is_array( $this->missing_plugin_names ) ) { ?>
					<?= __(
						'<strong>' . $this->plugin_name . '</strong> needs the following plugins to be active:',
						$this->plugin_name
					) ?>
					<?php
					foreach ( $this->missing_plugin_names as $plugin_name ) {
						echo "<ul>";
						if ( isset( $list_followup[ $plugin_name ] ) ) {
							if ( isset( $installed_plugins[ $list_required_plugins[ $plugin_name ] ] ) ) {
								$link = wp_nonce_url( admin_url( 'plugins.php?action=activate&plugin=' . $list_required_plugins[ $plugin_name ] ),
									'activate-plugin_' . $list_required_plugins[ $plugin_name ] );
								echo "<li>" . $plugin_name . " (<a href='" . $link . "' target='_self'>Activate plugin</a>)</li>";
							} else {
								echo "<li>" . $plugin_name . " (<a href='" . $list_followup[ $plugin_name ]['url'] . "' target='" . $list_followup[ $plugin_name ]['target'] . "'>" . $list_followup[ $plugin_name ]['text'] . "</a>)</li>";
							}
						} else {
							echo "<li>" . $plugin_name . "</li>";
						}
						echo "</ul>";
					}
				}
				
				
				?>
            </p>
        </div>
		<?php
		
	}
	
	public function display_admin_notice_license() {
		if ( current_user_can( self::CAPABILITY_REQUIRED_TO_SEE_NOTICE ) ) {
			
			if ( ! $this->license_status ) {
				$this->notice_license();
			}
		}
	}
	
	private function notice_license() {
		
		?>

        <div class="error notice">
            <p>
				<?php
				
				if ( ! $this->license_status ) {
					
					echo sprintf( '<strong>%s</strong> %s',
						$this->plugin_name, __( 'needs to be activated.', $this->plugin_key ) );
					echo sprintf( ' <a href="%s">%s</a>',
						esc_url( $this->license_page ), __( 'Enter License key.', $this->plugin_key ) );
				}
				?>
            </p>
        </div>
		<?php
		
	}
	
	public function after_plugin_row( $plugin_file, $plugin_data, $status ) {
		$license        = $this->get_license_key();
		$license_status = $this->get_license_status();
		
		if ( is_network_admin() ) {
			$active_class = is_plugin_active_for_network( $this->plugin_location ) ? ' active' : '';
		} else {
			$active_class = is_plugin_active( $this->plugin_location ) ? ' active' : '';
		}
		
		if ( empty( $license ) || false === $license_status ) {
			echo '<tr class="plugin-update-tr' . $active_class . '" id="' . $this->plugin_name . '-update" data-slug="' . $this->plugin_name . '" data-plugin="' . $this->plugin_location . '">';
			echo '<td colspan="3" class="plugin-update colspanchange">';
			echo '<div class="update-message notice inline notice-warning notice-alt">';
			echo '<p>';
			echo sprintf( '%s <a href="%s">%s</a>',
				__( 'Please enter a license to receive automatic updates.', $this->plugin_key ),
				esc_url( esc_url( $this->license_page ) ), __( 'Enter License key.', $this->plugin_key ) );
			
			echo '</p></div></td></tr>';
			
			// Apply the class "update" to the plugin row to get rid of the ugly border.
			echo "
				<script type='text/javascript'>
					jQuery('#$this->plugin_name-update').prev('tr').addClass('update');
				</script>
				";
		}
	}
	
	private function is_plugin_inactive( $main_plugin_file_path ) {
		return ! in_array( $main_plugin_file_path, $this->get_active_plugins() );
	}

    private function get_active_plugins() {
        $active_plugins = apply_filters( 'active_plugins', get_option( 'active_plugins' ) );

        if(is_multisite()){
            $multisite_active_plugins = get_site_option('active_sitewide_plugins') ;

            $active_plugins = array_merge($active_plugins, array_keys( $multisite_active_plugins ));
        }

        return $active_plugins;
    }
	
}
