<?php

if ( ! class_exists( 'GFForms' ) ) {
	die();
}


class GF_Field_PCHNTV extends GF_Field {

	public $type = 'pchntv';
	public $slug = 'gravityformspostcodenl';
	//  public $type_description = 'Dit veld zoekt automatisch het bijbehorende adres op basis van de postcode en huisnummer';

	public $type_title = 'Vul je postcode en huisnummer in';

	// # FORM EDITOR & FIELD MARKUP -------------------------------------------------------------------------------------

	public function get_form_editor_button() {
		return array(
			'group' => 'advanced_fields',
			'text'  => $this->get_form_editor_field_title(),
		);
	}

	public function get_form_editor_field_title() {
		return esc_attr__( 'Adres NL', 'gravityforms' );
	}

	public function get_form_editor_field_icon() {
		return 'gform-icon--place';
	}

	public function get_form_editor_field_settings() {
		$return = array(
			//          'conditional_logic_field_setting',
			'prepopulate_field_setting',
			//          'error_message_setting',
			//          'label_setting',
			//          'admin_label_setting',
			//          'rules_setting',
			'duplicate_setting',
			'duplicate_setting_message',
			'only_existing_setting',
			//          'description_setting',
			//          'css_class_setting',
			
			'conditional_logic_field_setting',
			'error_message_setting',
			'label_setting',
			'admin_label_setting',
			'label_placement_setting',
			'input_placeholders_setting',
			//          'address_setting',
							'rules_setting',
			'copy_values_option',
			'description_setting',
			'visibility_setting',
			'css_class_setting',
			'postcode_settings',
			'postcode_settings_error',
		);
		if ( $this->isBag() ) {
            $return = array_merge($return, ['postcode_settings_bag']);
		}
		return $return;

	}

	public function is_conditional_logic_supported() {
		return true;
	}

	public function get_field_input( $form, $value = '', $entry = null ) {

		$form_id         = $form['id'];
		$is_entry_detail = $this->is_entry_detail();
		$is_form_editor  = $this->is_form_editor();
		$is_admin        = $is_entry_detail || $is_form_editor;

		$id       = (int) $this->id;
		$field_id = $is_entry_detail || $is_form_editor || $form_id == 0 ? "input_$id" : 'input_' . $form_id . "_$id";

		$class_suffix = $is_entry_detail ? '_admin' : '';

		$message    = '';
		$postcode   = '';
		$huisnummer = '';
		$toevoeging = '';
		$straat     = '';
		$plaats     = '';
		$wrap_begin = '';
		$gemeente   = '';
		$provincie  = '';
		$bag        = '';
		$end        = '';

		if ( $this->isBag() ) {
			$postcodeOppervlakte  = '';
			$postcodeGebruikstype = '';
			$postcodeBouwjaar     = '';
			if ( is_array( $value ) ) {

				$postcodeBouwjaar     = esc_attr( rgget( $this->id . '.8', $value ) );
				$postcodeOppervlakte  = esc_attr( rgget( $this->id . '.9', $value ) );
				$postcodeGebruikstype = esc_attr( rgget( $this->id . '.11', $value ) );
			}
		}
		if ( is_array( $value ) ) {
			$postcode   = esc_attr( rgget( $this->id . '.1', $value ) );
			$huisnummer = esc_attr( rgget( $this->id . '.2', $value ) );
			$toevoeging = esc_attr( rgget( $this->id . '.3', $value ) );
			$straat     = esc_attr( rgget( $this->id . '.4', $value ) );
			$plaats     = esc_attr( rgget( $this->id . '.5', $value ) );
			$gemeente   = esc_attr( rgget( $this->id . '.6', $value ) );
			$provincie  = esc_attr( rgget( $this->id . '.7', $value ) );
		}

		$postcode_field_input   = GFFormsModel::get_input( $this, $this->id . '.1' );
		$huisnummer_field_input = GFFormsModel::get_input( $this, $this->id . '.2' );
		$toevoeging_field_input = GFFormsModel::get_input( $this, $this->id . '.3' );
		$straat_field_input     = GFFormsModel::get_input( $this, $this->id . '.4' );
		$plaats_field_input     = GFFormsModel::get_input( $this, $this->id . '.5' );
		$gemeente_field_input   = GFFormsModel::get_input( $this, $this->id . '.6' );
		$provincie_field_input  = GFFormsModel::get_input( $this, $this->id . '.7' );
		if ( $this->isBag() ) {
			$postcodeBouwjaar_field_input     = GFFormsModel::get_input( $this, $this->id . '.8' );
			$postcodeOppervlakte_field_input  = GFFormsModel::get_input( $this, $this->id . '.9' );
			$postcodeGebruikstype_field_input = GFFormsModel::get_input( $this, $this->id . '.11' );
		}

		$postcode_label = rgar(
			$postcode_field_input,
			'placeholder'
		) != '' ? $postcode_field_input['placeholder'] : 'Postcode';
		$postcode_label = gf_apply_filters(
			array(
				'gform_address_postcode',
				$form_id,
				$this->id,
			),
			$postcode_label,
			$form_id
		);
		$postcode_label = esc_html( $postcode_label );

		$huisnummer_label = rgar(
			$huisnummer_field_input,
			'placeholder'
		) != '' ? $huisnummer_field_input['placeholder'] : 'Huisnr';
		$huisnummer_label = gf_apply_filters(
			array(
				'gform_address_huisnummer',
				$form_id,
				$this->id,
			),
			$huisnummer_label,
			$form_id
		);
		$huisnummer_label = esc_html( $huisnummer_label );

		$toevoeging_label = rgar(
			$toevoeging_field_input,
			'placeholder'
		) != '' ? $toevoeging_field_input['placeholder'] : 'Toev.';
		$toevoeging_label = gf_apply_filters(
			array(
				'gform_address_toevoeging',
				$form_id,
				$this->id,
			),
			$toevoeging_label,
			$form_id
		);
		$toevoeging_label = esc_html( $toevoeging_label );

		$straat_label = rgar(
			$straat_field_input,
			'placeholder'
		) != '' ? $straat_field_input['placeholder'] : 'Straat';
		$straat_label = gf_apply_filters(
			array(
				'gform_address_straat',
				$form_id,
				$this->id,
			),
			$straat_label,
			$form_id
		);
		$straat_label = esc_html( $straat_label );

		$plaats_label = rgar(
			$plaats_field_input,
			'placeholder'
		) != '' ? $plaats_field_input['placeholder'] : 'Plaats';
		$plaats_label = gf_apply_filters(
			array(
				'gform_address_plaats',
				$form_id,
				$this->id,
			),
			$plaats_label,
			$form_id
		);
		$plaats_label = esc_html( $plaats_label );

		$gemeente_label = rgar(
			$gemeente_field_input,
			'placeholder'
		) != '' ? $gemeente_field_input['placeholder'] : 'Gemeente';
		$gemeente_label = gf_apply_filters(
			array(
				'gform_address_gemeente',
				$form_id,
				$this->id,
			),
			$gemeente_label,
			$form_id
		);
		$gemeente_label = esc_html( $gemeente_label );

		$provincie_label = rgar(
			$provincie_field_input,
			'placeholder'
		) != '' ? $provincie_field_input['placeholder'] : 'Provincie';
		$provincie_label = gf_apply_filters(
			array(
				'gform_address_provincie',
				$form_id,
				$this->id,
			),
			$provincie_label,
			$form_id
		);
		$provincie_label = esc_html( $provincie_label );
		if ( $this->isBag() ) {
			$postcodeBouwjaar_label = rgar(
				$postcodeBouwjaar_field_input,
				'placeholder'
			) != '' ? $postcodeBouwjaar_field_input['placeholder'] : 'Bouwjaar';
			$postcodeBouwjaar_label = gf_apply_filters(
				array(
					'gform_address_postcodebouwjaar',
					$form_id,
					$this->id,
				),
				$postcodeBouwjaar_label,
				$form_id
			);
			$postcodeBouwjaar_label = esc_html( $postcodeBouwjaar_label );

			$postcodeOppervlakte_label = rgar(
				$postcodeOppervlakte_field_input,
				'placeholder'
			) != '' ? $postcodeOppervlakte_field_input['placeholder'] : 'Oppervlakte';
			$postcodeOppervlakte_label = gf_apply_filters(
				array(
					'gform_address_postcodeoppervlakte',
					$form_id,
					$this->id,
				),
				$postcodeOppervlakte_label,
				$form_id
			);
			$postcodeOppervlakte_label = esc_html( $postcodeOppervlakte_label );

			$postcodeGebruikstype_label = rgar(
				$postcodeGebruikstype_field_input,
				'placeholder'
			) != '' ? $postcodeOppervlakte_field_input['placeholder'] : 'Gebruikstype';
			$postcodeGebruikstype_label = gf_apply_filters(
				array(
					'gform_address_postcodegebruikstype',
					$form_id,
					$this->id,
				),
				$postcodeGebruikstype_label,
				$form_id
			);
			$postcodeGebruikstype_label = esc_html( $postcodeGebruikstype_label );
		}
		$tabindex = $this->get_tabindex();

		if ( $is_form_editor ) {

			$disabled = ' disabled=disabled';
		} else {
			$disabled = '';
		}
		$style = '';

		if ( $is_entry_detail ) {
			$prefix_id = '1';
			$postcode  = "<span class='ginput_left{$class_suffix} field_postcode ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$postcode_label}</label>
                                     <input type='text' maxlength='6' class='input_postcode' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$postcode_label' value='{$postcode}' {$tabindex} autocomplete='shipping postal-code' {$disabled} />
                                </span>";

			$prefix_id  = '2';
			$huisnummer = "<span class='ginput_right{$class_suffix} field_huisnummer ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$huisnummer_label}</label>
                                <input class='input_huisnummer' type='text' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$huisnummer_label' value='{$huisnummer}' {$tabindex} {$disabled}/></span>";

			$prefix_id  = '3';
			$toevoeging = "<span class='ginput_left{$class_suffix} field_postcode ' id='{$field_id}_{$prefix_id}_container' {$style}>
<label for='input_{$id}.{$prefix_id}'>{$toevoeging_label}</label>
<input type='text' class='input_toevoeging' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$toevoeging_label' value='{$toevoeging}' {$tabindex} {$disabled}/>
                        </span>";

			$prefix_id = '4';
			$straat    = "<span class='ginput_left{$class_suffix} field_straat ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$straat_label}</label>
                                   <input type='text' class='input_straat' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$straat_label' value='{$straat}' {$tabindex} {$disabled} />
                                </span>";

			$prefix_id = '5';
			$plaats    = "<span class='ginput_right{$class_suffix} field_plaats ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$plaats_label}</label>
                                    <input type='text' class='input_plaats' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$plaats_label' value='{$plaats}' {$tabindex} {$disabled}/>
                                </span>";

			$prefix_id = '6';
			$gemeente  = "<span class='ginput_left{$class_suffix} field_straat ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$gemeente_label}</label>
                                   <input type='text' class='input_gemeente' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$gemeente_label' value='{$gemeente}' {$tabindex} {$disabled}/>
                                    </span>";

			$prefix_id = '7';
			$provincie = "<span class='ginput_right{$class_suffix} field_plaats ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$provincie_label}</label>
                                    <input type='text' class='input_provincie' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$provincie_label' value='{$provincie}' {$tabindex} {$disabled}/>
 </span>";

			if ( $this->isBag() ) {
				if ( $this->isPostcode( 'Bouwjaar' ) ) {
					$prefix_id = '8';
					$bag      .= "<span class='ginput_right{$class_suffix} ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$postcodeBouwjaar_label}</label>
<input type='text' class='input_postcode_bouwjaar' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='Bouwjaar' value='{$postcodeBouwjaar}' {$tabindex} {$disabled}/>";
				}
				if ( $this->isPostcode( 'Oppervlakte' ) ) {
					$prefix_id = '9';
					$bag      .= "<span class='ginput_right{$class_suffix} ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$postcodeOppervlakte_label}</label>
<input type='text' class='input_postcode_oppervlakte' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='Oppervlakte' value='{$postcodeOppervlakte}' {$tabindex} {$disabled}/>";
				}
				if ( $this->isPostcode( 'Gebruikstype' ) ) {
					$prefix_id = '11';
					$bag      .= "<span class='ginput_right{$class_suffix} ' id='{$field_id}_{$prefix_id}_container' {$style}><label for='input_{$id}.{$prefix_id}'>{$postcodeGebruikstype_label}</label>
<input type='text' class='input_postcode_gebruikstype' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='Gebruikstype' value='{$postcodeGebruikstype}' {$tabindex} {$disabled}/>";
				}
			}
		} else {
			$prefix_id = '1';
			$postcode  = "<span class='ginput_left{$class_suffix} field_postcode ' id='{$field_id}_{$prefix_id}_container' {$style}>
                                     <input type='text' maxlength='6' class='input_postcode' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$postcode_label' value='{$postcode}' {$tabindex} autocomplete='shipping postal-code' {$disabled} />
                                </span>";

			$prefix_id  = '2';
			$huisnummer = "<span class='ginput_right{$class_suffix} field_huisnummer ' id='{$field_id}_{$prefix_id}_container' {$style}>
                                <input class='input_huisnummer' type='text' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$huisnummer_label' value='{$huisnummer}' {$tabindex} {$disabled}/>";

			$prefix_id  = '3';
			$toevoeging = "<input type='text' class='input_toevoeging' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$toevoeging_label' value='{$toevoeging}' {$tabindex} {$disabled}/>
                        </span><div class='gf_clear gf_clear_complex' style='flex-basis: 100%;  height: 0;'></div>";

			$prefix_id = '4';
			$straat    = "<span class='ginput_left{$class_suffix} field_straat  ' id='{$field_id}_{$prefix_id}_container' {$style}>
                                   <input type='text' class='input_straat readonly' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$straat_label' value='{$straat}' {$tabindex} {$disabled} />
                                </span>";

			$prefix_id = '5';
			$plaats    = "<span class='ginput_right{$class_suffix} field_plaats ' id='{$field_id}_{$prefix_id}_container' {$style}>
                                    <input type='text' class='input_plaats readonly' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$plaats_label' value='{$plaats}' {$tabindex} {$disabled}/>
                                </span><div class='gf_clear gf_clear_complex' style='flex-basis: 100%;  height: 0;'></div>";
			$fieldtype = 'hidden';
			if ( $is_form_editor ) {
				$plaats   .= '<div class="gf_clear gf_clear_complex" style="flex-basis: 100%;  height: 0;"></div><div style="border: 1px solid #ccc; width: 100%; background #f1f1f1; margin: 1em 0; padding: 1em;"><div class="gfield_description" style="text-align: center; color: #242424;">' . __( 'Hidden field, not visible on frontend', $this->slug ) . '</div>';
				$fieldtype = 'text';
			}
			$prefix_id = '6';
			$gemeente  = "<input type='{$fieldtype}' class='input_gemeente' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$gemeente_label' value='{$gemeente}' {$tabindex} {$disabled}/>";

			$prefix_id = '7';
			$provincie = "<input type='{$fieldtype}' class='input_provincie' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='$provincie_label' value='{$provincie}' {$tabindex} {$disabled}/>";

			if ( $this->isPostcode( 'Bouwjaar' ) ) {
				$prefix_id = '8';
				$bag      .= "<input type='{$fieldtype}' class='input_postcode_bouwjaar' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='Bouwjaar' value='{$postcodeBouwjaar}' {$tabindex} {$disabled}/>";
			}
			if ( $this->isPostcode( 'Oppervlakte' ) ) {
				$prefix_id = '9';
				$bag      .= "<input type='{$fieldtype}' class='input_postcode_oppervlakte' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='Oppervlakte' value='{$postcodeOppervlakte}' {$tabindex} {$disabled}/>";
			}
			if ( $this->isPostcode( 'Gebruikstype' ) ) {
				$prefix_id = '11';
				$bag      .= "<input type='{$fieldtype}' class='input_postcode_gebruikstype' name='input_{$id}.{$prefix_id}' id='{$field_id}_{$prefix_id}' placeholder='Gebruikstype' value='{$postcodeGebruikstype}' {$tabindex} {$disabled}/>";
			}
			if ( $is_form_editor ) {
				$bag .= '</div>';

			}
		}

		$input_style = '';
		$css_class   = '';

        //Add fieldsettings as variables into code
        $field_settings = [];
        if(isset($this->only_existing_setting) && $this->only_existing_setting) {
            $field_settings['only_existing'] = esc_html($this->only_existing_setting);
        }

        if(isset($this->errorMessage) && $this->errorMessage) {
            $field_settings['errorMessage'] = esc_html($this->errorMessage);
        }


        if(isset($this->gemeenteExclusive) && $this->gemeenteExclusive) {
            $field_settings['gemeenteExclusive'] = esc_html($this->gemeenteExclusive);
            $field_settings['gemeenteExclusiveError'] = esc_html($this->gemeenteExclusiveError);
        }
        if(isset($this->adress_not_found_message) && $this->adress_not_found_message) {
            $field_settings['only_existing_message'] = esc_html($this->adress_not_found_message);
        }
        if(isset($this->optimize_datahub) && $this->optimize_datahub) {
            $field_settings['optimize_datahub'] = esc_html($this->optimize_datahub);
        }

        ob_start();
        ?>
            <script>
                  var gfpcnl_js_<?= $this->formId ?>_<?= $this->id ?> = <?= json_encode($field_settings) ?>
            </script>
        <?php
        $end = ob_get_clean();

		$inputs = $message . $postcode . $huisnummer . $toevoeging . $straat . $plaats . $wrap_begin . $gemeente . $provincie . $bag . $end;


		//Let clients optimize the HTML input fields
		$inputs = apply_filters('pchntv_inputs_html', $inputs, $message . $postcode . $huisnummer . $toevoeging . $straat . $plaats . $wrap_begin . $gemeente . $provincie . $bag . $end);


		return " <div class='ginput_complex{$class_suffix} ginput_container ginput_postcode ginput_gfpcnl {$css_class} gfield_trigger_change' id='$field_id' {$input_style}>
                        {$inputs}
                    <div class='gf_clear gf_clear_complex'></div>
<div class='validate'></div>
                </div>";
	}

	public function isBag() {

        if (in_array($this->get_plugin_settings('api'),['bag','datahub'], true)) {
            return true;
		}

		return false;
	}
	public function isPostcode( $setting_name ) {
		if ( $this->isBag() ) {
			return isset( $this->{'postcode' . $setting_name} ) ? $this->{'postcode' . $setting_name} : false;

		}

		return false;
	}



	// # INPUT ATTRIBUTE HELPERS ----------------------------------------------------------------------------------------

	public function get_plugin_settings( $setting_name ) {
		$settings = get_option( 'gravityformsaddon_gravityformspostcodenl_settings', false );

		return isset( $settings[ $setting_name ] ) ? $settings[ $setting_name ] : null;
	}

	public function get_entry_inputs() {

		$this->version = '1.0';
//        //Backward compatibility for zipfields who doesnt have Gemeente in place
//        if ( ! isset( $this->inputs[115] ) ) {
//            $this->inputs[115] = array(
//                'id'    => $this->id . '.115',
//                'label' => 'Straat en huisnummer',
//                'name'  => '',
//            );
//        }
//        if ( ! isset( $this->inputs[116] ) ) {
//            $this->inputs[116] = array(
//                'id'    => $this->id . '.116',
//                'label' => 'Postcode en plaats',
//                'name'  => '',
//            );
//        }
		//Backward compatibility for zipfields who doesnt have Gemeente in place
		if ( ! isset( $this->inputs[5] ) ) {
			$this->inputs[5] = array(
				'id'    => $this->id . '.6',
				'label' => 'Gemeente',
				'name'  => '',
			);
		}

		if ( ! isset( $this->inputs[6] ) ) {
			$this->inputs[6] = array(
				'id'    => $this->id . '.7',
				'label' => 'Provincie',
				'name'  => '',
			);
		}
		if ( $this->isBag() ) {

			if ( $this->isPostcode( 'Bouwjaar' ) ) {
				if ( ! isset( $this->inputs[7] ) ) {
					$this->inputs[7] = array(
						'id'    => $this->id . '.8',
						'label' => 'Bouwjaar',
						'name'  => '',
					);
				}
			}
			if ( $this->isPostcode( 'Oppervlakte' ) ) {
				if ( ! isset( $this->inputs[8] ) ) {
					$this->inputs[8] = array(
						'id'    => $this->id . '.9',
						'label' => 'Oppervlakte',
						'name'  => '',
					);
				}
			}
			//TODO: gebruikstype wordt niet goed opgeslagen
			if ( $this->isPostcode( 'Gebruikstype' ) ) {
				//              if ( ! isset( $this->inputs[9] ) ) {
					$this->inputs[9] = array(
						'id'    => $this->id . '.11',
						'label' => 'Gebruikstype',
						'name'  => '',
					);
					//              }
			}
		}

		return $this->inputs;
	}

	public function get_form_editor_inline_script_on_page_render() {

		if ( $this->isBag() ) {
			// set the default field label for the field
			$script = sprintf(
				"function SetDefaultValues_%s(field) {
        field.label = '%s';
        field.inputs = [new Input(field.id + '.1', '%s'), new Input(field.id + '.2', '%s'), new Input(field.id + '.3', '%s'), new Input(field.id + '.4', '%s'), new Input(field.id + '.5', '%s'), new Input(field.id + '.6', '%s'), new Input(field.id + '.7', '%s'), new Input(field.id + '.8', '%s'), new Input(field.id + '.9', '%s'), new Input(field.id + '.11', '%s')];
        }",
				$this->type,
				$this->type_title,
				'Postcode',
				'Huisnummer',
				'Toevoeging',
				'Straat',
				'Plaats',
				'Gemeente',
				'Provincie',
				'Bouwjaar',
				'Oppervlakte',
				'Gebruikstype'
			) . PHP_EOL;
		} else {
			// set the default field label for the field
			$script = sprintf(
				"function SetDefaultValues_%s(field) {
        field.label = '%s';
        field.inputs = [new Input(field.id + '.1', '%s'), new Input(field.id + '.2', '%s'), new Input(field.id + '.3', '%s'), new Input(field.id + '.4', '%s'), new Input(field.id + '.5', '%s'), new Input(field.id + '.6', '%s'), new Input(field.id + '.7', '%s')];
        }",
				$this->type,
				$this->type_title,
				'Postcode',
				'Huisnummer',
				'Toevoeging',
				'Straat',
				'Plaats',
				'Gemeente',
				'Provincie'
			) . PHP_EOL;
		}
		return $script;
	}


	public function get_value_entry_detail(
		$value,
		$currency = '',
		$use_text = false,
		$format = 'html',
		$media = 'screen'
	) {

        $callback_args = ['this' => $this];
		if ( is_array( $value ) ) {
			$postcode   = trim( rgget( $this->id . '.1', $value ) );
			$huisnummer = trim( rgget( $this->id . '.2', $value ) );
			$toevoeging = trim( rgget( $this->id . '.3', $value ) );
			$straat     = trim( rgget( $this->id . '.4', $value ) );
			$plaats     = trim( rgget( $this->id . '.5', $value ) );
			$gemeente   = trim( rgget( $this->id . '.6', $value ) );
			$provincie  = trim( rgget( $this->id . '.7', $value ) );

            $callback_args = array_merge($callback_args, [
                    'postcode' => $postcode,
                'huisnummer' => $huisnummer,
                'toevoeging' => $toevoeging,
                'straat' => $straat,
                'plaats' => $plaats,
                'gemeente' => $gemeente,
                'provincie' => $provincie,
            ]);
			if ( $this->isBag() ) {

				$postcodeBouwjaar     = trim( rgget( $this->id . '.8', $value ) );
				$postcodeOppervlakte  = trim( rgget( $this->id . '.9', $value ) );
				$postcodeGebruikstype = trim( rgget( $this->id . '.11', $value ) );

                $callback_args = array_merge($callback_args, [
                    'postcodeBouwjaar' => $postcodeBouwjaar,
                    'postcodeOppervlakte' => $postcodeOppervlakte,
                    'postcodeGebruikstype' => $postcodeGebruikstype
                ]);

			}

			if ( ! empty( $straat ) ) {
				$return  = $straat;
				$return .= ! empty( $return ) && ! empty( $huisnummer ) ? " $huisnummer" : $huisnummer;
				$return .= ! empty( $return ) && ! empty( $toevoeging ) ? "-$toevoeging" : $toevoeging;
				$return .= ! empty( $return ) && ! empty( $postcode ) ? ", $postcode" : $postcode;
				$return .= ! empty( $return ) && ! empty( $plaats ) ? " te $plaats" : $plaats;
				$return .= ! empty( $return ) && ! empty( $gemeente ) ? " (gemeente $gemeente" : $gemeente;
				$return .= ! empty( $return ) && ! empty( $provincie ) ? ", provincie $provincie" : $provincie;
				if ( $this->isBag() ) {
					$return .= ! empty( $return ) && ! empty( $postcodeBouwjaar ) ? ", bouwjaar $postcodeBouwjaar" : $postcodeBouwjaar;
					$return .= ! empty( $return ) && ! empty( $postcodeOppervlakte ) ? ", $postcodeOppervlakte m2" : $postcodeOppervlakte;
					$return .= ! empty( $return ) && ! empty( $postcodeGebruikstype ) ? ", $postcodeGebruikstype" : $postcodeGebruikstype;
				}
				$return .= ')';
			} else {
				$return = $postcode;

				$return .= ! empty( $return ) && ! empty( $huisnummer ) ? " $huisnummer" : $huisnummer;
				$return .= ! empty( $return ) && ! empty( $toevoeging ) ? "-$toevoeging" : $toevoeging;
				$return .= ! empty( $return ) && ! empty( $straat ) ? " $straat" : $straat;
				$return .= ! empty( $return ) && ! empty( $plaats ) ? " $plaats" : $plaats;
				$return .= ! empty( $return ) && ! empty( $gemeente ) ? " $gemeente" : $gemeente;
				$return .= ! empty( $return ) && ! empty( $provincie ) ? " $provincie" : $provincie;
				if ( $this->isBag() ) {
					$return .= ! empty( $return ) && ! empty( $postcodeBouwjaar ) ? ", bouwjaar $postcodeBouwjaar" : $postcodeBouwjaar;
					$return .= ! empty( $return ) && ! empty( $postcodeOppervlakte ) ? ", oppervlakte $postcodeOppervlakte)" : $postcodeOppervlakte;
					$return .= ! empty( $return ) && ! empty( $postcodeGebruikstype ) ? ", gebruikstype $postcodeGebruikstype)" : $postcodeGebruikstype;
				}
			}
		} else {
			$return = '';
		}

		if ( $format === 'html' ) {
			$return = esc_html( $return );
		}

		return apply_filters('pchntv_custom_entry_detail_html',  $return , $callback_args);;
	}


	// # SUBMISSION -----------------------------------------------------------------------------------------------------


	public function validate( $value, $form ) {
		
		
		
		if ( $this->noDuplicates && $this->is_duplicate( $form['id'], $this, $value ) ) {
			$this->failed_validation = true;
			$default_message         = is_array( $value ) ? __( 'This field requires a unique entry and the values you entered have already been used.',
				'gravityforms' ) :
				sprintf( __( "This field requires a unique entry and '%s' has already been used", 'gravityforms' ),
					$value );
			
			$default_message = $this->duplicate_setting_message ?: $default_message;
			$this->validation_message = gf_apply_filters( array( 'gform_duplicate_message', $form['id'] ),
				$default_message, $form, $this, $value );
			
			return;
		}
		
		$postcode   = rgar( $value, $this->id . '.1' );
		$huisnummer = rgar( $value, $this->id . '.2' );
		$toevoeging = rgar( $value, $this->id . '.3' );
		$straat     = rgar( $value, $this->id . '.4' );
		$plaats     = rgar( $value, $this->id . '.5' );
		$gemeente   = rgar( $value, $this->id . '.6' );
		$provincie  = rgar( $value, $this->id . '.7' );
		if ( $this->isBag() ) {
			
			if ( $this->isPostcode( 'Bouwjaar' ) ) {
				$postcodeBouwjaar = rgar( $value, $this->id . '.8' );
			}
			if ( $this->isPostcode( 'Oppervlakte' ) ) {
				$postcodeOppervlakte = rgar( $value, $this->id . '.9' );
			}
			if ( $this->isPostcode( 'Gebruikstype' ) ) {
				$postcodeGebruikstype = rgar( $value, $this->id . '.11' );
			}
		}
		if ( $this->isRequired ) {

			if ( empty( $postcode ) || empty( $huisnummer ) || empty( $straat ) || empty( $plaats ) ) {
				$this->failed_validation  = true;
				$this->validation_message = empty( $this->errorMessage ) ? esc_html__(
					'Dit veld is verplicht. Vul een volledig adres in.',
					'gravityforms'
				) : $this->errorMessage;

			}
		}
		$request = array(
			'postcode'   => esc_html( $postcode ),
			'huisnummer' => esc_html( $huisnummer ),
			'toevoeging' => esc_html( $toevoeging ),
		);
		$adres   = new \GFPostcodeFieldAddOn\getaddress();

            if ($this->gemeenteExclusive && $adres->validate_municipality($request, $this, $gemeente)) {

                require_once dirname(__DIR__) . '/data/bag.php';
                $mcode = (new \XSDigital\bag())->get_gemeente_by_code($this->gemeenteExclusive);
                $message = str_replace('[GEMEENTE]', $mcode, $this->gemeenteExclusiveError);
                $message = str_replace('[GEMEENTE_INGEVOERD]', $gemeente, $message);
                $this->failed_validation = true;
                $this->validation_message = $message;
            };

		if ( $this->only_existing_setting && !is_user_logged_in() && !$adres->only_existing( $request, $this ) ) {
			$this->failed_validation = true;
			$default_message         = is_array( $value ) ? __( 'This field requires a unique entry and the values you entered have already been used.',
				'gravityforms' ) :
				sprintf( __( "This field requires a unique entry and '%s' has already been used", 'gravityforms' ),
					$value );
			
			$default_message = $this->adress_not_found_message ?: $default_message;
			$this->validation_message = gf_apply_filters( array( 'gform_adress_not_found_message', $form['id'] ),
				$default_message, $form, $this, $value );
			
		}
		
		$validate = [
			'failed_validation' => $this->failed_validation,
			'validation_message' => $this->validation_message
		];
		
		$validate = apply_filters('pchntv_custom_validation', $validate, $postcode, $huisnummer, $toevoeging);
		
		$this->failed_validation = $validate['failed_validation'];
		$this->validation_message = $validate['validation_message'];
		
	}
	
	public function is_duplicate( $form_id, $field, $value ) {
		global $wpdb;
		
		$entry_meta_table_name = GFFormsModel::get_entry_meta_table_name();
		$entry_table_name      = GFFormsModel::get_entry_table_name();
		$sql_comparison        = 'ld.meta_value = %s';
		
		$check_ids = [
			$this->id . '.1',
			$this->id . '.2',
            $this->id . '.4',
		
		];
		
		if ( rgar( $value, $this->id . '.3' ) ) {
			$check_ids[] = $this->id . '.3';
		}
		$inner_sql_template = "SELECT %s as input, ld.entry_id
                                FROM {$entry_meta_table_name} ld
                                INNER JOIN {$entry_table_name} l ON l.id = ld.entry_id\n";
		
		
		$inner_sql_template .= "WHERE l.form_id=%d AND ld.form_id=%d
                                AND ld.meta_key = %s
                                AND status='active' AND {$sql_comparison}";
		
		$sql = "SELECT count(distinct input) as match_count FROM ( ";
		
		$input_count = 1;
		if ( is_array( $field->get_entry_inputs() ) ) {
			$input_count = sizeof( $check_ids );
			$inner_sql   = '';
			foreach ( $field->inputs as $input ) {
				
				if ( ! in_array( $input['id'], $check_ids ) ) {
					continue;
				}
				$union     = empty( $inner_sql ) ? '' : ' UNION ALL ';
				$inner_sql .= $union . $wpdb->prepare( $inner_sql_template, $input['id'], $form_id, $form_id,
						$input['id'], $value[ $input['id'] ] );
			}
		} else {
			$inner_sql = $wpdb->prepare( $inner_sql_template, $field->id, $form_id, $form_id, $field->id, $value );
		}
		
		$sql .= $inner_sql . "
                ) as count
                GROUP BY entry_id
                ORDER BY match_count DESC";
		
		$count = gf_apply_filters( array( 'gform_is_duplicate', $form_id ), $wpdb->get_var( $sql ), $form_id, $field,
			$value );
		
		return $count != null && $count >= $input_count;
	}
	
	// # OTHER HELPERS --------------------------------------------------------------------------------------------------
}

GF_Fields::register( new GF_Field_PCHNTV() );
