<?php

namespace GFPostcodeFieldAddOn;

use XSDigital\bag;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class getaddress extends \GFPostcodeNlFieldAddOn {


	public $postcode;
	public $huisnummer;
	public $toevoeging;
	public $return_format;
	public $settings;
	public $req;

	function __construct(  ) {

		$this->return_format = [
			'adres' => [
				'street'   => '',
				'city'   => '',
				'municipality'   => '',
				'municipality_code'   => '',
				'province'   => '',
				'zip' => '',
				'bouwjaar' => '',
				'oppervlakte' => '',
				'gebruikstype' => '',
				'number' => '',
				'found' => false,
				'error' => false,
				'approved' => false,
				'message' => '',
				'only_existing' => false,

			]
		];
		if($this->get_plugin_setting('postcodeapinu_key')) {
			$this->_postcodenl = $this->get_plugin_setting('postcodeapinu_key');
		};


	}
	function init()
    {
        add_action('wp_ajax_gfpcnlgetaddress', array($this, 'ajax_getaddress'), 1);
        add_action('wp_ajax_nopriv_gfpcnlgetaddress', array($this, 'ajax_getaddress'), 1);

    }

    public  function ajax_getaddress() {
		if(!isset( $_REQUEST['nonce'] )) {
			return $this->req;
		}
		if(!wp_verify_nonce( sanitize_text_field( $_REQUEST['nonce'] ), $this->_slug . 'ajax-nonce' )) {
			return $this->req;
		}
		if ( isset( $_REQUEST['postcode'] ) &&
		     isset( $_REQUEST['huisnummer'] ) && isset( $_REQUEST['toevoeging'] )) {


			$this->req = [
				'postcode' => sanitize_text_field( $_REQUEST['postcode'] ),
				'huisnummer'   => sanitize_text_field( $_REQUEST['huisnummer'] ),
				'toevoeging'   => sanitize_text_field( $_REQUEST['toevoeging'] )
			];
			if( isset( $_REQUEST['field_id'] ) && is_numeric($_REQUEST['field_id']) &&
			    isset( $_REQUEST['form_id'] ) && is_numeric($_REQUEST['form_id'])) {
				$form_id  = sanitize_text_field( $_REQUEST['form_id'] );
				$field_id = sanitize_text_field( $_REQUEST['field_id'] );

				if ( $field = \GFAPI::get_field( $form_id, $field_id ) ) {
					if($field->get_input_type() !== 'pchntv'){
						wp_die();
					}
					if ( isset( $field->only_existing_setting ) && $field->only_existing_setting && !is_user_logged_in() ) {
						$this->return_format['adres']['only_existing']         = true;
						$this->return_format['adres']['only_existing_message'] = $field->adress_not_found_message;
					}

					$pre_return = apply_filters('pchntv_ajax_pre_return_format', false, $this->return_format, $this->req, $form_id);

					if($pre_return && is_array($pre_return)){
						header('Content-type: application/json');
                        echo( json_encode( ['message' => $pre_return ] ) );
						wp_die();
					}
					if ( $this->get_plugin_setting( 'api' ) == 'postcodeapinu' && $this->_postcodenl ) {
						$this->lookup_postcodeapinu( $this->req );
					} else {
						$this->lookup_bag( $this->req );
					}
					if (
						$this->return_format['adres']['municipality_code'] ) {

						if ( isset( $field->gemeenteExclusive ) && is_numeric( $field->gemeenteExclusive ) &&
						     $this->return_format['adres']['municipality_code'] && ( $this->return_format['adres']['municipality_code'] != $field->gemeenteExclusive ) ) {
							$this->return_format['adres']['error'] = true;

							require_once( dirname( __DIR__ ) . '/data/bag.php' );
							$mcode                                   = ( new bag() )->get_gemeente_by_code( $field->gemeenteExclusive );
							$message                                 = str_replace( '[GEMEENTE]', $mcode,
								$field->gemeenteExclusiveError );
							$message                                 = str_replace( '[GEMEENTE_INGEVOERD]',
								$this->return_format['adres']['municipality'], $message );
							$this->return_format['adres']['message'] = $message;
						}
					};

				}

			}

			header('Content-type: application/json');

			$return_format = apply_filters('pchntv_ajax_return_format', $this->return_format);
            echo( json_encode( ['message' => $return_format ] ) );
		}
        die;
	}
	function lookup_postcodeapinu($request) {


		$args2 = array(
			'method'      => 'GET',
			'timeout'     => 5,
			'redirection' => 0,
			'blocking'    => true,
			'headers'     => array(
				'X-Api-Key' => $this->_postcodenl
			),
		);

		$url2 = 'https://api.postcodeapi.nu/v3/lookup/' .$request['postcode']  .'/'. $request['huisnummer'];
//		$url2 = 'https://api.postcodeapi.nu/v2/addresses/?postcode=1058xx&number=50&from=H';

		$response = wp_remote_get( $url2, $args2 );


		$result = [];
		if ( ! is_wp_error( $response ) ) {
			$result = json_decode( wp_remote_retrieve_body( $response ) );
			if (  $result && !isset($result->title) ) {

				require_once(dirname(__DIR__) . '/data/bag.php');
				$mcode = (new bag())->get_gemeente(sanitize_text_field($result->municipality));
				$province = (new bag())->get_provincie_by_code($mcode);
				$this->return_format = [
					'adres' => [
						'street'   => sanitize_text_field($result->street),
						'city'   => sanitize_text_field($result->city),
						'municipality'   => sanitize_text_field($result->municipality),
						'municipality_code'   => $mcode,
						'province'   => $province['Provincienaam'],
						'zip' => sanitize_text_field($result->postcode),
						'number' => sanitize_text_field($result->number),
						'found' => true,
						'error' => false,
						'message' => ''
					],
                    'found' => true,
				];



			}
		}
		return false;

	}
	function lookup_bag($request) {

        if ($this->get_plugin_setting('api') == 'datahub') {
            $api_url = 'https://datahub.danfield.eu/api/v2/bag';


            // JSON POST body
            $data = array(
                'jwt' => $this->getJwt(),
                'postcode' => $request['postcode'],

            );
        } else {
            $api_url = 'https://datahub.danfield.eu/api/bag';


            // JSON POST body
            $data = array(
                'postcode' => $request['postcode'],

            );
        }


        if(isset($request['huisnummer'])){
            $data['huisnummer']    = $request['huisnummer'];
        }
        if(isset($request['toevoeging'])){
            $data['toevoeging']    = '';
        }

        if(isset($request['toevoeging'])) {
            $data['toevoeging'] = $request['toevoeging'];

            if(is_numeric($request['toevoeging'])
                || $request['toevoeging'] == 'BS'
                || $request['toevoeging'] == 'GB1'

                || $request['toevoeging'] == 'GB2'
                || strlen($request['toevoeging']) > 2) {
                $data['toevoeging'] = $request['toevoeging'];
            }

        }

        $headers = [
            'X-Api-Key' => $this->get_plugin_setting( 'license_key' )
        ];

        $headers['hostname'] =  parse_url(get_option('home'))['host'];


        $args2 = array(
            'method' => 'GET',
            'timeout' => 20,
            'redirection' => 1,
            'blocking' => true,
            'headers' => $headers,
            'body' => $data
        );
        $api_url = $api_url . '?' . http_build_query($data);
        $hash = hash( 'sha256', $api_url );

        $cache = wp_cache_get( $hash, 'pchntv' );
        if ($cache ) {

            $this->return_format = $cache;
            $this->return_format['cache'] = true;
            return $this->return_format;

        }
		$response = wp_remote_request( $api_url, $args2);

		if ( ! is_wp_error( $response ) ) {
			$result = json_decode( wp_remote_retrieve_body( $response ), true );

            if(isset($result['code']) && $result['code'] == 200) {
                foreach ($result['message']['adres'] as $key => $value) {
                    if(is_array($value)){
                        $this->return_format['adres'][$key] = map_deep($value, 'sanitize_text_field');
                    } else {
                        $this->return_format['adres'][$key] = sanitize_text_field($value);
                    }


                }
                $this->return_format['found'] = true;
                $this->return_format['adres']['found'] = true;
                wp_cache_set($hash, $this->return_format, 'pchntv', 60 );
                return $this->return_format;
            }
		}
		return false;
	}


	function validate_municipality($request, $field, $gemeente){
		if(!$gemeente) {
			return false;
		}
		if($this->get_plugin_setting('api') == 'postcodeapinu'  && $this->_postcodenl ) {
			$this->lookup_postcodeapinu($request);
		} else {
			$this->lookup_bag($request);
		}

			if(isset($field->gemeenteExclusive) && is_numeric($field->gemeenteExclusive) &&
			   $this->return_format['adres']['municipality_code'] && ($this->return_format['adres']['municipality_code'] !== $field->gemeenteExclusive)){
				return true;
			}

			return false;

	}
	function only_existing($request, $field){

		if($this->get_plugin_setting('api') == 'postcodeapinu'  && $this->_postcodenl ) {
			return $this->lookup_postcodeapinu($request);
		} else {
			return $this->lookup_bag($request);
		}

		return false;

	}
}
