<?php

use GFPostcodeFieldAddOn\getaddress;

GFForms::include_addon_framework();

class GFPostcodeNlFieldAddOn extends GFAddOn
{

    /**
     * @var object $_instance If available, contains an instance of this class.
     */
    private static $_instance = null;
    protected $_version = GFPostcodeNL_FIELD_ADDON_VERSION;
    protected $_min_gravityforms_version = '2.4';
    protected $_slug = 'gravityformspostcodenl';
    protected $_name = 'gravityformspostcodenl';
    protected $_path = 'gravityformspostcode/gravityformspostcodenl.php';
    protected $_full_path = __FILE__;
    protected $_title = 'Gravity Forms Postcode Adresvalidatie NL Add-On';
    protected $_short_title = 'Postcode NL';
    protected $_postcodenl = false;
    public $set_status = null;
    public $license = false;

    /**
     * Returns an instance of this class, and stores it in the $_instance property.
     *
     * @return object $_instance An instance of this class.
     */
    public static function get_instance()
    {
        if (self::$_instance == null) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    /**
     * Include the field early so it is available when entry exports are being performed.
     */
    public function pre_init()
    {
        parent::pre_init();
        $this->license_key = $this->get_plugin_setting('license_key');

        $this->license = new \XSDigital\License_manager($this->_title, $this->_name, $this->_path, admin_url('admin.php?page=gf_settings&subview=gravityformspostcodenl'), $this->get_plugin_setting('license_key'), $this);
        $this->license->check_plugins();

        $this->license_status = $this->license->get_license_status();

        if ($this->license->has_required_plugins()) {

            $this->license->check_license();
            if ($this->license->get_license_status()) {
                if ($this->is_gravityforms_supported() && class_exists('GF_Field')) {

                    require_once 'includes/api/class-getaddress.php';
                    $adres = new getaddress();
                    $adres->init();

                    require_once('includes/fields/class-gf-field-postcodenl.php');
                }
            }
        }
        add_filter('gform_field_css_class', array($this, 'filter_gform_field_css_class'), 10, 3);
//		add_filter( 'gform_pre_render', array( $this, 'gform_pre_submission_filter' ), 10, 1 );
//
//		add_filter( 'gform_pre_validation', array( $this, 'gform_pre_submission_filter' ), 10, 1 );
//
//		add_filter( 'gform_pre_submission_filter', array( $this, 'gform_pre_submission_filter' ), 10, 1 );
//
//		add_filter( 'gform_admin_pre_render', array( $this, 'gform_pre_submission_filter' ), 10, 1 );


    }

    public function init()
    {
        parent::init();

        add_action('gform_field_standard_settings', array($this, 'only_existing_setting'), 10, 2);
        add_action('gform_field_standard_settings', array($this, 'optimize_datahub'), 10, 2);
        add_action('gform_field_advanced_settings', array($this, 'postcode_exclude'), 10, 2);
        add_action('gform_field_appearance_settings', array($this, 'duplicate_setting_message'), 150, 2);
        add_action('gform_editor_js', [$this, 'editor_script']);
    }

    function editor_script()
    {
        ?>
        <script>
            jQuery(document).ready(function () {


                //adding setting to fields of type "text"
                fieldSettings.pchntv += ', .postcode_settings';
                fieldSettings.pchntv += ', .postcode_settings_bag';
                fieldSettings.pchntv += ', .duplicate_setting_message';
                fieldSettings.pchntv += ', .only_existing_setting';
                fieldSettings.pchntv += ', .optimize_datahub';
                fieldSettings.pchntv += ', .adress_not_found_message';
                //binding to the load field settings event to initialize the checkbox
                jQuery(document).on('gform_load_field_settings', function (event, field, form) {
                    jQuery('#field_gemeente_exclusive').val(field.gemeenteExclusive);
                    jQuery('#field_gemeente_exclusive_errormessage').val(field.gemeenteExclusiveError);
                    jQuery("#field_postcode_oppervlakte").prop("checked", field.postcodeOppervlakte ? true : false);
                    jQuery("#field_postcode_gebruikstype").prop("checked", field.postcodeGebruikstype ? true : false);
                    jQuery("#field_postcode_bouwjaar").prop("checked", field.postcodeBouwjaar ? true : false);
                    jQuery('#duplicate_setting_message').val(field.duplicate_setting_message);
                    jQuery('#adress_not_found_message').val(field.adress_not_found_message);
                    jQuery("#only_existing_setting").prop("checked", field.only_existing_setting ? true : false);
                    jQuery("#optimize_datahub").prop("checked", field.optimize_datahub ? true : false);
                    // ToggleGemeenteExclusive(field.gemeenteExclusive)
                });
            });

            function ToggleGemeenteExclusive(val) {

                var val = val ? val : jQuery('#field_gemeente_exclusive option:selected').val();

                var speed = "fast";
                if (jQuery('#field_gemeente_exclusive').val()) {
                    // console.log('toon melding');
                    jQuery('.postcode_settings_error').show(speed);
                } else {
                    jQuery('.postcode_settings_error').hide(speed);
                    // console.log('verberg melding melding');
                }

            }
        </script>
    <?php }

    function only_existing_setting($position, $form_id)
    {

        if ($position == -1) {
            ?>
            <li style="margin-top: -7px;">
                <div class="only_existing_setting field_setting">
                    <input type="checkbox" id="only_existing_setting"
                           onclick="SetFieldProperty('only_existing_setting', this.checked);"
                           onkeypress="SetFieldProperty('only_existing_setting', this.checked);"/>
                    <label for="only_existing_setting" class="inline">
                        <?php esc_html_e('Geen handmatige input', 'gravityforms'); ?>
                        <?php gform_tooltip('form_only_existing_setting'); ?>
                    </label>
                </div>
            </li>
            <?php

        }
    }
    function optimize_datahub($position, $form_id)
    {

        if ($position == -1) {
            ?>
            <li>
                <div class="optimize_datahub field_setting">
                    <input type="checkbox" id="optimize_datahub"
                           onclick="SetFieldProperty('optimize_datahub', this.checked);"
                           onkeypress="SetFieldProperty('optimize_datahub', this.checked);"/>
                    <label for="optimize_datahub" class="inline">
                        <?php esc_html_e('Gebruik datahub direct', 'gravityforms'); ?>
                        <?php gform_tooltip('optimize_datahub'); ?>
                    </label>
                </div>
            </li>
            <?php

        }
    }

    function duplicate_setting_message($position, $form_id)
    {

        if ($position == 150) {
            ?>
            <li class="duplicate_setting_message field_setting">
                <label for="duplicate_setting_message" class="section_label">
                    <?php esc_html_e('Custom Duplicate Message', 'gravityforms'); ?>
                </label>
                <input type="text" id="duplicate_setting_message"
                       onchange="SetFieldProperty('duplicate_setting_message', this.value); "/>
            </li>
            <?php

        }
    }

    function postcode_exclude($position, $form_id)
    {

        if ($position == 0) {
            ?>

            <li class="postcode_settings field_setting">
                <label for="field_gemeente_exclusive" class="section_label">
                    <?php esc_html_e('Beperk inzending tot specifieke gemeente', $this->_name); ?>
                    <?php gform_tooltip('field_gemeente_exclusive') ?>
                </label>
                <select id="field_gemeente_exclusive"
                        onchange="SetFieldProperty('gemeenteExclusive', this.value); ToggleGemeenteExclusive()">
                    <option value=""><?php esc_html_e('Alle gemeenten toegestaan', $this->_name); ?></option>
                    <?php require_once('includes/data/bag.php');
                    $list = (new \XSDigital\bag())->get_gemeente_list();

                    foreach ($list as $gemeente_code => $gemeente_naam) {

                        ?>
                        <option value="<?= $gemeente_code ?>"><?= $gemeente_naam; ?></option>
                    <?php } ?>
                </select>
            </li>
            <li class="postcode_settings_error field_setting">
                <label for="field_gemeente_exclusive_errormessage" class="section_label">
                    <?php esc_html_e('Bericht indien aanmelding buiten gemeente', $this->_name); ?>
                    <?php gform_tooltip('field_gemeente_exclusive_errormessage') ?>
                </label>
                <input id="field_gemeente_exclusive_errormessage" type="text" class="fieldwidth-2"
                       value="Aanmeldingen niet toegestaan buiten de gemeente [GEMEENTE]"
                       onchange="SetFieldProperty('gemeenteExclusiveError', this.value); "/>
            </li>
            <li class="adress_not_found_message field_setting">
                <label for="adress_not_found_message" class="section_label">
                    <?php esc_html_e('Indien adres niet gevonden', $this->_name); ?>
                </label>
                <input id="adress_not_found_message" type="text" class="fieldwidth-2"
                       onchange="SetFieldProperty('adress_not_found_message', this.value); "/>
            </li>
            <?php if (in_array($this->get_plugin_setting('api'),['bag','datahub'])) { ?>

                <li class="postcode_settings_bag field_setting">
                    <label class="section_label">
                        <?php esc_html_e('Aanvullende woninggegevens opslaan', $this->_name); ?>
                    </label>
                    <input type="checkbox" id="field_postcode_bouwjaar" name="postcodeBouwjaar"
                           onclick="SetFieldProperty('postcodeBouwjaar', this.checked);"
                           onchange="SetFieldProperty('postcodeBouwjaar', this.checked); ">

                    <label for="field_postcode_bouwjaar" class="inline">
                        <?php esc_html_e('Bouwjaar', $this->_name); ?>
                    </label>
                    <br/>
                    <input type="checkbox" id="field_postcode_oppervlakte" name="postcodeOppervlakte"
                           onclick="SetFieldProperty('postcodeOppervlakte', this.checked);"
                           onchange="SetFieldProperty('postcodeOppervlakte', this.checked); ">

                    <label for="field_postcode_oppervlakte" class="inline">
                        <?php esc_html_e('Oppervlakte', $this->_name); ?>
                    </label>
                    <br/>
                    <input type="checkbox" id="field_postcode_gebruikstype" name="postcodeGebruikstype"
                           onclick="SetFieldProperty('postcodeGebruikstype', this.checked);"
                           onchange="SetFieldProperty('postcodeGebruikstype', this.checked); ">

                    <label for="field_postcode_gebruikstype" class="inline">
                        <?php esc_html_e('Gebruikstype', $this->_name); ?>
                    </label>

                </li>
                <?php
            }
        }
    }

    public function init_admin()
    {
        parent::init_admin();

        add_filter('gform_tooltips', array($this, 'tooltips'));
    }

    public function plugin_settings_title()
    {
        return sprintf(translate("%s Settings", "gravityforms"), $this->get_short_title());
    }

    public function filter_gform_field_css_class($css_class, $field, $form)
    {

        if (GFFormsModel::get_input_type($field) === 'pchntv') {
            $css_class .= ' gfield_pchntv';

        }

        return $css_class;
    }

    public function plugin_settings_icon()
    {
        return '';
    }

    /**
     * Configures the settings which should be rendered on the add-on settings tab.
     *
     * @return array
     */
    public function plugin_settings_fields()
    {
        $fields = array(

            array(
                'name' => 'license_key',
                'type' => 'text',
                'placeholder' => __('Enter the license key', $this->_name),
                'label' => esc_html__('License key', $this->_name),
                'horizontal' => true,
                'tooltip' => sprintf(
                    '<h6>%s</h6>%s',
                    __('License key Gravity Forms Postcode NL', $this->_name),
                    __('Enter the licence key from danfield.eu', $this->_name)
                ),
                'feedback_callback' => array($this, 'feedback_callback_get_license_status')

            )
        );

        $return = [
            array(
                'title' => esc_html__('Postcode NL', $this->_name),
                'fields' => $fields
            )
        ];
        $fields = array(

            array(
                'name' => 'api',
                'type' => 'select',
                'required' => true,
                'label' => esc_html__('Bron', $this->_name),
                'choices' => array(
                    array(
                        'label' => esc_html__('bagviewer.kadaster.nl (stopt per 1 april 2022, via datahub)', $this->_name),
                        'value' => 'bag',
                    ),
                    array(
                        'label' => esc_html__('DanField.eu datahub (Belgie & Nederland)', $this->_name),
                        'value' => 'datahub',
                    ),
                    array(
                        'label' => esc_html__('PostcodeAPI.nu', $this->_name),
                        'value' => 'postcodeapinu',
                    ),
                ),
                'default_value' => 'bag',
                'horizontal' => true,
                'tooltip' => sprintf(
                    '<h6>%s</h6>%s',
                    esc_html__('Kies de bron', $this->_name),
                    esc_html__('Momenteel bieden we BAG en PostcodeAPI.nu als bron', $this->_name)
                ),

//				    'onchange' => 'submit()',
            ),
        );

        $fields[] =
            array(
                'name' => 'postcodeapinu_key',
                'type' => 'text',
                'required' => true,
                'label' => esc_html__('API key', $this->_name),
                'horizontal' => true,
                'description' => '',
                'tooltip' => sprintf(
                    '<h6>%s</h6>%s',
                    esc_html__('API key PostcodeAPI.nu', $this->_name),
                    esc_html__('Vul hier de apikey in', $this->_name)
                ),
                'dependency' => array(
                    'live' => true,
                    'fields' => array(
                        array(
                            'field' => 'api',
                            'values' => array('postcodeapinu'),
                        ),
                    ),
                ),
                'feedback_callback' => array($this, 'validate_postcodeapinu'),

            );

        $return[] =
            array(
                'title' => esc_html__('Hoe moeten de gegevens opgehaald worden?', $this->_name),
                'fields' => $fields,
                'dependency' => array($this, 'get_license_status'),
            );

        return $return;
    }

    public function get_menu_icon()
    {

        return 'dashicons-admin-multisite';

    }

    public function validate_postcodeapinu($key)
    {
        $args2 = array(
            'method' => 'GET',
            'timeout' => 25,
            'redirection' => 0,
            'blocking' => true,
            'headers' => array(
                'X-Api-Key' => $key
            ),
        );

        $url2 = 'https://api.postcodeapi.nu/v3/lookup/2101AC/10';


        $response = wp_remote_get($url2, $args2);
        if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) == 200) {
            return true;
        }
        return false;
    }

    // # SCRIPTS & STYLES -----------------------------------------------------------------------------------------------
    public function get_license_status($license_key = null, $settings = null)
    {

        return $this->set_status;
    }

    public function feedback_callback_get_license_status($license_key = null)
    {

        $apikey = $this->license_key;
        if ($license_key) {
            $apikey = $license_key;
        }

        $domain = get_site_url();
        $domain = parse_url($domain);
        $url = 'https://kernl.us/api/v2/public/license/validate-with-domain?license=' . $apikey . '&domain=' . $domain['host'];
        $response = wp_remote_get($url);

        if (wp_remote_retrieve_response_code($response) == 200) {
            $this->set_status = true;
            return true;
        }
        $this->set_status = false;
        return false;
    }

    /**
     * Include my_script.js when the form contains a 'simple' type field.
     *
     * @return array
     */
    public function scripts()
    {
        $scripts = array(
            array(
                'handle' => 'gfpcnl_js',
                'src' => $this->get_base_url() . '/dist/scripts/app.js',
                'version' => $this->_version,
                'deps' => array('jquery'),
                'callback' => array($this, 'localize_results_scripts'),
                'admin_page' => array('form_settings', 'plugin_settings'),
                'enqueue' => array(
                    array('field_types' => array('pchntv')),
                    array('admin_page' => array('entry_edit')),
                ),


            ),
            array(
                'handle' => 'gfpcnl_js_admin',
                'src' => $this->get_base_url() . '/dist/scripts/admin.js',
                'version' => $this->_version,
                'deps' => array('jquery'),
                'callback' => array($this, 'admin_scripts'),
                'enqueue' => array(
                    array('admin_page' => array('plugin_settings')),
                )


            ),
        );
        return array_merge(parent::scripts(), $scripts);
    }

    public function admin_scripts()
    {
        // Get current page protocol
        $protocol = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
        // Output admin-ajax.php URL with same protocol as current page

        $vars = array(
            'ajaxurl' => admin_url( 'admin-ajax.php', $protocol ),
            'nonce' => wp_create_nonce($this->_slug . 'ajax-nonce'),
        );
        if ($this->get_plugin_setting('api') == 'datahub') {
            $vars['datahuburl'] = 'https://datahub.danfield.eu/api/v2/bag/';
            $vars['jwt'] = $this->getJwt();;
        };

        wp_localize_script('gfpcnl_js_admin', 'gfpchntv', $vars);

    }

    public function getJwt()
    {
        if ($this->get_plugin_setting('api') == 'datahub') {
            $token_key = 'pchntv_jwt_token';

            if ($token = get_transient($token_key)) {
                if(!empty($token)) {
                    return $token;
                }
            }

            $domain = get_site_url();
            $domain = parse_url($domain);
            $params = [
                'license' => $this->get_plugin_setting('license_key'),
                'domain' => $domain['host']
            ];

            $url = 'https://datahub.danfield.eu/api/v2/jwt/create?' . http_build_query($params);

            $args = [
                'sslverify' => true,
            ];
            $response = wp_remote_get($url, $args);

            if (!is_wp_error($response)) {
                $data = json_decode(wp_remote_retrieve_body($response));
                $token = sanitize_text_field($data->token);

                set_transient($token_key, $token, 60 * 60 * 12);
                return $token;
            }
        }
        return '';
    }

    public function localize_results_scripts()
    {

        // Get current page protocol
        $protocol = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
        // Output admin-ajax.php URL with same protocol as current page

        $vars = array(
            'ajaxurl' => admin_url( 'admin-ajax.php', $protocol ),
            'nonce' => wp_create_nonce($this->_slug . 'ajax-nonce'),
        );
        if ($this->get_plugin_setting('api') == 'datahub') {
            $vars['datahuburl'] = 'https://datahub.danfield.eu/api/v2/bag/';
            $vars['jwt'] = $this->getJwt();
        };

        wp_localize_script('gfpcnl_js', 'gfpcnl_js', $vars);

    }

    /**
     * Include my_styles.css when the form contains a 'simple' type field.
     *
     * @return array
     */
    public function styles()
    {
        $styles = array(
            array(
                'handle' => 'gfpcnl_css',
                'src' => $this->get_base_url() . '/dist/styles/app.css',
                'version' => $this->_version,
                'admin_page' => array('form_settings', 'plugin_settings', 'plugin_page', 'app_settings'),
                'enqueue' => array(
                    array('field_types' => array('pchntv')),
                    array('admin_page' => array('form_settings', 'plugin_settings', 'entry_edit', 'form_editor')),
                )
            ),
            array(
                'handle' => 'gfpcnl_css_admin',
                'src' => $this->get_base_url() . '/dist/styles/admin.css',
                'version' => $this->_version,
                'enqueue' => array(
                    array('admin_page' => array('form_settings', 'plugin_settings', 'entry_edit', 'form_editor'))
                )

            )
        );
        $return = array_merge(parent::styles(), $styles);

        return $return;
    }


    // # FIELD SETTINGS -------------------------------------------------------------------------------------------------

    /**
     * Add the tooltips for the field.
     *
     * @param array $tooltips An associative array of tooltips where the key is the tooltip name and the value is the tooltip.
     *
     * @return array
     */
    public function tooltips($tooltips)
    {
//	    return $tooltips;
        $simple_tooltips = array(

            'field_gemeente_exclusive_errormessage' => sprintf('<h6>%s</h6>%s', esc_html__('Error message', $this->_name),
                esc_html__('Bericht wat getoond wordt indien de gemeente niet overenkomt. Gebruik de shortcode [GEMEENTE] voor de instellin en [GEMEENTE_INGEVOERD] voor de gebruikerinput', $this->_name)),
            'field_gemeente_exclusive' => sprintf('<h6>%s</h6>%s', esc_html__('Beperk inzending op gemeenteniveau', $this->_name),
                esc_html__('Selecteer de gemeente en de inzendingen voor dit veld worden beperkt tot die specifieke gemeente (indien gevonden, anders slaat hij deze validatie over)', $this->_name)),
            'form_only_existing_setting' => sprintf('<h6>%s</h6>%s', esc_html__('Geen handmatige input', $this->_name),
                esc_html__('Indien de postcode lookup geen adres kan vinden of niet beschikbaar is. Kan de gebruiker geen handmatige input leveren. Indien je bent ingelogd is het wel mogelijk om handmatig een adres in te voeren.', $this->_name)),
            'optimize_datahub' => sprintf('<h6>%s</h6>%s', esc_html__('Gebruik datahub direct', $this->_name),
                esc_html__('Indien je geen gebruik gemaakt van custom actions zoals pchntv_ajax_pre_return_format of pchntv_ajax_return_format vink deze optie dan aan. Hiermee kun je direct op onze datahub een request doen.', $this->_name)),

        );

        return array_merge($tooltips, $simple_tooltips);
    }


}