<?php
/*
Plugin Name: Gravity Forms LaPosta add-on
Plugin URI: https://www.joswaalkens.nl
Description: Integrates Gravity Forms with LaPosta, allowing form submissions to be automatically sent to your LaPosta account.
Version: 1.0
Author: JW - Jouw schakel in de IT
Author URI: https://joswaalkens.nl/
License: 
Text Domain: gravityformslaposta
Domain Path: /languages

------------------------------------------------------------------------
Copyright 2009-2022 JosWaalkens

*/


// Don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

define( 'GF_LAPOSTA_VERSION', '1.9' );

// If Gravity Forms is loaded, bootstrap the LaPosta add-on
add_action( 'gform_loaded', array( 'GF_LaPosta_Bootstrap', 'load' ), 5 );

/**
 * Class GF_LaPosta_Bootstrap
 *
 * Handles the loading of the LaPosta add-on and registers with the add-on framework.
 */
class GF_LaPosta_Bootstrap {

	/**
	 * If the Feed add-onFramework exists, Post Creation add-on is loaded.
	 *
	 * @access public
	 * @static
	 */
	public static function load() {

		if ( ! method_exists( 'GFForms', 'include_feed_addon_framework' ) ) {
			return;
		}

		require_once( 'class-gf-laposta.php' );

		GFAddOn::register( 'GFLaPosta' );

	}

}

/**
 * Returns an instance of the GFLaPosta class
 *
 * @see    GFLaPosta::get_instance()
 *
 * @return object GFLaPosta
 */
function gf_LaPosta() {
	return GFLaPosta::get_instance();
}
