( function ( GF_Google_Analytics_Admin, $ ) {
	jQuery( document ).ready( function() {
		// Main form wrapper.
		var $form = $( '#gform-settings' );

		// Handle disconnects from the admin.
		var $disconnect = $( '.gfga-disconnect' );
		if ( $disconnect.length > 0 ) {
			$disconnect.on( 'click', function( e ) {
				e.preventDefault();
				$disconnect.html( google_analytics_admin_strings.disconnect );

				var url_params = wpAjax.unserialize( e.target.href );
				var nonce_value = url_params.nonce;

				// Perform Ajax request.
				$.post(
					ajaxurl,
					{
						action: 'disconnect_account',
						nonce: nonce_value,
					},
					function( response ) {
						window.location.href = window.location.href;
					}
				);
			} );
		}

		// Handle form submission on connect screen
		$form.on( 'submit', function( e ) {

			// Determining if we're just connecting for the first time.
			if ( $form.find( 'input[value="google_analytics_setup"]' ).length == 1 ) {
				// is_postback
				e.preventDefault();

				// Set l18n.
				var $save_button = $form.find( '#gform-settings-save' );
				var $mode = $form.find( '[name="_gform_setting_mode"]:checked').val();
				$save_button.prop( 'value', google_analytics_admin_strings.redirect ).prop( 'disabled', 'disabled' );

				// Get nonce.
				var nonce_value = $form.find( 'input[name="gfganonce"]').val();

				// Perform Ajax request.
				$.post(
					ajaxurl,
					{
						action: 'redirect_to_api',
						nonce: nonce_value,
						mode: $mode,
					},
					function( response ) {
						if ( ! response.data.errors ) {
							window.location.href = response.data.redirect;
						}
					},
					'json'
				);

				return;
			}

			// Determine if we're executing in the correct form
			var $action = $form.find( 'input[name="gfgaaction"]');
			if( $action.length == 0 ) {
				return;
			}

			// Get the nonce
			var nonce = $form.find( 'input[name="gfganonce"]' ).val();
			var token = $form.find('input[name="gfga_token"]' ).val();
			var refresh = $form.find('input[name="gfga_refresh"]' ).val();
			if ( 'ga' === $action.val() ) {
				e.preventDefault();

				// Update the submit button text to show connecting
				var $submit_button = $form.find( ':submit' );
				$submit_button.val( google_analytics_admin_strings.connecting ).prop( 'disabled', 'disabled' );

				// We're in Google Analytics mode
				var $select = $form.find( 'select[name="gaproperty"]' );
				var ga_code = $select.val();
				var account_id = $select.find(':selected').data( 'account-id' );
				var account_name = $select.find(':selected').data('account-name');
				if ( undefined === account_id || '' === account_id ) {
					alert( google_analytics_admin_strings.ga_required );
					$submit_button.prop( 'disabled', false );
					return;
				}

				// Get the View
				var view = $( '#ga-views select :selected' ).val();
				if ( undefined === view || '' === view ) {
					alert( google_analytics_admin_strings.view_required );
					$submit_button.prop( 'disabled', false );
					return;
				}
				var view_name = $( '#ga-views select :selected' ).data( 'view-name' );

				$.post(
					ajaxurl,
					{
						action: 'save_google_analytics_data',
						nonce: nonce,
						token: token,
						refresh: refresh,
						account_id: account_id,
						account_name: account_name,
						ga_code: ga_code,
						view: view,
						view_name: view_name
					},
					function( response ) {
						window.location.href = response;
					}
				);
			}
			if ( 'gtm' === $action.val() ) {
				// We're in Google Tag Manager mode

				e.preventDefault();

				// Update the submit button text to show connecting
				var $submit_button = $form.find( ':submit' );
				$submit_button.val( google_analytics_admin_strings.connecting ).prop( 'disabled', 'disabled' );

				// Get Google Analytics data
				var $select = $form.find( 'select[name="gaproperty"]' );
				var ga_code = $select.val();
				var account_id = $select.find( ':selected' ).data( 'account-id' );
				var account_name = $select.find( ':selected' ).data( 'account-name' );
				if ( undefined === account_id || '' === account_id ) {
					alert( google_analytics_admin_strings.ga_required );
					$submit_button.prop( 'disabled', false );
					return;
				}

				// Get the View
				var view = $( '#ga-views select :selected' ).val();
				if ( undefined === view || '' === view ) {
					alert( google_analytics_admin_strings.view_required );
					$submit_button.prop( 'disabled', false );
					return;
				}
				var view_name = $( '#ga-views select :selected' ).data( 'view-name' );

				// Get GTM Data
				var $gtm_select = $form.find( 'select[name="gtmproperty"]' );
				var gtm_account_id = $gtm_select.find(':selected').data( 'account-id' );
				var gtm_path = $gtm_select.find( ':selected' ).data( 'path' );
				var gtm_container = $gtm_select.find( ':selected' ).val();
				if ( undefined === gtm_container || '' === gtm_container ) {
					alert( google_analytics_admin_strings.gtm_required );
					$submit_button.prop( 'disabled', false );
					return;
				}

				// Get Google Workspace data
				var $select = $form.find( 'select[name="gaworkspace"]' );
				var workspace = $select.val();
				if ( undefined === workspace || '' === workspace ) {
					alert( google_analytics_admin_strings.workspace_required );
					$submit_button.prop( 'disabled', false );
					return;
				}

				// Get GTM Opt-out Data
				var gtm_auto_create = $form.find( 'input[name="gtm_auto_create"]:checked' );
				if ( gtm_auto_create.length == 0 ) {
					gtm_auto_create = 'on';
				} else {
					gtm_auto_create = gtm_auto_create.val();
				}

				$.post(
					ajaxurl,
					{
						action: 'save_google_tag_manager_data',
						nonce: nonce,
						token: token,
						refresh: refresh,
						account_id: account_id,
						account_name: account_name,
						ga_code: ga_code,
						gtm_account_id: gtm_account_id,
						gtm_path: gtm_path,
						gtm_container: gtm_container,
						gtm_auto_create: gtm_auto_create,
						gtm_workspace: workspace,
						view: view,
						view_name: view_name
					},
					function( response ) {
						window.location.href = response;
					}
				);
			}
		} );

		// Get views for selected UA account.
		$( '#gaproperty' ).on( 'change', function( e ) {
			var $option = $( this ).find( ':selected' );
			var ua_code = $option.data( 'ua-code' );
			var profile_id = $option.data( 'account-id' );
			var token = $option.data( 'token' );
			var nonce = $( 'body' ).find( 'input[name="gfganonce"]' ).val();
			$( '#ga-views' ).html( '<br /><img src="' + google_analytics_admin_strings.spinner + '" />' );
			$.post(
				ajaxurl,
				{
					action: 'get_ga_views',
					account_id: profile_id,
					ga_code: ua_code,
					nonce: nonce,
					token: token,
				},
				function( response ) {
					$( '#ga-views' ).html( response );
				}
			);
		} );
		// Get views for selected UA account.
		$( '#gtmproperty' ).on( 'change', function( e ) {
			var $option = $( this ).find( ':selected' );
			var path = $option.data( 'path' );
			var token = $option.data( 'token' );
			var nonce = $( 'body' ).find( 'input[name="gfganonce"]' ).val();
			$( '#gtm-workspaces' ).html( '<br /><img src="' + google_analytics_admin_strings.spinner + '" />' );
			$.post(
				ajaxurl,
				{
					action: 'get_gtm_workspaces',
					path: path,
					nonce: nonce,
					token: token,
				},
				function( response ) {
					$( '#gtm-workspaces' ).html( response );
				}
			);
		} );
	} );
}( window.GF_Google_Analytics_Admin = window.GF_Google_Analytics_Admin || {}, jQuery ) );
