<?php

/**
 * Uninstaller for Complianz plugin
 *
 * This script is executed when the plugin is uninstalled from WordPress.
 * It clears all plugin data and removes database tables.
 *
 *
 */

// If uninstall is not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit();
}

$cmplz_settings = get_option('cmplz_options', []);

if (isset($cmplz_settings['clear_data_on_uninstall']) && $cmplz_settings['clear_data_on_uninstall']) {
    // cmplz options
    $options = [
        'cmplz_activation_time',
        'cmplz_active_integrations',
        'cmplz_ajax_fallback_active',
        'cmplz_cbdb_version',
        'cmplz_changed_cookies',
        'cmplz_clear_tcf_purposes_after_upgrade',
        'cmplz_cookie-statement_custom_page',
        'cmplz_cookie_data_verified_date',
        'cmplz_cookietable_version',
        'cmplz_current_datarequest_export_offset',
        'cmplz_current_datarequest_export_progress',
        'cmplz_current_poc_export_offset',
        'cmplz_current_poc_export_progress',
        'cmplz-current-version',
        'cmplz_curl_error',
        'cmplz_datarequests_db_version',
        'cmplz_datarequest_export_args',
        'cmplz_datarequest_file_name',
        'cmplz_deactivated',
        'cmplz_deleted_cookies',
        'cmplz_detected_console_errors',
        'cmplz_detected_forms',
        'cmplz_detected_social_media',
        'cmplz_detected_stats',
        'cmplz_detected_stats_data',
        'cmplz_detected_stats_type',
        'cmplz_detected_thirdparty_services',
        'cmplz_disabled_placeholders',
        'cmplz_dismissed_warnings',
        'cmplz_dnsmpd_db_version',
        'cmplz_documents_update_date',
        'cmplz_double_stats',
        'cmplz_dynamic_options',
        'cmplz_elementor_banner_dropped',
        'cmplz_elementor_hub_autogenerated',
        'cmplz_enabled_best_performer',
        'cmplz_excluded_posts_array',
        'cmplz_first_sync_started',
        'cmplz_first_version',
        'cmplz_generate_new_cookiepolicy_snapshot',
        'cmplz_geo_ip_file',
        'cmplz_geoip_import_error',
        'cmplz_import_geoip_on_activation',
        'cmplz_integrations_changed',
        'cmplz_last_cookie_scan',
        'cmplz_last_cookie_sync',
        'cmplz_last_update_geoip',
        'cmplz_legal_version',
        'cmplz_license_activation_limit',
        'cmplz_license_activations_left	',
        'cmplz_license_attempts	',
        'cmplz_license_expires',
        'cmplz_license_key',
        'cmplz_license_notice_dismissed',
        'cmplz_license_status',
        'cmplz_onboarding_dismissed',
        'cmplz_options',
        'cmplz_pdf_dir_token',
        'cmplz_plugins_changed',
        'cmplz_plugins_updated',
        'cmplz_post_scribe_required',
        'cmplz_preloaded_privacy_info',
        'cmplz_privacy-statement_custom_page',
        'cmplz_publish_date',
        'cmplz_purposes_stored',
        'cmplz_remote_homepage_scanned',
        'cmplz_reported_cookies',
        'cmplz_review_notice_shown',
        'cmplz_roc_export_args',
        'cmplz_run_activation',
        'cmplz_run_premium_install',
        'cmplz_run_premium_upgrade',
        'cmplz_serviceTypes_stored',
        'cmplz_show_cookiedatabase_optin',
        'cmplz_statsdb_version',
        'cmplz_sync_cookies_after_services_complete',
        'cmplz_sync_cookies_complete',
        'cmplz_synced_cookiedatabase_once',
        'cmplz_sync_services_complete',
        'cmplz_tcf_mail_sent',
        'cmplz_tracking_ab_started',
        'cmplz_transients',
        'cmplz_upgraded_to_five',
        'cmplz_upgraded_tcf_settings',
        'cmplz_update_legal_documents_mail_sent',
        'cmplz_vendorlist_downloaded_once',
        'cmplz_wizard_completed_once',
        'complianz_active_policy_id',
        'complianz_key',
        'complianz_options_custom-scripts',
        'complianz_options_dataleak',
        'complianz_options_integrations',
        'complianz_options_processing',
        'complianz_options_settings',
        'complianz_options_wizard',
        'complianz_scan_token',
        'cmplz_wsc_error_email_not_sent',
        'cmplz_wsc_signup_status',
        'cmplz_wsc_signup_date',
        'cmplz_wsc_status',
        'cmplz_wsc_error_email_mismatch',
        'cmplz_wsc_error_missing_token',
        'cmplz_wsc_error_email_auth_failed',
        'cmplz_wsc_auth_completed',
        'cmplz_wsc_connection_updated',
        'cmplz_wsc_error_token_api',
        'cmplz_wsc_onboarding_status',
        'cmplz_wsc_onboarding_start',
        'cmplz_wsc_onboarding_complete',
		'cmplz_wsc_scan_id',
		'cmplz_wsc_scan_createdAt',
		'cmplz_wsc_scan_status',
		'cmplz_wsc_scan_iteration',
		'cmplz_wsc_scan_progress',
    ];


    foreach ($options as $option_name) {
        delete_option($option_name);
        delete_site_option($option_name);
    }

    global $wpdb;

    // cmplz dynamic options
    $dynamic_options = [
        'cmplz_%_custom_page_url',
        'cmplz_%_custom_page',
        'cmplz_purposes_%',
        'cmplz_serviceTypes_%',
        'cmplz_consent_%',
        'cmplz_wsc_user_deletion_%',
        'cmplz_newsletter_signup_%',
		'cmplz_%_consentdata',
		'cmplz_consent_error_%'
	];

    foreach ($dynamic_options as $option_name) {
        $wpdb->query(
            $wpdb->prepare(
                "DELETE FROM $wpdb->options WHERE option_name LIKE %s",
                $option_name
            )
        );
    }


    // cmplz transients
    $transients = [
        '_transient_cmplz_%',
        '_transient_timeout_cmplz_%',
        '_transient_complianz_%',
        '_transient_timeout_complianz_%'
    ];

    foreach ($transients as $transient) {
        $wpdb->query(
            $wpdb->prepare(
                "DELETE FROM $wpdb->options WHERE option_name LIKE %s",
                $transient
            )
        );
    }


    // cmplz tables
    $table_names = [
        $wpdb->prefix . 'cmplz_statistics',
        $wpdb->prefix . 'cmplz_cookies',
        $wpdb->prefix . 'cmplz_services',
        $wpdb->prefix . 'cmplz_cookiebanners',
        $wpdb->prefix . 'cmplz_dnsmpd',
	];

    foreach ($table_names as $table_name) {
        $sql = "DROP TABLE IF EXISTS $table_name";
        $wpdb->query($sql);
    }
}
