import UseWebSiteScanData from "./UseWebSiteScanData";
import { memo, useMemo } from "@wordpress/element";
import Icon from "../../utils/Icon";
import { __ } from '@wordpress/i18n';
import "./WebSiteScanStatus.scss";

const statuses = {
	'enabled': {
		label: __("Enabled", "complianz-gdpr"),
		color: 'green',
	},
	'disabled': {
		label: __("Disabled", "complianz-gdpr"),
		color: 'grey',
	},
	'pending': {
		label: __("Pending", "complianz-gdpr"),
		color: 'orange',
	},
	'error': {
		label: __("Error", "complianz-gdpr"),
		color: 'red',
	},
}

const WebSiteScanStatus = () => {
	const { tokenStatus, wscStatus, wscSignupDate, requestActivationEmail } = UseWebSiteScanData();

	// Check if enough time has passed to request activation email again
	const canRequestAgain = useMemo(() => {
		if (!wscSignupDate) { return false; }

		const currentTime = Math.floor(Date.now() / 1000);
		const oneHourInSeconds = 60 * 60;
		const timeDifference = currentTime - wscSignupDate;

		return timeDifference >= oneHourInSeconds;
	}, [wscSignupDate]);

	const handleRequestActivationEmail = (e) => {
		e.preventDefault();
		requestActivationEmail();
	}

	return (
		<div className="cmplz-wsc-status-container">
			{tokenStatus &&
				<div className="cmplz-wsc-status-row">
					<Icon name={'circle-check'} color={statuses[tokenStatus]?.color} size={16} />
					<span>{__("Token Status: ", "complianz-gdpr")}
						<strong>{statuses[tokenStatus]?.label}</strong>
					</span>
				</div>
			}

			{wscStatus &&
				<div className="cmplz-wsc-status-row">
					<Icon name={'circle-check'} color={statuses[wscStatus]?.color} size={16} />
					<span>{__("Website Scan Status: ", "complianz-gdpr")}
						<strong>{statuses[wscStatus]?.label}</strong>
					</span>
				</div>
			}
			{tokenStatus && tokenStatus === 'pending' && (
				<div className="cmplz-wsc-status-row">
					{canRequestAgain ? (
						<div>
							<span>{__("Didn't receive the activation email? ", "complianz-gdpr")}</span>
							<a href="#" onClick={handleRequestActivationEmail}>
								{__("Request again!", "complianz-gdpr")}
							</a>
						</div>
					) : (
						<div>
							<p>{__('Check your email to activate the Website Scan!', 'complianz-gdpr')}</p>
							<p>{__("Didn't receive the activation email? Please wait 1 hour before requesting again.", "complianz-gdpr")}</p>
						</div>
					)}
				</div>
			)}
		</div>
	)
}
export default memo(WebSiteScanStatus)
