import { __ } from '@wordpress/i18n';
import { useNewOnboardingData } from "../NewOnboardingData";

const ThankYou = () => {
	const { currentStep, enableWsc } = useNewOnboardingData();
	return (
		<div className={`cmplz-modal-content-step ${currentStep}`}>
			<div className='cmplz_thank-you'>

				{enableWsc &&
					<>
						<svg width="180" height="162" viewBox="0 0 180 162" fill="none" xmlns="http://www.w3.org/2000/svg">
							<g clip-path="url(#clip0_5_14)">
								<path d="M178.421 61.792C178.356 61.7921 178.294 61.7723 178.241 61.7355L90.9063 0.913294C90.6405 0.729062 90.3247 0.630605 90.0013 0.631157C89.6779 0.631708 89.3624 0.731241 89.0973 0.916377L2.392 61.7348C2.32342 61.7829 2.23854 61.8018 2.15603 61.7874C2.07353 61.7729 2.00015 61.7262 1.95204 61.6576C1.90394 61.589 1.88505 61.5042 1.89953 61.4217C1.91401 61.3392 1.96068 61.2658 2.02926 61.2177L88.7346 0.39921C89.1059 0.140058 89.5475 0.000750853 90.0003 6.81078e-06C90.453 -0.000737231 90.8952 0.137116 91.2672 0.395047L178.602 61.217C178.657 61.2555 178.698 61.3105 178.72 61.3742C178.742 61.4378 178.743 61.5067 178.722 61.5709C178.702 61.635 178.662 61.6911 178.608 61.7309C178.554 61.7706 178.488 61.7921 178.421 61.792Z" fill="#3F3D56" />
								<path d="M7.34644 63.948L90.0871 2.62705L173.455 68.3113L94.3502 115.206L51.4029 105.417L7.34644 63.948Z" fill="#E6E6E6" />
								<path d="M55.028 144.171H14.1521C13.9012 144.171 13.6526 144.122 13.4206 144.026C13.1886 143.93 12.9778 143.79 12.8002 143.612C12.6226 143.435 12.4817 143.224 12.3856 142.993C12.2895 142.761 12.24 142.512 12.24 142.261C12.24 142.01 12.2895 141.762 12.3856 141.53C12.4817 141.298 12.6226 141.087 12.8002 140.91C12.9778 140.733 13.1886 140.592 13.4206 140.496C13.6526 140.4 13.9012 140.351 14.1521 140.351H55.028C55.279 140.351 55.5276 140.4 55.7596 140.496C55.9916 140.592 56.2024 140.733 56.38 140.91C56.5576 141.087 56.6985 141.298 56.7946 141.53C56.8907 141.762 56.9402 142.01 56.9402 142.261C56.9402 142.512 56.8907 142.761 56.7946 142.993C56.6985 143.224 56.5576 143.435 56.38 143.612C56.2024 143.79 55.9916 143.93 55.7596 144.026C55.5276 144.122 55.279 144.171 55.028 144.171Z" fill="#009FFF" />
								<path d="M28.8175 135.96H14.1521C13.9012 135.961 13.6526 135.912 13.4206 135.816C13.1886 135.72 12.9778 135.579 12.8002 135.402C12.6226 135.224 12.4817 135.014 12.3856 134.782C12.2895 134.55 12.24 134.302 12.24 134.051C12.24 133.8 12.2895 133.551 12.3856 133.319C12.4817 133.087 12.6226 132.877 12.8002 132.699C12.9778 132.522 13.1886 132.381 13.4206 132.286C13.6526 132.19 13.9012 132.141 14.1521 132.141H28.8175C29.0685 132.141 29.3171 132.19 29.5491 132.286C29.781 132.381 29.9919 132.522 30.1694 132.699C30.347 132.877 30.4879 133.087 30.5841 133.319C30.6802 133.551 30.7297 133.8 30.7297 134.051C30.7297 134.302 30.6802 134.55 30.5841 134.782C30.4879 135.014 30.347 135.224 30.1694 135.402C29.9919 135.579 29.781 135.72 29.5491 135.816C29.3171 135.912 29.0685 135.961 28.8175 135.96Z" fill="#009FFF" />
								<path d="M91.2506 98.103C90.94 98.1033 90.6322 98.0431 90.3446 97.9255L39.3159 76.7522V10.4762C39.3166 9.89015 39.5497 9.32829 39.9641 8.91388C40.3785 8.49948 40.9404 8.26636 41.5264 8.26568H139.421C140.007 8.26636 140.569 8.49948 140.984 8.91388C141.398 9.32829 141.631 9.89015 141.632 10.4762V76.7985L141.536 76.8395L92.1841 97.9152C91.8886 98.0394 91.5712 98.1032 91.2506 98.103Z" fill="white" />
								<path d="M91.2506 98.2607C90.9193 98.2611 90.5911 98.1969 90.2844 98.0717L39.158 76.8577V10.4762C39.1587 9.84827 39.4084 9.24626 39.8524 8.80225C40.2965 8.35824 40.8985 8.10848 41.5264 8.10777H139.421C140.049 8.10848 140.651 8.35824 141.095 8.80225C141.539 9.24626 141.789 9.84827 141.79 10.4762V76.9027L92.246 98.0603C91.9309 98.1929 91.5924 98.261 91.2506 98.2607ZM39.7895 76.4358L90.5252 97.4878C90.9985 97.6798 91.5284 97.6766 91.9993 97.479L141.158 76.4858V10.4762C141.157 10.0157 140.974 9.57427 140.649 9.24866C140.323 8.92306 139.882 8.7399 139.421 8.73935H41.5264C41.0659 8.7399 40.6245 8.92306 40.2989 9.24866C39.9733 9.57427 39.7901 10.0157 39.7895 10.4762L39.7895 76.4358Z" fill="#3F3D56" />
								<path d="M177.789 61.1605H177.726L141.474 76.6405L91.8727 97.8205C91.6789 97.902 91.4709 97.9445 91.2606 97.9456C91.0504 97.9467 90.8419 97.9063 90.6473 97.8268L39.4737 76.5963L2.33049 61.1857L2.27375 61.1605H2.21053C1.62446 61.1611 1.06258 61.3942 0.648164 61.8086C0.233751 62.2231 0.00065029 62.7849 0 63.371V159.371C0.000651124 159.957 0.233751 160.519 0.648164 160.933C1.06258 161.348 1.62446 161.581 2.21053 161.582H177.789C178.376 161.581 178.937 161.348 179.352 160.933C179.766 160.519 179.999 159.957 180 159.371V63.371C179.999 62.7849 179.766 62.2231 179.352 61.8086C178.937 61.3942 178.376 61.1611 177.789 61.1605ZM179.368 159.371C179.368 159.79 179.202 160.191 178.906 160.487C178.61 160.783 178.208 160.95 177.789 160.95H2.21053C1.79181 160.95 1.3903 160.783 1.09423 160.487C0.798155 160.191 0.631746 159.79 0.631579 159.371V63.371C0.632152 62.9627 0.790535 62.5704 1.07361 62.2761C1.35669 61.9819 1.74256 61.8084 2.15054 61.7921L39.4737 77.2784L90.4043 98.411C90.9556 98.6353 91.5734 98.6319 92.1222 98.4015L141.474 77.3257L177.853 61.7921C178.26 61.8096 178.645 61.9836 178.927 62.2777C179.209 62.5717 179.367 62.9633 179.368 63.371V159.371Z" fill="#3F3D56" />
								<path d="M109.564 39.4021C109.32 39.1578 108.913 39.1578 108.658 39.4021L87.9714 60.0891L88.8771 60.9947L109.564 40.3077C109.808 40.0533 109.808 39.6463 109.564 39.4021ZM90.6476 52.8847C90.4034 52.6405 89.9964 52.6405 89.742 52.8847L85.2546 57.3722L86.1602 58.2778L90.6476 53.7904C90.8918 53.5461 90.8918 53.1391 90.6476 52.8847ZM116.3 25.6345C118.254 25.6345 120.096 26.4282 121.439 27.8731C124.034 30.6612 123.79 35.0673 121.093 37.7536L108.882 49.9643C108.638 50.2085 108.638 50.6156 108.882 50.87C109.127 51.1142 109.534 51.1142 109.788 50.87L121.978 38.6796C125.204 35.4539 125.377 30.01 122.151 26.7945C120.533 25.1766 118.417 24.3727 116.3 24.3727C114.184 24.3727 112.057 25.1766 110.439 26.7945L82.558 54.6756L83.4637 55.5813L111.345 27.7001C112.668 26.3671 114.428 25.6345 116.3 25.6345ZM92.4691 40.2466C92.2248 40.0024 91.8178 40.0024 91.5634 40.2466L79.8513 51.9689L80.7569 52.8746L92.4792 41.1523C92.7235 40.908 92.7235 40.501 92.4691 40.2466ZM95.5828 38.0385L108.638 24.9832C110.683 22.9379 113.4 21.8084 116.3 21.8084C118.498 21.8084 120.584 22.4699 122.355 23.6706C122.609 23.8436 122.955 23.8232 123.169 23.5993C123.454 23.3144 123.403 22.8362 123.067 22.6123C121.032 21.2284 118.661 20.5263 116.3 20.5263C113.207 20.5263 110.103 21.7067 107.743 24.0674L94.6772 37.1431C94.433 37.3873 94.433 37.7943 94.6772 38.0487C94.9316 38.2929 95.3386 38.2929 95.5828 38.0385ZM106.674 53.0781C106.43 52.8338 106.023 52.8338 105.769 53.0781L96.0611 62.7856C95.8168 63.0298 95.8168 63.4368 96.0611 63.6912C96.3053 63.9354 96.7123 63.9354 96.9565 63.6912L106.664 53.9837C106.918 53.7293 106.918 53.3325 106.674 53.0781ZM121.276 42.9737L96.0712 68.1888L96.9769 69.0843L122.192 43.8691C122.436 43.6249 122.436 43.2179 122.192 42.9635C121.927 42.7295 121.531 42.7295 121.276 42.9737ZM126.364 25.9397C126.14 25.6039 125.662 25.5429 125.377 25.8278C125.163 26.0415 125.133 26.3875 125.306 26.6419C126.486 28.4022 127.127 30.4679 127.127 32.6455C127.127 35.3318 126.16 37.8655 124.38 39.8498C124.146 40.1042 124.146 40.4908 124.39 40.7351C124.644 40.9895 125.072 40.9895 125.306 40.7249C129.04 36.5732 129.386 30.4679 126.364 25.9397ZM112.668 37.194L116.585 33.2763C116.829 33.0321 116.829 32.6251 116.585 32.3707C116.341 32.1265 115.934 32.1265 115.68 32.3707L111.777 36.2731C111.554 36.4959 111.518 36.8917 111.718 37.1349C111.968 37.4371 112.409 37.4524 112.668 37.194ZM119.363 29.4096C118.498 28.5956 117.399 28.1784 116.29 28.1784C115.181 28.1784 114.011 28.6159 113.136 29.4808L92.8557 49.7812C92.6115 50.0254 92.6115 50.4324 92.8557 50.6868C93.1 50.931 93.507 50.931 93.7614 50.6868L113.95 30.4781C114.469 29.9591 115.14 29.5724 115.873 29.4808C116.87 29.3587 117.837 29.6844 118.539 30.3865C119.139 30.9868 119.475 31.7907 119.475 32.6353C119.475 33.4799 119.139 34.2837 118.539 34.8841L90.6578 62.7652L91.5634 63.6607L119.312 35.9118C121.093 34.1514 121.185 31.1496 119.363 29.4096Z" fill="#009FFF" />
								<path d="M63.3974 52.3149C63.1532 52.5591 63.1532 52.956 63.3974 53.2002L75.8187 65.6215C76.0283 65.8312 76.3591 65.883 76.6084 65.7233C76.9574 65.4984 76.994 65.0263 76.7183 64.7495L64.2837 52.3149C64.0394 52.0707 63.6426 52.0707 63.3984 52.3149H63.3974ZM76.9513 77.3672C77.1955 77.6114 77.5923 77.6114 77.8365 77.3672C78.0808 77.123 78.0808 76.7262 77.8365 76.482L64.4149 63.0502C64.1707 62.8059 63.7739 62.8059 63.5297 63.0502C63.2854 63.2944 63.2854 63.6912 63.5297 63.9354L76.9513 77.3672ZM96.9972 69.0538L77.5008 49.5573L72.1077 44.1642C69.7775 41.8442 66.735 40.674 63.6925 40.674C60.65 40.674 57.5973 41.834 55.2772 44.1642C50.627 48.8145 50.627 56.3546 55.2772 60.9947L70.2354 75.9528L77.0123 82.7298C77.2565 82.974 77.6534 82.974 77.8976 82.7298C77.8976 82.7298 77.8976 82.7196 77.9078 82.7196C77.918 82.7196 77.918 82.7196 77.9281 82.7094L79.4443 81.1933L79.5766 84.9175C79.5766 85.0091 79.5969 85.0905 79.6376 85.1719C79.6682 85.2533 79.7089 85.3347 79.7801 85.3958C80.0243 85.64 80.4212 85.64 80.6654 85.3958L80.6959 85.3653C80.7061 85.3551 80.7162 85.3449 80.7264 85.3347L96.8446 69.2166L96.9972 69.0538ZM88.1241 76.1563L79.8238 67.8561C79.6142 67.6465 79.2835 67.5946 79.0342 67.7543C78.6852 67.9792 78.6486 68.4514 78.9243 68.7281L87.2378 77.0416L85.4774 78.802L61.4732 54.7977C60.883 54.2076 60.5574 53.424 60.5574 52.5795C60.5574 51.7349 60.883 50.9615 61.4732 50.3612C62.0633 49.771 62.8469 49.4454 63.6914 49.4454C64.536 49.4454 65.3094 49.771 65.9097 50.3612L89.914 74.3756L88.1231 76.1563H88.1241ZM93.4561 70.8243L90.2844 67.6526C90.0747 67.443 89.744 67.3911 89.4947 67.5508C89.1457 67.7757 89.1091 68.2479 89.3848 68.5246L92.5698 71.7096L90.7993 73.4802L66.7848 49.4759C65.9301 48.6212 64.8108 48.1938 63.6813 48.1938C62.5518 48.1938 61.4325 48.6212 60.5777 49.4759C58.8682 51.1854 58.8682 53.9633 60.5777 55.683L84.582 79.6873L80.8272 83.4421L80.6949 79.6262C80.6847 79.3617 80.5219 79.1276 80.2777 79.036C80.0335 78.9445 79.7587 78.9953 79.5654 79.1887L77.398 81.3561L72.0558 76.0139L56.1513 60.1094C54.1366 58.0946 53.0274 55.4185 53.0274 52.5795C53.0274 49.7405 54.1762 46.9686 56.2612 44.9417C58.2292 43.0276 60.8769 41.9409 63.6212 41.9256C66.4928 41.9103 69.1924 43.0205 71.2112 45.0495L76.0039 49.8422L95.2155 69.0538L93.4551 70.8243H93.4561ZM57.6176 49.3334C57.7499 49.0892 57.7194 48.784 57.5159 48.5805C57.2208 48.2854 56.712 48.3566 56.5085 48.7331C54.86 51.8163 55.3281 55.7339 57.9229 58.3389L60.4129 60.8288C60.6225 61.0384 60.9532 61.0903 61.2025 60.9306C61.5515 60.7057 61.5881 60.2336 61.3124 59.9568L58.8092 57.4536C56.6214 55.2556 56.2246 51.9384 57.6186 49.3334H57.6176ZM63.6823 44.439C62.3696 44.439 61.0672 44.7544 59.8868 45.3751C59.5103 45.5685 59.4289 46.0773 59.7342 46.3825C59.9377 46.586 60.2328 46.6166 60.4871 46.4843C61.524 45.9328 62.6881 45.658 63.9041 45.6936C65.691 45.7465 67.3801 46.5189 68.6439 47.7827L86.2782 65.417C86.4879 65.6266 86.8186 65.6785 87.0679 65.5188C87.4169 65.2939 87.4535 64.8217 87.1778 64.545L69.4519 46.8191C67.8543 45.2317 65.7683 44.438 63.6823 44.438V44.439Z" fill="#009FFF" />
							</g>
							<defs>
								<clipPath id="clip0_5_14">
									<rect width="180" height="161.582" fill="white" />
								</clipPath>
							</defs>
						</svg>
						<p className='cmplz-h2'>{__("Thanks for joining us!", "complianz-gdpr")}</p>
						{enableWsc &&
							<p>{__("We've sent you an email - all you need to do is confirm your email address and you can start using Complianz.", "complianz-gdpr")}</p>
						}
					</>
				}
			</div>
		</div>

	);
};

export default ThankYou;
