<?php
/**
 * For each activate consenttype a banner is created
 * If A/B testing is enabled, each banner is rendered per consenttype as well.
 */
?>
<div class="cmplz-cookiebanner cmplz-hidden banner-{id} {consent_type}" data-nosnippet="true" role="dialog" aria-live="polite" aria-label="cookiebanner" aria-describedby="cookiebanner:desc">
	<div class="cmplz-header">
		<div class="cmplz-logo">{logo}</div>
		<h1 class="cmplz-title">{header}</h1>
		<a class="cmplz-close dashicons dashicons-no-alt" tabindex="0" role="button"></a>
	</div>
	<div class="cmplz-body">
		<div class="cmplz-message">{message_{consent_type}}</div>
		<!-- categories start -->
		<div class="cmplz-categories">
			<details class="cmplz-category cmplz-functional">
				<summary>
					<div class="cmplz-category-header">
						<h2 >{category_functional}</h2>
						<input
							id="cmplz-functional"
							data-category="cmplz_functional"
							class="cmplz-consent-checkbox cmplz-slider-checkbox cmplz-functional"
							checked
							type="hidden"
							value="1"/>
						<div class='cmplz-always-active'><?php _e("Always active","complianz-gdpr")?></div>
						<div class="cmplz-icon cmplz-open"></div>
					</div>
				</summary>
				<div class="cmplz-body cmplz-description">
					<span class="cmplz-description-functional">{functional_text}</span>
				</div>
			</details>

			<details class="cmplz-category cmplz-preferences">
				<summary>
					<div class="cmplz-category-header">
						<h2>{category_preferences}</h2>
						<div class="cmplz-active">
							<label for="cmplz-preferences">
								<div class="cmplz-banner-checkbox">
									<input
										id="cmplz-preferences"
										data-category="cmplz_preferences"
										class="cmplz-consent-checkbox cmplz-slider-checkbox cmplz-preferences"
										size="40"
										type="checkbox"
										value="1"/>
									<span class="cmplz-banner-slider cmplz-round"></span>
								</div>
							</label>
						</div>
						<div class="cmplz-icon cmplz-open"></div>
					</div>
				</summary>
				<div class="cmplz-body cmplz-description">
					<span class="cmplz-description-preferences">{preferences_text}</span>
				</div>
			</details>

			<details class="cmplz-category cmplz-statistics">
				<summary>
					<div class="cmplz-category-header">
						<h2>{category_statistics}</h2>
						<div class="cmplz-active">
							<label for="cmplz-statistics">
								<div class="cmplz-banner-checkbox">
									<input
										id="cmplz-statistics"
										data-category="cmplz_statistics"
										class="cmplz-consent-checkbox cmplz-slider-checkbox cmplz-statistics"
										size="40"
										type="checkbox"
										value="1"/>
									<span class="cmplz-banner-slider cmplz-round"></span>
								</div>
							</label>
						</div>
						<div class="cmplz-icon cmplz-open"></div>
					</div>
				</summary>
				<div class="cmplz-body cmplz-description">
					<span class="cmplz-description-statistics">{statistics_text}</span>
					<span class="cmplz-description-statistics-anonymous cmplz-hidden">{statistics_text_anonymous}</span>
				</div>
			</details>

			<details class="cmplz-category cmplz-marketing">
				<summary>
					<div class="cmplz-category-header">
						<h2>{category_marketing}</h2>
						<div class="cmplz-active">
							<label for="cmplz-marketing">
								<div class="cmplz-banner-checkbox">
									<input
										id="cmplz-marketing"
										data-category="cmplz_marketing"
										class="cmplz-consent-checkbox cmplz-slider-checkbox cmplz-marketing"
										size="40"
										type="checkbox"
										value="1"/>
									<span class="cmplz-banner-slider cmplz-round"></span>
								</div>
							</label>
						</div>
						<div class="cmplz-icon cmplz-open"></div>
					</div>
				</summary>
				<div class="cmplz-body cmplz-description">
					<span class="cmplz-description-marketing">{marketing_text}</span>
				</div>
			</details>
		</div><!-- categories end -->
		<?php do_action('cmplz_banner_after_categories' ) ?>

		<div class="cmplz-links cmplz-information">
			<a class="cmplz-link cmplz-manage-options cookie-statement" href="{url}#cmplz-manage-consent-container"><?php _e("Manage options","complianz-gdpr")?></a>
			<a class="cmplz-link cmplz-manage-third-parties cookie-statement" href="{url}#cmplz-manage-consent-container"><?php _e("Manage third parties","complianz-gdpr")?></a>
			<a class="cmplz-link cmplz-manage-vendors tcf cookie-statement" href="{url}#cmplz-manage-consent-container"><?php _e("Manage vendors","complianz-gdpr")?></a>
			<a class="cmplz-link cmplz-external cmplz-read-more-purposes tcf" target="_blank" rel="noopener noreferrer nofollow" href="https://cookiedatabase.org/tcf/purposes/"><?php _e("Read more about these purposes","complianz-gdpr")?></a>
			<?php do_action("cmplz_after_links")?>
		</div>
	</div>
	<div class="cmplz-footer">
		<div class="cmplz-buttons">
			<button class="cmplz-btn cmplz-accept">{accept_{consent_type}}</button>
			<button class="cmplz-btn cmplz-deny">{dismiss}</button>
			<button class="cmplz-btn cmplz-view-preferences">{manage_options}</button>
			<button class="cmplz-btn cmplz-save-preferences">{save_settings}</button>
			<a class="cmplz-btn cmplz-manage-tcf-options tcf cookie-statement" href="{url}#cmplz-manage-consent-container">{manage_options}</a>
			<?php do_action("cmplz_after_buttons")?>
		</div>

		<div class="cmplz-links cmplz-documents">
			<a class="cmplz-link cookie-statement" href="{url}">{title}</a>
			<a class="cmplz-link privacy-statement" href="{url}">{title}</a>
			<a class="cmplz-link impressum" href="{url}">{title}</a>
			<?php do_action("cmplz_after_documents")?>
		</div>
	</div>
</div>


