<?php

defined('ABSPATH') or die("you do not have acces to this page!");

if (!class_exists("cmplz_document_pro")) {
    class cmplz_document_pro extends cmplz_document
    {
        private static $_this;


        function __construct()
        {
            if (isset(self::$_this))
	            wp_die(sprintf('%s is a singleton class and you cannot create a second instance.', get_class($this)));

            self::$_this = $this;

            $this->init();

            //add_action('admin_init', array($this, 'add_privacy_policy_to_wp_page'));
            add_filter('wp_get_default_privacy_policy_content', array($this, 'remove_default_wp_content'));

            add_action('cmplz_wp_privacy_policies', array($this, 'wp_privacy_policies'));

            add_action('cmplz_create_page', array($this, 'set_wp_privacy_policy'),10,3);

        }

        static function this()
        {
            return self::$_this;
        }


        public function get_permalink($type, $region, $auto_redirect_region=false)
        {
            $url = "#";
            $page_id = $this->get_shortcode_page_id($type, $region);
            if ($page_id) {
                $url = get_permalink($page_id);
            }

            if ($auto_redirect_region){
                $url = $url.'?cmplz_region_redirect=true';
            }

            return $url;
        }

        public function wp_privacy_policies()
        {
            global $wp_version;
            if (version_compare($wp_version, '4.9.6', '<')) {
                cmplz_notice(__('As of WordPress 4.9.6, plugins and themes can add their own suggested statements about cookie usage and privacy here. To use this functionality, please upgrade to the latest WordPress version.', 'complianz-gdpr') ,'warning');
                return;
            }

            cmplz_notice(__('Please note that you should customize these texts for your website: the text should generally not be copied as is.', 'complianz-gdpr'), 'warning');

            if ( ! class_exists( 'WP_Privacy_Policy_Content' ) ) {
                require_once( ABSPATH . 'wp-admin/includes/misc.php' );
            }

            $data = $this->get_wp_privacy_policy_data();

            $found_policy = false;
            foreach ($data as $policy) {
                if (isset($policy['removed'])) continue;
                if ($policy['plugin_name'] == 'Complianz') continue;
                $found_policy = true;
                $s_plugin_name = sanitize_text_field(str_replace(array('<h3>', '</h3>'), array('<h4>','</h4>'),$policy['plugin_name']));
                $add_btn = '&nbsp;&nbsp;<span class="cmplz-add-to-policy" style="float:right"><i class="fa fa-plus"></i>'.sprintf(__('Add to Privacy Statement', 'complianz-gdpr'), $s_plugin_name).'</span>';

                cmplz_panel($s_plugin_name, $policy['policy_text'], $add_btn);

            }

            if (cmplz_get_value('privacy-statement')!=='generated'){
                cmplz_notice(__("You did not choose to create a privacy statement through Complianz Privacy Suite, so you can skip this step.", 'complianz-gdpr'), 'warning');
            }

            if (!$found_policy) {
                cmplz_notice(__('No plugins with suggested statements found.', 'complianz-gdpr'),'warning');
            }

        }

        public function remove_default_wp_content($content)
        {
            $update_policy_data = false;
            $policy_page_id = (int)get_option('wp_page_for_privacy_policy');
            $checked = get_post_meta($policy_page_id, '_wp_suggested_privacy_policy_content');
            if ($checked) {
                foreach ($checked as $key => $data) {
                    if ($data['plugin_name'] == 'WordPress') {
                        $update_policy_data = true;
                        unset($checked[$key]);
                    }
                }
            }

            if ($update_policy_data) {
                delete_post_meta($policy_page_id, '_wp_suggested_privacy_policy_content');
                foreach ($checked as $data) {
                    add_post_meta($policy_page_id, '_wp_suggested_privacy_policy_content', $data);
                }
            }

            return '';
        }

        public function get_wp_privacy_policy_data()
        {
            if ( ! class_exists( 'WP_Privacy_Policy_Content' ) ) {
                require_once( ABSPATH . 'wp-admin/includes/misc.php' );
            }

            $data = WP_Privacy_Policy_Content::get_suggested_policy_text();

            return $data;
        }



    }
} //class closure
