<?php
defined( 'ABSPATH' ) or die( "you do not have acces to this page!" );

/*
 * condition: if a question should be dynamically shown or hidden, depending on another answer. Use NOT answer to hide if not answer.
 * callback_condition: if should be shown or hidden based on an answer in another screen.
 * callback roept action cmplz_$page_$callback aan
 * required: verplicht veld.
 * help: helptext die achter het veld getoond wordt.


                "fieldname" => '',
                "type" => 'text',
                "required" => false,
                'default' => '',
                'label' => '',
                'table' => false,
                'callback_condition' => false,
                'condition' => false,
                'callback' => false,
                'placeholder' => '',
                'optional' => false,

* */

// MY COMPANY SECTION
$this->fields = $this->fields + array(

		'regions'                     => array(
			'step'     => STEP_COMPANY,
			'section'  => 1,
			'source'   => 'wizard',
			'default'  => '',
			'type'     => 'radio',
			'revoke_consent_onchange' => true,
			'options'  => array(
				'eu' => __( 'GDPR (European Union)',
					'complianz-gdpr' ),
				'uk' => __( 'UK-GDPR, PECR, Data Protection Act (United Kingdom)',
					'complianz-gdpr' ),
				'us' => __( 'CCPA / United States', 'complianz-gdpr' ),
				'ca' => __( 'PIPEDA (Canada)', 'complianz-gdpr' ),
			),
			'label'    => __( "Which privacy law or guideline do you want to use as the default for your worldwide visitors?",
				'complianz-gdpr' ),
			'help'     => __( "You don’t need to configure your website for ‘accidental’ visitors. Only choose the regions your website is intended for.",
				'complianz-gdpr' ),
			'comment'  => __( "The plugin will apply the above-selected region's settings to all visitors worldwide.",
					'complianz-gdpr' ) . " "
			              . sprintf( __( "If you want to dynamically apply privacy laws based on the visitor's location, consider upgrading to the %spremium version%s, which allows you to apply a privacy law specific for that region.",
					'complianz-gdpr' ),
					'<a href="https://complianz.io" target="_blank">', '</a>' ),
			'required' => true,
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'eu_consent_regions' => array(
			'step'      => STEP_COMPANY,
			'section'   => 1,
			'source'    => 'wizard',
			'default'   => 'no',
			'type'      => 'radio',
			'options'   => $this->yes_no,
			'condition' => array( 'regions' => 'eu' ),
			'label'     => __( "Do you target visitors from Germany and/or Austria?",
				'complianz-gdpr' ),
			'required'  => true,
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'california' => array(
			'step'      => STEP_COMPANY,
			'section'   => 1,
			'source'    => 'wizard',
			'default'   => 'yes',
			'type'      => 'radio',
			'options'   => $this->yes_no,
			'condition' => array( 'regions' => 'us' ),
			'label'     => __( "Do you target visitors from California?",
				'complianz-gdpr' ),
			'help'      => __( "There are some rules which only apply to California.",
				'complianz-gdpr' ),
			'required'  => true,
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'cookie-statement' => array(
			'step'     => STEP_COMPANY,
			'section'  => 2,
			'source'   => 'wizard',
			'default'  => 'generated',
			'type'     => 'document',
			'label'    => __( "Cookie Policy", 'complianz-gdpr' ),
			'required' => true,
			'help'     => __( 'A Cookie Policy is required to inform your visitors about the way cookies and similar techniques are used on your website. A link to this document is placed on your cookie banner.',
				"complianz-gdpr" ),
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'impressum' => array(
			'step'     => STEP_COMPANY,
			'section'  => 2,
			'disabled' => true,
			'source'   => 'wizard',
			'default'  => 'none',
			'type'     => 'document',
			'label'    => __( "Impressum", 'complianz-gdpr' ),
			'required' => true,
			'help'     => __( 'Complianz will generate the Impressum based on the answers in the wizard, but you can also create your own, custom document.',
				"complianz-gdpr" ),
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
			'callback_condition' => array('eu_consent_regions' => 'yes'),
		),

		'privacy-statement' => array(
			'step'     => STEP_COMPANY,
			'section'  => 2,
			'disabled' => true,
			'source'   => 'wizard',
			'type'     => 'document',
			'default'  => 'custom',
			'label'    => __( "Privacy Statement", 'complianz-gdpr' ),
			'options'  => $this->yes_no,
			'required' => false,
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'disclaimer' => array(
			'step'     => STEP_COMPANY,
			'section'  => 2,
			'source'   => 'wizard',
			'default'  => 'none',
			'disabled' => true,
			'type'     => 'document',
			'options'  => $this->yes_no,
			'label'    => __( "Disclaimer",
				'complianz-gdpr' ),
			'required' => false,
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'organisation_name' => array(
			'step'     => STEP_COMPANY,
			'section'  => 3,
			'source'   => 'wizard',
			'type'     => 'text',
			'default'  => '',
			'label'    => __( "Who is the owner of the website (person or company)?",
				'complianz-gdpr' ),
			'required' => true,
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'address_company' => array(
			'step'        => STEP_COMPANY,
			'section'     => 3,
			'source'      => 'wizard',
			'placeholder' => __( 'Address, City and Zipcode',
				'complianz-gdpr' ),
			'type'        => 'textarea',
			'default'     => '',
			'label'       => __( "What is your address?", 'complianz-gdpr' ),
			'required'    => true,
			'time'        => CMPLZ_MINUTES_PER_QUESTION,
		),

		'country_company'   => array(
			'step'     => STEP_COMPANY,
			'section'  => 3,
			'source'   => 'wizard',
			'type'     => 'select',
			'options'  => $this->countries,
			'default'  => 'NL',
			'label'    => __( "What is your country?", 'complianz-gdpr' ),
			'required' => true,
			'help'     => __( "This setting is automatically selected based on your WordPress language setting.",
				'complianz-gdpr' ),
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'email_company'     => array(
			'step'     => STEP_COMPANY,
			'section'  => 3,
			'source'   => 'wizard',
			'type'     => 'email',
			'default'  => '',
			'help'     => __( "The email address will be obfuscated on the front-end to prevent spidering.",
				'complianz-gdpr' ),
			'label'    => __( "What is the email address your visitors can use to contact you about privacy issues?",
				'complianz-gdpr' ),
			'required' => true,
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'telephone_company' => array(
			'step'           => STEP_COMPANY,
			'section'        => 3,
			'source'         => 'wizard',
			'type'           => 'phone',
			'default'        => '',
			'document_label' => __( 'Phone number', 'complianz-gdpr' ) . ': ',
			'label'          => __( "What is the telephone number your visitors can use to contact you about privacy issues?",
				'complianz-gdpr' ),
			'required'       => false,
			'time'           => CMPLZ_MINUTES_PER_QUESTION,
		),

		'wp_admin_access_users' => array(
			'step'     => STEP_COMPANY,
			'section'  => 3,
			'source'   => 'wizard',
			'type'     => 'radio',
			'default'  => 'no',
			'label'    => __( "Does your site have users with access to the wp-admin part of the website?",
				'complianz-gdpr' ),
			'help'     => __( "If so, the scan will be extended to the wp-admin part of your site. ",
				'complianz-gdpr' ),
			'required' => false,
			'options'  => $this->yes_no,
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		// Purpose
		'purpose_personaldata' => array(
			'step'               => STEP_COMPANY,
			'section'            => 6,
			'source'             => 'wizard',
			'type'               => 'multicheckbox',
			'default'            => '',
			'label'              => __( "Indicate for what purpose personal data is processed via your website:",
				'complianz-gdpr' ),
			'help'               => __( "Also consider future purposes. Regarding personalized products: these are products and/or services which are personalized based on visitor's behavior. E.g. advertisements based on pages visited.",
				'complianz-gdpr' ),
			'required'           => true,
			'options'            => $this->purposes,
			'callback_condition' => array(
				'regions' => array( 'us' )
			),
			'time'               => CMPLZ_MINUTES_PER_QUESTION,
		),
	);

$this->fields = $this->fields + array(
		// Cookie policy
		'cookie_scan' => array(
			'step'     => STEP_COOKIES,
			'section'  => 1,
			'source'   => 'wizard',
			'type'     => 'radio',
			'options'  => $this->yes_no,
			'label'    => __( "Cookie scan", 'complianz-gdpr' ),
			'callback' => 'cookie_scan',
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'compile_statistics' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 2,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'label'                   => __( "Do you compile statistics of this website?",
				'complianz-gdpr' ),
			'options'                 => array(
				'yes-anonymous'      => __( 'Yes, anonymous',
					'complianz-gdpr' ),
				'yes'                => __( 'Yes, and the personal data is available to us',
					'complianz-gdpr' ),
				'google-analytics'   => __( 'Yes, with Google Analytics',
					'complianz-gdpr' ),
				'matomo'             => __( 'Yes, with Matomo',
					'complianz-gdpr' ),
				'google-tag-manager' => __( 'Yes, with Google Tag Manager',
					'complianz-gdpr' ),
				'no'                 => __( 'No', 'complianz-gdpr' )
			),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'compile_statistics_more_info' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 2,
			'source'                  => 'wizard',
			'type'                    => 'multicheckbox',
			'revoke_consent_onchange' => true,
			'default'                 => '',
			'label'                   => __( "Regarding the previous question, can you give more information?",
				'complianz-gdpr' ),
			'options'                 => array(
				'accepted'             => __( 'I have accepted the Google data processing amendment',
					'complianz-gdpr' ),
				'no-sharing'           => __( 'Google is not allowed to use this data for other Google services',
					'complianz-gdpr' ),
				'ip-addresses-blocked' => __( 'Always block acquiring of IP addresses',
					'complianz-gdpr' ),
			),
			'help'                    => __( 'If you do not check to always block acquiring IP addresses, the IP addresses will get acquired as soon as the user accepts statistics or higher.',
					'complianz-gdpr' ) . "<br>"
			                             . __( 'If you can check all three options, you might not need a cookie banner on your site.',
					'complianz-gdpr' )
			                             . cmplz_read_more( 'https://complianz.io/how-to-configure-google-analytics-for-gdpr/' ),
			'condition'               => array(
				'compile_statistics' => 'google-analytics',
			),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'compile_statistics_more_info_tag_manager' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 2,
			'source'                  => 'wizard',
			'type'                    => 'multicheckbox',
			'revoke_consent_onchange' => true,
			'default'                 => '',
			'label'                   => __( "Regarding the previous question, can you give more information?",
				'complianz-gdpr' ),
			'options'                 => array(
				'accepted'             => __( 'I have accepted the Google data processing amendment',
					'complianz-gdpr' ),
				'no-sharing'           => __( 'Google is not allowed to use this data for other Google services',
					'complianz-gdpr' ),
				'ip-addresses-blocked' => __( 'Acquiring IP-addresses is blocked',
					'complianz-gdpr' ),
			),
			'help'                    => __( 'With Tag Manager you can configure the selective firing of cookies in the Tag Manager dashboard.',
					'complianz-gdpr' )
			                             . cmplz_read_more( 'https://complianz.io/how-to-configure-tag-manager-for-gdpr/' ),
			'condition'               => array(
				'compile_statistics' => 'google-tag-manager',
			),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'fire_scripts_in_tagmanager' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 2,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'condition'               => array(
				'compile_statistics' => 'google-tag-manager',
			),
			'label'                   => __( "Tag Manager fires scripts which place cookies",
				'complianz-gdpr' ),
			'help'                    => __( 'If you use Tag Manager to fire scripts on your site, Complianz will automatically enable categories.',
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'matomo_anonymized' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 2,
			'source'                  => 'wizard',
			'type'                    => 'select',
			'revoke_consent_onchange' => true,
			'default'                 => '',
			'label'                   => __( "Do you anonymize IP addresses in Matomo?",
				'complianz-gdpr' ),
			'options'                 => $this->yes_no,
			'help'                    => __( 'If ip numbers are anonymized, the statistics cookie do not require a cookie banner',
				'complianz-gdpr' ),
			'condition'               => array(
				'compile_statistics' => 'matomo',
			),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'consent_for_anonymous_stats' => array(
			'step'               => STEP_COOKIES,
			'section'            => 3,
			'source'             => 'wizard',
			'type'               => 'select',
			'default'            => 'yes',
			'label'              => __( "Do you want to ask consent for statistics?",
				'complianz-gdpr' ),
			'options'            => $this->yes_no,
			'callback_condition' => 'cmplz_consent_required_for_anonymous_stats',
			'time'               => CMPLZ_MINUTES_PER_QUESTION,
		),

		'configuration_by_complianz' => array(
			'step'               => STEP_COOKIES,
			'section'            => 3,
			'source'             => 'wizard',
			'type'               => 'select',
			'default'            => 'yes',
			'label'              => __( "Do you want Complianz to configure your statistics?",
				'complianz-gdpr' ),
			'options'            => $this->yes_no,
			'help'               => __( "It's recommended to let Complianz handle the statistics script. This way, the plugin can detect if it needs to be hooked into the cookie consent code or not. But if you have set it up yourself and don't want to change this, you can choose to do so",
				'complianz-gdpr' ),
			'callback_condition' => 'cmplz_manual_stats_config_possible',
			'time'               => CMPLZ_MINUTES_PER_QUESTION,
		),

		'GTM_code' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 3,
			'source'                  => 'wizard',
			'type'                    => 'text',
			'default'                 => '',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'label'                   => __( "Enter your Google Tag Manager code",
				'complianz-gdpr' ),
			'callback_condition'      => array( 'compile_statistics' => 'google-tag-manager' ),
			'condition'               => array( 'configuration_by_complianz' => 'yes' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'help'                    => __( "For the Google Tag Manager code, log on. Then, you will immediatly see Container codes. The one next to your website name is the code you will need to fill in here, the Container ID.",
				'complianz-gdpr' ),
		),

		'UA_code' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 3,
			'source'                  => 'wizard',
			'type'                    => 'text',
			'default'                 => '',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'label'                   => __( "Enter your Analytics UA code",
				'complianz-gdpr' ),
			'callback_condition'      => array( 'compile_statistics' => 'google-analytics' ),
			'condition'               => array( 'configuration_by_complianz' => 'yes' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'help'                    => __( "For the Google Analytics UA code, log on and click Admin and copy the UA code below Tracking-ID.",
				'complianz-gdpr' ),
		),

		'matomo_site_id' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 3,
			'source'                  => 'wizard',
			'type'                    => 'number',
			'default'                 => '',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'label'                   => __( "Enter your Matomo site ID",
				'complianz-gdpr' ),
			'condition'               => array( 'configuration_by_complianz' => 'yes' ),
			'callback_condition'      => array( 'compile_statistics' => 'matomo' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'matomo_url' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 3,
			'source'                  => 'wizard',
			'type'                    => 'url',
			'placeholder'             => 'https://domain.com/stats',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'label'                   => __( "Enter the URL of Matomo",
				'complianz-gdpr' ),
			'callback_condition'      => array( 'compile_statistics' => 'matomo' ),
			'condition'               => array( 'configuration_by_complianz' => 'yes' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'help'                    => __( "e.g. https://domain.com/stats",
				'complianz-gdpr' ),
		),

		'uses_cookies' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'label'                   => __( "This website uses cookies or similiar techniques.",
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'use_cdb_api' => array(
			'step'      => STEP_COOKIES,
			'section'   => 4,
			'source'    => 'wizard',
			'type'      => 'radio',
			'required'  => true,
			'default'   => '',
			'options'   => $this->yes_no,
			'condition' => array( 'uses_cookies' => 'yes' ),
			'label'     => __( "Do you consent to the use of the cookiedatabase.org API?",
				'complianz-gdpr' ),
			'comment'   => __( "Without the API, you will have to manually describe all found cookies, their purpose, function, service and service types",
				'complianz-gdpr' ),
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'use_cdb_links' => array(
			'step'      => STEP_COOKIES,
			'section'   => 4,
			'source'    => 'wizard',
			'type'      => 'radio',
			'required'  => false,
			'default'   => '',
			'options'   => $this->yes_no,
			'condition' => array( 'use_cdb_api' => 'yes' ),
			'label'     => __( "Do you want to hyperlink cookie names so visitors can find more information on Cookiedatabase.org? These links will be added with HTML attributes so it won't hurt SEO.",
				'complianz-gdpr' ),
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'uses_thirdparty_services' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => '',
			'label'                   => __( "Does your website use third-party services?",
				'complianz-gdpr' ),
			'help'                    => __( "e.g. services like Google Fonts, Maps or recaptcha usually place cookies.",
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'thirdparty_services_on_site' => array(
			'step'      => STEP_COOKIES,
			'section'   => 4,
			'source'    => 'wizard',
			'type'      => 'multicheckbox',
			'options'   => $this->thirdparty_services,
			'default'   => '',
			'condition' => array( 'uses_thirdparty_services' => 'yes' ),
			'label'     => __( "Select the types of third-party services you use on your site.",
				'complianz-gdpr' ),
			'help'      => __( "Checking services here will add the associated cookies to your Cookie Policy, and block the service until consent is given (opt-in), or after consent is revoked (opt-out).",
				'complianz-gdpr' ),
			'comment'   => __( "You can disable services and placeholders under Integrations.",
					'complianz-gdpr' ),
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'block_recaptcha_service' => array(
			'step'      => STEP_COOKIES,
			'section'   => 4,
			'source'    => 'wizard',
			'type'      => 'radio',
			'options'   => $this->yes_no,
			'default'   => 'no',
			'condition' => array( 'thirdparty_services_on_site' => 'google-recaptcha' ),
			'label'     => __( "Do you want to block reCAPTCHA before consent, and when consent is revoked?",
				'complianz-gdpr' ),
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'hotjar_privacyfriendly' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => '',
			'label'                   => __( "Is Hotjar configured in a privacy-friendly way?",
				'complianz-gdpr' ),
			'help'                    => __( "You can configure Hotjar privacy-friendly, if you do this, no consent is required for Hotjar.",
					'complianz-gdpr' )
			                             . cmplz_read_more( 'https://complianz.io/configuring-hotjar-for-gdpr/' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'condition'               => array( 'thirdparty_services_on_site' => 'hotjar' ),
			'callback_condition'      => array( 'consent_for_anonymous_stats' => 'NOT yes' ),
		),

		'uses_social_media' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => '',
			'label'                   => __( "Does your website contain embedded social media content, like buttons, timelines, videos or pixels?",
				'complianz-gdpr' ),
			'help'                    => __( "Content from social media is mostly embedded through iFrames. These often place third party (tracking) cookies, so must be blocked based on visitor consent. If your website only contains buttons or links to a social media profile on an external page you can answer No.",
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'socialmedia_on_site' => array(
			'step'      => STEP_COOKIES,
			'section'   => 4,
			'source'    => 'wizard',
			'type'      => 'multicheckbox',
			'options'   => $this->thirdparty_socialmedia,
			'condition' => array( 'uses_social_media' => 'yes' ),
			'default'   => '',
			'label'     => __( "Select which social media are used on the website.",
				'complianz-gdpr' ),
			'help'      => __( "Checking services here will add the associated cookies to your Cookie Policy, and block the service until consent is given (opt-in), or after consent is revoked (opt-out)",
				'complianz-gdpr' ),
			'time'      => CMPLZ_MINUTES_PER_QUESTION,
		),

		'uses_firstparty_marketing_cookies' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => 'no',
			'label'                   => __( "You have stated that you don't use third-party services. Do you use plugins that might set marketing cookies?",
				'complianz-gdpr' ),
			'help'                    => __( "Complianz cannot automatically block first-party marketing cookies unless these plugins conform to the WP Consent API. Look for any possible integrations on our website if you're not sure. When you answer 'No' to this question, the marketing category will be removed.",
					'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'condition'               =>array(
				'uses_thirdparty_services' => 'no',
			),
		),

		'uses_ad_cookies' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => '',
			'label'                   => __( "Does your website use cookies for advertising?",
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
		),

		'uses_ad_cookies_personalized' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => array(
				'yes' => __("Yes", "complianz-gdpr"),
				'no' => __("No", "complianz-gdpr"),
				'tcf' => __("Enable TCF", "complianz-gdpr").' (premium)',
			),
			'default'                 => '',
			'label'                   => __( "Are any of your advertising cookies used to show personalized ads?", 'complianz-gdpr' ),
			'comment'                 => __( "Google recommends an integration with TCF V2.0 to avoid loss of revenue.", 'complianz-gdpr' ).cmplz_read_more("https://complianz.io/tcf-for-wordpress"),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'help'                    => __( "If you only use Google for advertising, and have activated the option to use only non personalized ads, you can select no here.", 'complianz-gdpr' ),
			'condition'               => array(
				'uses_ad_cookies' => 'yes'
			),
			'disabled' => array(
				'tcf'
			)
		),

		'uses_wordpress_comments' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => '',
			'label'                   => __( "Does your website use WordPress comments?",
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'callback_condition'      => array(
				'regions' => array( 'eu', 'uk' ),
				'NOT cmplz_consent_api_active',
			),
		),

		'block_wordpress_comment_cookies' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 4,
			'source'                  => 'wizard',
			'type'                    => 'radio',
			'required'                => true,
			'revoke_consent_onchange' => true,
			'options'                 => $this->yes_no,
			'default'                 => 'yes',
			'label'                   => __( "Do you want to disable the storage of personal data by the WP comments function and the checkbox?",
				'complianz-gdpr' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'help'                    => __( "If you enable this, WordPress will not store personal data with comments and you won't need a consent checkbox for the comment form. The consent box will not be displayed.",
				'complianz-gdpr' ),
			'condition'               => array(
				'uses_wordpress_comments' => 'yes',
			),
			'callback_condition'      => array(
				'regions' => array( 'eu', 'uk' ),
				'NOT cmplz_consent_api_active',
			),
		),

		'no_cookies_used' => array(
			'step'     => STEP_COOKIES,
			'section'  => 5,
			'source'   => 'wizard',
			'type'     => 'callback',
			'callback' => 'notice_no_cookies_used',
			'time'     => 0,
		),

		'cookiedatabase_sync' => array(
			'step'     => STEP_COOKIES,
			'section'  => 5,
			'source'   => 'wizard',
			'label'    => __( "Cookiedatabase sync", 'complianz-gdpr' ),
			'callback' => 'cookiedatabase_sync',
			'time'     => CMPLZ_MINUTES_PER_QUESTION,
		),

		'used_cookies' => array(
			'step'               => STEP_COOKIES,
			'section'            => 5,
			'source'             => 'wizard',
			'translatable'       => true,
			'type'               => 'cookies',
			'default'            => '',
			'label'              => __( "Add the used cookies here",
				'complianz-gdpr' ),
			'callback_condition' => array( 'uses_cookies' => 'yes' ),
			'time'               => 5,
		),

		'used_services' => array(
			'step'               => STEP_COOKIES,
			'section'            => 6,
			'source'             => 'wizard',
			'translatable'       => true,
			'type'               => 'services',
			'default'            => '',
			'label'              => __( "Add the services to which your cookies belong here",
				'complianz-gdpr' ),
			'callback_condition' => array( 'uses_cookies' => 'yes' ),
			'time'               => 5,
		),

		'statistics_script' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 8,
			'source'                  => 'wizard',
			'type'                    => 'javascript',
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'label'                   => __( "Statistics script",
				'complianz-gdpr' ),
			'callback_condition'      => array(
				'compile_statistics' => 'NOT google-analytics,NOT matomo,NOT google-tag-manager,NOT no,NOT yes-anonymous',
			),
			'help'                    => __( 'Paste here all your scripts that activate cookies. Enter the scripts without the script tags',
					'complianz-gdpr' ) . '.&nbsp;'
			                             . sprintf( __( 'To be able to activate cookies when a user accepts the Cookie Policy, the scripts that are used for these cookies need to be entered here, without <script></script> tags. For more information on this, please read %sthis%s article',
					'complianz-gdpr' ),
					'<a target="_blank" href="https://complianz.io/articles/adding-scripts">',
					'</a>' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'table'                   => true,
		),

		'cookie_scripts' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 8,
			'source'                  => 'wizard',
			'type'                    => 'javascript',
			'optional'                => true,
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'label'                   => __( "Scripts to add services, for example, Facebook Pixel, Hotjar, etcetera.",
				'complianz-gdpr' ),
			'callback_condition'      => array(
				'uses_cookies'       => 'yes',
			),
			'help'                    => __( "Paste here all your scripts that activate cookies. Enter the scripts without the script tags",
					'complianz-gdpr' ) . '&nbsp;'
			                             . sprintf( __( 'To be able to activate cookies when a user accepts the Cookie Policy, the scripts that are used for these cookies need to be entered here, without <script></script> tags. For more information on this, please read %sthis%s article',
					'complianz-gdpr' ),
					'<a target="_blank" href="https://complianz.io/articles/adding-scripts/">',
					'</a>' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'table'                   => true,

		),

		'cookie_scripts_async' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 8,
			'source'                  => 'wizard',
			'type'                    => 'javascript',
			'optional'                => true,
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'label'                   => __( "Async scripts to execute on consent",
				'complianz-gdpr' ),
			'callback_condition'      => array(
				'uses_cookies'       => 'yes',
			),
			'help'                    => __( "Paste here all your scripts that activate cookies. Enter the scripts without the script tags",
					'complianz-gdpr' ) . '&nbsp;'
			                             . sprintf( __( 'To be able to activate cookies when a user accepts the Cookie Policy, the scripts that are used for these cookies need to be entered here, without <script></script> tags. For more information on this, please read %sthis%s article',
					'complianz-gdpr' ),
					'<a target="_blank" href="https://complianz.io/articles/adding-scripts/">',
					'</a>' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'table'                   => true,
		),

		'thirdparty_scripts' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 8,
			'source'                  => 'wizard',
			'type'                    => 'textarea',
			'optional'                => true,
			'default'                 => '',
			'revoke_consent_onchange' => true,
			'placeholder'             => 'domain.com, domain.org',
			'label'                   => __( "(part of) URL's or unique string from the inline scripts of third-party scripts & plugins that should be blocked before consent.",
				'complianz-gdpr' ),
			'help'                    => sprintf( __( 'The most common third-party cookies are blocked automatically. If you want to block other third-party cookies, enter the a unique part of the script source, or unique string from the inline script here, comma separated. For more information on this, please read %sthis%s article',
				'complianz-gdpr' ),
				'<a target="_blank" href="https://complianz.io/articles/blocking-custom-third-party-scripts">',
				'</a>' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'table'                   => true,
		),

		'thirdparty_iframes' => array(
			'step'                    => STEP_COOKIES,
			'section'                 => 8,
			'source'                  => 'wizard',
			'type'                    => 'textarea',
			'optional'                => true,
			'default'                 => '',
			'placeholder'             => 'domain.com, domain.org',
			'revoke_consent_onchange' => true,
			'label'                   => __( "URL's from iFrames that should be blocked before consent.",
				'complianz-gdpr' ),
			'help'                    => sprintf( __( 'The most common third-party cookies are blocked automatically. If you want to block other third-party cookies, enter the iframe source here, comma separated. For more information on this, please read %sthis%s article',
				'complianz-gdpr' ),
				'<a target="_blank" href="https://complianz.io/articles/blocking-custom-third-party-scripts">',
				'</a>' ),
			'time'                    => CMPLZ_MINUTES_PER_QUESTION,
			'table'                   => true,

		),
	);

$this->fields = $this->fields + array(
		'create_pages' => array(
			'step'     => STEP_MENU,
			'section'  => 1,
			'source'   => 'wizard',
			'callback' => 'wizard_add_pages',
			'label'    => '',
			'time'     => CMPLZ_MINUTES_PER_QUESTION_QUICK,
		),
	);

$this->fields = $this->fields + array(
		'add_pages_to_menu' => array(
			'step'     => STEP_MENU,
			'section'  => 2,
			'source'   => 'wizard',
			'callback' => 'wizard_add_pages_to_menu',
			'label'    => '',
			'time'     => CMPLZ_MINUTES_PER_QUESTION_QUICK,
		),
	);

$this->fields = $this->fields + array(
		'finish_setup' => array(
			'step'     => STEP_FINISH,
			'source'   => 'wizard',
			'callback' => 'wizard_last_step',
			'label'    => '',
		),
	);
