<?php
defined('ABSPATH') or die("you do not have acces to this page!");

if (!class_exists("cmplz_processing")) {
    class cmplz_processing extends cmplz_document
    {
        private static $_this;
        public $position;
        public $cookies = array();
        public $known_wizard_keys;
        public $total_steps;
        public $total_sections;
        public $page_url;

        function __construct()
        {
            if (isset(self::$_this))
	            wp_die(sprintf('%s is a singleton class and you cannot create a second instance.', get_class($this)));

            self::$_this = $this;

            //callback from settings
            add_action('cmplz_processing_last_step', array($this, 'processing_last_step_callback'), 10, 1);

	        //link action to custom hook
	        foreach (cmplz_get_regions() as $region => $label){
		        add_action("cmplz_wizard_processing-$region", array($this, 'processing_after_last_step'), 10, 1);
	        }
            add_action('admin_enqueue_scripts', array($this, 'enqueue_assets_processing'));
        }

        static function this()
        {
            return self::$_this;
        }



        public function enqueue_assets_processing($hook)
        {
            global $post;

            if ((!$post || get_post_type($post) !== 'cmplz-processing') && (!isset($_GET['post_type']) || $_GET['post_type'] !== 'cmplz-processing')) return;

            wp_register_style('cmplz-fontawesome', cmplz_url . 'assets/fontawesome/fontawesome-all.css', "", cmplz_version);
            wp_enqueue_style('cmplz-fontawesome');

            if ($post) {

                $min = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
                $load_css = cmplz_get_value('use_document_css');
                if ($load_css) {
                    wp_register_style('cmplz-document', cmplz_url . "assets/css/document$min.css", false, cmplz_version);
                    wp_enqueue_style('cmplz-document');
                }

                wp_register_style('cmplz-wizard', cmplz_url . 'assets/css/wizard.css', false, cmplz_version);
                wp_enqueue_style('cmplz-wizard');

            }
        }


        public function processing_agreements(){
            $args = array(
                    'post_type' => 'cmplz-processing',
	                'numberposts' => -1,
            );
            $posts = get_posts($args);
            return wp_list_pluck($posts, 'post_title','ID');
        }

        /*
         * Check if sharing with processors is enabled.
         *
         *
         * */

        public function has_processors(){

            $processors_eu = cmplz_get_value('share_data_other_us');

            $processors_us = cmplz_get_value('share_data_other');

            if ($processors_eu==2 && $processors_us==2){
                return false;
            }

            return true;
        }

        public function missing_agreements_for_processors(){

            if (!$this->has_processors()) return 0;

            $count=0;

            $processors = cmplz_get_value('processor');
            if (!empty($processors)) {
                foreach ($processors as $processor) {
                    if (!isset($processor['processing_agreement']) || intval($processor['processing_agreement']) == 0) {
                        $count++;
                    }
                }
            }

            return $count;

        }

        /*
         * Show the processing agreement page
         *
         *
         * */

        public function processing_agreement_page($region)
        {
            $label = COMPLIANZ::$config->regions[$region]['label'];
            ?>
            <div class="wrap">
                <div class="cmplz-wizard-title"><h1><?php sprintf(_x("Processing agreement (%s)",'Title on page', 'complianz-gdpr'),$label) ?></h1></div>
                <?php if (COMPLIANZ::$license->license_is_valid()) { ?>
                    <?php COMPLIANZ::$wizard->wizard("processing-$region"); ?>
                <?php } else {
                    cmplz_notice(__('Your license needs to be activated to unlock the wizard', 'complianz-gdpr'), 'warning');
                } ?>
            </div>
            <?php
        }






        public function processing_last_step_callback()
        {
            $page = COMPLIANZ::$wizard->wizard_type();
            if (!COMPLIANZ::$wizard->all_required_fields_completed($page)) {
                _e("Not all required fields are completed yet. Please check the steps to complete all required questions", 'complianz-gdpr');
            } else {
                printf(__("All steps have been completed. Click %s to complete the configuration and create a processing agreement. You can come back to change your configuration at any time.", 'complianz-gdpr'), __("View document", 'complianz-gdpr'));
            }
        }




        public function processing_after_last_step()
        {
            if (!cmplz_user_can_manage()) return;
            $page = str_replace('cmplz-', '',$_GET['page']);

            if (isset($_POST['cmplz-finish']) || isset($_POST['cmplz-previous']) || isset($_POST['cmplz-save']) || isset($_POST['cmplz-next'])) {
                $date = cmplz_localize_date(date(get_option('date_format'), time()));
                $post_id = COMPLIANZ::$wizard->post_id();
                $title = cmplz_get_value('name_of_processor') . " " . $date;
                if (empty($title)) $title = sprintf(__("Processing agreement %s", 'complianz-gdpr'), $date);
                $status = isset($_POST['cmplz-finish']) ? 'publish' : 'draft';

                $args = array(
                    'post_status' => $status,
                    'post_title' => $title,
                    'post_type' => 'cmplz-processing',
                );
                if (!$post_id) {
                    //create new post type processing, and add all wizard data as meta fields.
                    $post_id = wp_insert_post($args);
                    $_POST['post_id'] = $post_id;
                } else {
                    $args['ID'] = $post_id;
                    wp_update_post($args);
                }

                $this->set_region($post_id);

                //get all fields for this page
                $fields = COMPLIANZ::$config->fields($page);
                foreach ($fields as $fieldname => $field) {
                    update_post_meta($post_id, $fieldname, cmplz_get_value($fieldname));
                }

                //redirect to posts overview
                if ($status == 'publish') {
                    wp_redirect(admin_url("post.php?post=$post_id&action=edit"));
                    delete_option('complianz_options_processing');
                    exit();
                }

            }


        }



    }
} //class closure
