<?php
defined('ABSPATH') or die("you do not have acces to this page!");

function cmplz_site_uses_comments(){
    return COMPLIANZ::$comments->site_uses_comments();
}

function cmplz_dataleak_page_us(){
    COMPLIANZ::$dataleak->dataleak_page('us');
}

function cmplz_dataleak_page_eu(){
    COMPLIANZ::$dataleak->dataleak_page('eu');
}
function cmplz_dataleak_page_uk(){
    COMPLIANZ::$dataleak->dataleak_page('uk');
}
function cmplz_dataleak_page_ca(){
	COMPLIANZ::$dataleak->dataleak_page('ca');
}
function cmplz_processing_page_us(){
    COMPLIANZ::$processing->processing_agreement_page('us');
}
function cmplz_processing_page_uk(){
    COMPLIANZ::$processing->processing_agreement_page('uk');
}
function cmplz_processing_page_eu(){
    COMPLIANZ::$processing->processing_agreement_page('eu');
}
function cmplz_processing_page_ca(){
	COMPLIANZ::$processing->processing_agreement_page('ca');
}

function cmplz_dataleak_has_to_be_reported()
{
    return COMPLIANZ::$dataleak->dataleak_has_to_be_reported();
}
function cmplz_dataleak_has_to_be_reported_to_involved()
{
    return COMPLIANZ::$dataleak->dataleak_has_to_be_reported_to_involved();
}

function cmplz_socialsecurity_or_driverslicense()
{
    $type = cmplz_get_value('name-what-us');

    if (isset($type['drivers-license']) && $type['drivers-license'] ==1) {
        return true;
    }
    if (isset($type['social-security-number']) && $type['social-security-number'] ==1) {
        return true;
    }

    return false;
}

/**
 * If free is active, we should deactivate it.
 *
 * */

add_action('admin_init', 'cmplz_check_for_free_version');
if (!function_exists('cmplz_check_for_free_version')) {
    function cmplz_check_for_free_version()
    {
        if (defined('cmplz_free')) {
            $free = 'complianz-gdpr/complianz-gpdr.php';
            deactivate_plugins($free);
            add_action('admin_notices', 'cmplz_notice_free_active');
        }
    }
}

if (!function_exists('cmplz_notice_free_active')) {
    function cmplz_notice_free_active()
    {
        ?>
        <div id="message" class="updated fade notice is-dismissible really-simple-plugins">
            <h3><?php echo __("Great! Complianz Privacy Suite premium has been activated.", 'complianz-gdpr'); ?></h3>
            <p>
                <?php echo __("Because the free version is no longer needed, it has been deactivated.", "complianz-gdpr"); ?></p>
            </p>
        </div>
        <?php
    }
}



/**
 *   Get a list of files from a directory, with the extensions as passed.
 */

function cmplz_remove_free_translation_files()
{
    $path = dirname(cmplz_path, 2)."/languages/plugins/";
    $extensions = array("po", "mo");
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != "..") {
                $file = $path . '/' . $file;
                $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                if (is_file($file) && in_array($ext, $extensions) && strpos($file, 'complianz-gdpr')!==FALSE && strpos($file, 'backup')===FALSE) {
                    //copy to new file
                    $new_name = str_replace('complianz-gdpr','complianz-gdpr-backup-'.time(),$file);

                    rename($file, $new_name);
                }
            }
        }
        closedir($handle);
    }
}

/**
 * Get a list of files from a directory, with the extensions as passed.
 * @return bool
 */

function cmplz_has_free_translation_files()
{
    $path = dirname(cmplz_path, 2)."/languages/plugins/";
    if (!file_exists($path)) return false;

    $has_free_files = false;
    $extensions = array("po", "mo");
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != "..") {
                $file = $path . '/' . $file;
                $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                if (is_file($file) && in_array($ext, $extensions) && strpos($file, 'complianz-gdpr')!==FALSE) {
                    $has_free_files =  true;
                    break;
                }
            }
        }
        closedir($handle);
    }

    return $has_free_files;
}
