<?php
defined('ABSPATH') or die("you do not have acces to this page!");
$this->fields = $this->fields + array(
        'has-wizard-been-completed' => array(
            'step' => 1,
            'source' =>  'dataleak-eu',
            'type' => 'radio',
            'default' => '',
            'callback' => 'is_wizard_completed',
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'security-incident-occurred' => array(
            'step' => 2,
            'section' => 1,
            'source' =>  'dataleak-eu',
            'type' => 'radio',
            'required' => true,
            'default' => '',
            'label' => __("Has a security incident occurred?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'help' => __("e.g. lost USB stick, break in, stolen laptop, password lost.", 'complianz-gdpr'),
        ),

        'type-of-dataloss' => array(
            'step' => 2,
            'section' => 2,
            'source' =>  'dataleak-eu',
            'type' => 'radio',
            'default' => '',
            'required' => true,
            'label' => __("Which situation applies to the incident above.", 'complianz-gdpr'),
            'callback_condition' => array('security-incident-occurred' => 'yes'),
            'options' => array(
                '1' => __('Personal data is lost, without a recent copy or back-up.', 'complianz-gdpr'),
                '2' => __('It can not be excluded that unauthorized persons have gained access to the personal data', 'complianz-gdpr'),
                '3' => __('The above alternatives do not apply.', 'complianz-gdpr'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'reach-of-dataloss' => array(
            'step' => 2,
            'section' => 2,
            'source' =>  'dataleak-eu',
            'type' => 'radio',
            'default' => '',
            'required' => true,
            'label' => __("Which situation applies to the incident above.", 'complianz-gdpr'),
            'callback_condition' => array(
                'security-incident-occurred' => 'yes',
            ),
            'condition' => array('type-of-dataloss'=> 'NOT 3'),
            'options' => array(
                '1' => __('The data breach concerns more than 50 people.', 'complianz-gdpr'),
                '2' => __('The data breach concerns sensitive personal data.', 'complianz-gdpr'),
                '3' => __('The above alternatives do not apply.', 'complianz-gdpr'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'risk-of-data-loss' => array(
            'step' => 3,
            'source' =>  'dataleak-eu',
            'type' => 'radio',
            'default' => '',
            'required' => true,
            'label' => __("Risk of dataloss", 'complianz-gdpr'),
            'callback_condition' => array(
                'type-of-dataloss' => 'NOT 3',
                'reach-of-dataloss' => 'NOT 3',
                'security-incident-occurred' => 'yes',
            ),
            'options' => array(
                '1' => __('The data is encrypted in such a way that the data cannot be used in any way', 'complianz-gdpr'),
                '2' => __('Usage of the personal data is reduced or excluded directly after the breach to minimise damage.', 'complianz-gdpr'),
                '3' => __('The breached data presents a high risk for those involved.', 'complianz-gdpr'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'what-occurred' => array(
            'step' => 3,
            'source' =>  'dataleak-eu',
            'type' => 'text',
            'translatable' => true,
            'default' => '',
            'required' => true,
            'label' => __("What has occurred exactly?", 'complianz-gdpr'),
            'callback_condition' => array(
                'type-of-dataloss' => 'NOT 3',
                'reach-of-dataloss' => 'NOT 3',
                'security-incident-occurred' => 'yes',
            ),
            'condition' => array('risk-of-data-loss' => '3'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'consequences' => array(
            'step' => 3,
            'source' =>  'dataleak-eu',
            'type' => 'text',
            'translatable' => true,
            'required' => true,
            'default' => '',
            'label' => __("What are the possible consequences?", 'complianz-gdpr'),
            'callback_condition' => array(
                'type-of-dataloss' => 'NOT 3',
                'reach-of-dataloss' => 'NOT 3',
                'security-incident-occurred' => 'yes',
            ),
            'condition' => array('risk-of-data-loss' => '3'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'measures' => array(
            'step' => 3,
            'source' =>  'dataleak-eu',
            'type' => 'text',
            'translatable' => true,
            'default' => '',
            'required' => true,
            'label' => __("What measures have been taken after the breach?", 'complianz-gdpr'),
            'callback_condition' => array(
                'type-of-dataloss' => 'NOT 3',
                'reach-of-dataloss' => 'NOT 3',
                'security-incident-occurred' => 'yes',
            ),
            'condition' => array('risk-of-data-loss' => '3'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'measures_by_person_involved' => array(
            'step' => 3,
            'section' => 1,
            'source' =>  'dataleak-eu',
            'type' => 'text',
            'translatable' => true,
            'default' => '',
            'required' => true,
            'label' => __("What measures could a person involved take to minimise damage?", 'complianz-gdpr'),
            'callback_condition' => array(
                'type-of-dataloss' => 'NOT 3',
                'reach-of-dataloss' => 'NOT 3',
                'security-incident-occurred' => 'yes',
            ),
            'condition' => array('risk-of-data-loss' => '3'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'conclusion' => array(
            'step' => 4,
            'source' =>  'dataleak-eu',
            'callback' => 'dataleak_conclusion',
            'type' => 'text',
            'default' => '',
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
    );