<?php
defined('ABSPATH') or die("you do not have acces to this page!");

/*
 * condition: if a question should be dynamically shown or hidden, depending on another answer. Use NOT answer to hide if not answer.
 * callback_condition: if should be shown or hidden based on an answer in another screen.
 * callback roept action cmplz_$page_$callback aan
 * required: verplicht veld.
 * help: helptext die achter het veld getoond wordt.

                "fieldname" => '',
                "type" => 'text',
                "required" => false,
                'default' => '',
                'label' => '',
                'table' => false,
                'callback_condition' => false,
                'condition' => false,
                'callback' => false,
                'placeholder' => '',
                'optional' => false,

* */

// MY COMPANY SECTION
$this->fields = $this->fields + array(


        'socialmedia_company' => array(
            'step' => STEP_COMPANY,
            'section' => 3,
            'source' => 'wizard',
            'type' => 'multicheckbox',
            'options' => array(
                'facebook' => __('Facebook', 'complianz-gdpr'),
                'twitter' => __('Twitter', 'complianz-gdpr'),
                'linkedin' => __('Linkedin', 'complianz-gdpr'),
                'whatsapp' => __('Whatsapp', 'complianz-gdpr'),
            ),
            'optional' => true,
            'default' => '',
            'label' => __("Which social media do you use for questions regarding your privacy statement?", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'free_phonenr' => array(
            'step' => STEP_COMPANY,
            'section' => 3,
            'source' => 'wizard',
            'type' => 'phone',
            'default' => '',
            'required' => false,
            'label' => __("Enter a toll free phone number for the submission of information requests", 'complianz-gdpr'),
            'document_label' => 'Toll free phone number: ',
            'callback_condition' => array(
                'regions' => 'us',
            ),
            'help' => __('For US based companies, you can provide a toll free phone number for inquiries.','complianz-gdpr').$this->read_more('https://complianz.io/toll-free-number/'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'automated_processes' => array(
            'step' => STEP_COMPANY,
            'section' => 3,
            'source' => 'wizard',
            'type' => 'radio',
            'options' => $this->yes_no,
            'required' => true,
            'help' => __("Think of processes which are automated. For instance making automated predictions of someones paying behavior based on their postal codes, which might obligate someone to pre-pay the product.", 'complianz-gdpr'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => array('eu','uk'),
            ),
            'label' => __("We take decisions based on automated processes, such as profiling, that could have significant consequences for our users.", 'complianz-gdpr'),
        ),

        'automated_processes_details' => array(
            'step' => STEP_COMPANY,
            'section' => 3,
            'source' => 'wizard',
            'type' => 'textarea',
            'required' => true,
            'condition'=>array(
                'automated_processes'=>'yes',
            ),
            'label' => __("Specify what kind of decisions these are, what the consequences are, and what (in general terms) the logic behind these decisions is.", 'complianz-gdpr'),
        ),

        // DATA PROTECTION OFFICER
        'dpo_or_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => '',
            'label' => __("Does the following apply to you?", 'complianz-gdpr'),
            'options' => array(
                'dpo' => __('We have appointed a data protection officer', 'complianz-gdpr'),
                'gdpr_rep' => __('We have a GDPR representative within the EU', 'complianz-gdpr'),
                'none' => __('None of the above', 'complianz-gdpr')
            ),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'required' => true,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'name_dpo' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'text',
            'required' => true,
            'default' => '',
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'label' => __("What is the name of the data protection officer", 'complianz-gdpr'),
            'condition' => array('dpo_or_gdpr' => 'dpo'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'email_dpo' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'email',
            'default' => '',
            'required' => true,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'label' => __("What is the email address of the data protection officer?", 'complianz-gdpr'),
            'condition' => array('dpo_or_gdpr' => 'dpo'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'phone_dpo' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'phone',
            'default' => '',
            'required' => false,
            'label' => __("What is the phone number of the data protection officer", 'complianz-gdpr'),
            'condition' => array('dpo_or_gdpr' => 'dpo'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'name_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'text',
            'default' => '',
            'required' => true,
            'label' => __("What is the name of the representative", 'complianz-gdpr'),
            'condition' => array('dpo_or_gdpr' => 'gdpr_rep'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'email_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'email',
            'default' => '',
            'required' => true,
            'label' => __("What is the email address of the representative?", 'complianz-gdpr'),
            'condition' => array('dpo_or_gdpr' => 'gdpr_rep'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'phone_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'phone',
            'default' => '',
            'required' => true,
            'label' => __("What is the phone number of the representative?", 'complianz-gdpr'),
            'condition' => array('dpo_or_gdpr' => 'gdpr_rep'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'eu',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'dpo_or_uk_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => '',
            'label' => __("Does the following apply to you?", 'complianz-gdpr'),
            'options' => array(
                'dpo' => __('We have appointed a data protection officer', 'complianz-gdpr'),
                'uk_gdpr_rep' => __('We have a UK-GDPR representative within the United Kingdom', 'complianz-gdpr'),
                'none' => __('None of the above', 'complianz-gdpr')
            ),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'required' => true,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'name_uk_dpo' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'text',
            'required' => true,
            'default' => '',
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'label' => __("What is the name of the data protection officer", 'complianz-gdpr'),
            'condition' => array('dpo_or_uk_gdpr' => 'dpo'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'email_uk_dpo' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'email',
            'default' => '',
            'required' => true,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'label' => __("What is the email address of the data protection officer?", 'complianz-gdpr'),
            'condition' => array('dpo_or_uk_gdpr' => 'dpo'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'phone_uk_dpo' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'phone',
            'default' => '',
            'required' => false,
            'label' => __("What is the phone number of the data protection officer", 'complianz-gdpr'),
            'condition' => array('dpo_or_uk_gdpr' => 'dpo'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),
        'name_uk_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'text',
            'default' => '',
            'required' => true,
            'label' => __("What is the name of the representative", 'complianz-gdpr'),
            'condition' => array('dpo_or_uk_gdpr' => 'uk_gdpr_rep'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'email_uk_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'email',
            'default' => '',
            'required' => true,
            'label' => __("What is the email address of the representative?", 'complianz-gdpr'),
            'condition' => array('dpo_or_uk_gdpr' => 'uk_gdpr_rep'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'phone_uk_gdpr' => array(
            'step' => STEP_COMPANY,
            'section' => 4,
            'source' => 'wizard',
            'type' => 'phone',
            'default' => '',
            'required' => true,
            'label' => __("What is the phone number of the representative?", 'complianz-gdpr'),
            'condition' => array('dpo_or_uk_gdpr' => 'uk_gdpr_rep'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'uk',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        //dynamic purposes here


        // THIRD PARTIES
        'share_data_other' => array(
            'step' => STEP_COMPANY,
            'section' => 8,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => '',
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => array('eu','uk'),
            ),
            'options' => array(
                '1' => __('Yes, both to processors and other third parties, whereby the data subject must give permission.', 'complianz-gdpr'),
                '2' => __('No', 'complianz-gdpr'),
                '3' => __('Limited: only with processors that are necessary for the fulfillment of my service', 'complianz-gdpr'),
            ),
            'label' => __("Do you share personal data with other parties?", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => true,
            'help' => __("Within the GDPR a ‘processor’ means a natural or legal person, public authority, agency or other body which processes personal data on behalf of the controller.", 'complianz-gdpr')." ".__("A third party is every other entity which receives personal data, but does not fall within the definition of a processor", 'complianz-gdpr'),

        ),

        'processor' => array(
            'step' => STEP_COMPANY,
            'section' => 8,
            'source' => 'wizard',
            'region' => 'eu',
            'type' => 'processors',
            'required' => false,
            'default' => '',
            'condition' => array('share_data_other' => 'NOT 2'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => array('eu','uk'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'label' => __("Processor", 'complianz-gdpr'),
            'help' => __('If you share data with processors, add a "processor" for each one, and add the details of the data you share.', 'complianz-gdpr'),
        ),

        'thirdparty' => array(
            'step' => STEP_COMPANY,
            'section' => 8,
            'source' => 'wizard',
            'type' => 'thirdparties',
            'required' => false,
            'default' => '',
            'condition' => array('share_data_other' => '1'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => array('eu','uk'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'label' => __("Third party details", 'complianz-gdpr'),
            'help' => __('If you share data with third parties, add a "third party" for each one, and add the details of the data you share.', 'complianz-gdpr'),
        ),

        'share_data_other_us' => array(
            'step' => STEP_COMPANY,
            'section' => 9,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => '',
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
            ),
            'options' => array(
                '1' => __('Yes, both to service providers and other third parties.', 'complianz-gdpr'),
                '2' => __('No', 'complianz-gdpr'),
                '3' => __('Limited: only with service providers that are necessary for the fulfillment of my service', 'complianz-gdpr'),
            ),
            'label' => __("Do you share personal data with other parties?", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => true,
            'help' => __("A Service provider is a legal entity that processes information on behalf of a business and to which the business discloses a consumer's personal information for a business purpose pursuant to a written contract.",'complianz-gdpr')." ".__("A third party is every other entity which receives personal data, but does not fall within the definition of a Service Provider", 'complianz-gdpr'),
        ),

        'processor_us' => array(
            'step' => STEP_COMPANY,
            'region' => 'us',
            'section' => 9,
            'source' => 'wizard',
            'type' => 'processors',
            'required' => false,
            'default' => '',
            'condition' => array('share_data_other_us' => 'NOT 2'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'label' => __("Service Provider", 'complianz-gdpr'),
            'help' => __('If you share data with service providers, add a "Service Provider" for each one, and add the details of the data you share.', 'complianz-gdpr'),
        ),

        'data_disclosed_us' => array(
            'step' => STEP_COMPANY,
            'section' => 9,
            'source' => 'wizard',
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __('Select which categories of personal data you have disclosed for a business purpose in the past 12 months', 'complianz-gdpr'),
            'required' => true,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
                'california' => 'yes',
            ),
            //'condition' => array('share_data_other_us' => 'NOT 2'),
            'options' => $this->details_per_purpose_us,
            'time' => CMPLZ_MINUTES_PER_QUESTION_QUICK,
        ),

        'data_sold_us' => array(
            'step' => STEP_COMPANY,
            'section' => 9,
            'source' => 'wizard',
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __('Select which categories of personal data you have sold to third parties in the past 12 months', 'complianz-gdpr'),
            'required' => true,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
                'purpose_personaldata' => 'selling-data-thirdparty',
            ),
            'condition' => array(),
            'options' => $this->details_per_purpose_us,
            'time' => CMPLZ_MINUTES_PER_QUESTION_QUICK,
        ),

        /*
         * consent boxes
         * */

        'add_consent_to_forms' => array(
            'step' => STEP_COMPANY,
            'section' => 10,
            'source' => 'wizard',
            'type' => 'multicheckbox',
            'required' => false,
            'default' => '',
            'label' => __("For forms detected on your site, you can choose to add a consent checkbox", 'complianz-gdpr'),
            'options' => get_option('cmplz_detected_forms'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'contact_processing_data_lawfull'=>'1',
                'regions' => array('eu','uk'),
            ),//when permission is required, add consent box
            'help' => __('You have answered that you use webforms on your site. Not every form that collects personal data requires a checkbox. It isn’t required if the only actionable use for the data collected is communicated clearly via form. If there may be additional actionable uses, then additional explicit consent is required. For forms you select here, an explicit checkbox asking consent will get added. For forms not in this list you can do this manually in the form editor.', 'complianz-gdpr').$this->read_more('https://complianz.io/how-to-implement-a-consent-box'),
        ),


        //  & SAFETY
        'secure_personal_data' => array(
            'step' => STEP_COMPANY,
            'section' => 10,
            'source' => 'wizard',
            'type' => 'radio',
            'required' => true,
            'default' => '',
            'label' => __("How do you secure personal data acquired on your website?", 'complianz-gdpr'),
            'options' => array(
                '1' => __('We give a general explanation about security in the privacy statement', 'complianz-gdpr'),
                '2' => __('We will list our security measures', 'complianz-gdpr')
            ),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'which_personal_data_secure' => array(
            'step' => STEP_COMPANY,
            'section' => 10,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("Which security measures did you take?", 'complianz-gdpr'),
            'options' => array(
                '1' => __('Username and Password', 'complianz-gdpr'),
                '2' => __('DNSSEC', 'complianz-gdpr'),
                '3' => __('TLS / SSL', 'complianz-gdpr'),
                '4' => __('DKIM, SPF en DMARC', 'complianz-gdpr'),
                '5' => __('Physical security measures of systems which contain personal  data.', 'complianz-gdpr'),
                '6' => __('Security software', 'complianz-gdpr'),
                '7' => __('ISO27001/27002 certified', 'complianz-gdpr'),
            ),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
            ),
            'condition' => array('secure_personal_data' => '2'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'respect_dnt' => array(
            'step' => STEP_COMPANY,
            'section' => 10,
            'source' => 'wizard',
            'type' => 'select',
            'options' => $this->yes_no,
            'required' => true,
            'default' => 'yes',
            'label' => __("Do you want to respect Do Not Track settings in browsers?", 'complianz-gdpr'),
            'help' => __('If a user has set Do Not Track in the browser you can choose if you want to respect this. Social Media often do not do this out of the box. Enabling this option will drop the cookie warning for those users, and will not load any third party scripts.','complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
        ),

        'financial-incentives' => array(
            'step' => STEP_COMPANY,
            'section' => 11,
            'source' => 'wizard',
            'required' => true,
            'type' => 'radio',
            'default' => '',
            'label' => __("Do you offer financial incentives, including payments to consumers as compensation, for the collection of personal information, the sale of personal information, or the deletion of personal information?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
                'california' => 'yes',
            ),
        ),

        'financial-incentives-terms-url' => array(
            'step' => STEP_COMPANY,
            'section' => 11,
            'placholder' => __('https://your-terms-page.com','complianz-gdpr'),
            'source' => 'wizard',
            'required' => true,
            'type' => 'url',
            'default' => '',
            'label' => __("Enter the URL of the terms & conditions page for the incentives", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'condition' => array('financial-incentives' => 'yes'),
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
                'california' => 'yes',

            ),
            'help' => __("Please note that the consumer explicitly has to consent to these terms, and that the consumer must be able to revoke this consent. ", 'complianz-gdpr'),
        ),

        'targets-children' => array(
            'step' => STEP_COMPANY,
            'section' => 12,
            'source' => 'wizard',
            'required' => true,
            'type' => 'radio',
            'default' => '',
            'label' => __("Is your website designed to attract children and/or is it your intent to collect personal data from children under the age of 13?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',

            ),
        ),

        'children-parent-consent-type' => array(
            'step' => STEP_COMPANY,
            'section' => 12,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("How do you obtain verifiable parental consent for the collection, use, or disclosure of personal information from children?", 'complianz-gdpr'),
            'options' => array(
                'email' => __("We seek a parent or guardian's consent by email",'complianz-gdpr'),
                'creditcard' => __('We seek a high level of consent by asking for a creditcard verification','complianz-gdpr'),
                'phone-chat' => __('We use telephone or Videochat  to talk to the parent or guardian','complianz-gdpr'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',
            ),
            'condition' => array('targets-children' => 'yes'),
        ),

        'children-safe-harbor' => array(
            'step' => STEP_COMPANY,
            'section' => 12,
            'source' => 'wizard',
            'required' => true,
            'type' => 'radio',
            'default' => '',
            'label' => __("Is your website included in a COPPA Safe Harbor Certification Program?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
            ),
            'condition' => array(
                'targets-children' => 'yes'
            ),
        ),

        'children-name-safe-harbor' => array(
            'step' => STEP_COMPANY,
            'section' => 12,
            'source' => 'wizard',
            'required' => true,
            'type' => 'text',
            'default' => '',
            'label' => __("What is the name of the program?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
            ),
            'condition' => array(
                'children-safe-harbor' => 'yes'
            ),
        ),

        'children-url-safe-harbor' => array(
            'step' => STEP_COMPANY,
            'section' => 12,
            'source' => 'wizard',
            'required' => true,
            'type' => 'url',
            'default' => '',
            'label' => __("What is the URL of the program?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us',
            ),
            'condition' => array(
                'children-safe-harbor' => 'yes'
            ),
        ),

        'children-no-safe-harbor-notice' => array(
            'step' => STEP_COMPANY,
            'section' => 13,
            'source' => 'wizard',
            'required' => false,
            'type' => 'notice',
            'default' => '',
            'label' => sprintf(__("Your have indicated your website is not included in a COPPA Safe Harbor Certification Program. We recommend to check out %sPRIVO%s, as you target children on your website.", 'complianz-gdpr'),'<a href="https://www.privo.com/">','</a>'),
            'options' => $this->yes_no,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'targets-children' => 'yes',
                'regions' => 'us',
                'children-safe-harbor' => 'no',
            ),
        ),

        'children-what-purposes' => array(
            'step' => STEP_COMPANY,
            'section' => 13,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("For what potential activities on your website do you collect personal information from a child?", 'complianz-gdpr'),
            'options' => array(
                'registration' => __('Registration','complianz-gdpr'),
                'content-created-by-child' => __('Content created by a child and publicly shared','complianz-gdpr'),
                'chat' => __('Chat/messageboard','complianz-gdpr'),
                'email' => __('Email contact','complianz-gdpr'),
            ),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',
                'targets-children' => 'yes',
            ),
        ),

        'children-what-information-registration' => array(
            'step' => STEP_COMPANY,
            'section' => 13,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("Information collected for registration ", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'options' => $this->collected_info_children,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',
                'targets-children' => 'yes',

            ),
            'condition' => array(
                'children-what-purposes' => 'registration'),
        ),

        'children-what-information-content' => array(
            'step' => STEP_COMPANY,
            'section' => 13,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("Information collected for content created by a child", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'options' => $this->collected_info_children,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',
                'targets-children' => 'yes',
            ),
            'condition' => array(
                'children-what-purposes' => 'content-created-by-child'
            ),
        ),

        'children-what-information-chat' => array(
            'step' => STEP_COMPANY,
            'section' => 13,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("Information collected for chat/messageboard", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'options' => $this->collected_info_children,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',
                'targets-children' => 'yes',

            ),
            'condition' => array(
                'children-what-purposes' => 'chat'
            ),
        ),
        'children-what-information-email' => array(
            'step' => STEP_COMPANY,
            'section' => 13,
            'source' => 'wizard',
            'required' => true,
            'type' => 'multicheckbox',
            'default' => '',
            'label' => __("Information collected for email contact", 'complianz-gdpr'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'options' => $this->collected_info_children,
            'callback_condition' => array(
                'privacy-statement' => 'yes',
                'regions' => 'us,uk',
                'targets-children' => 'yes',

            ),
            'condition' => array(
                'children-what-purposes' => 'email'),
        ),



        //DISCLAIMER
        'themes' => array(
            'step' => STEP_COMPANY,
            'section' => 14,
            'source' => 'wizard',
            'type' => 'multicheckbox',
            'default' => '1',
            'label' => __("Which themes would you like to include in your disclaimer?", 'complianz-gdpr'),
            'options' => array(
                '1' => __('Liability', 'complianz-gdpr'),
                '2' => __('Reference to terms of use', 'complianz-gdpr'),
                '3' => __('How you will answer inquiries', 'complianz-gdpr'),
                '4' => __('Privacy and reference to the privacy statement', 'complianz-gdpr'),
                '5' => __('Not liable when security is breached', 'complianz-gdpr'),
                '6' => __('Not liable for third party content', 'complianz-gdpr'),
                '7' => __('Accessibility of the website for the disabled', 'complianz-gdpr'),
            ),
            'callback_condition' => array('disclaimer' => 'yes'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => true,
        ),
        'terms_of_use_link' => array(
            'step' => STEP_COMPANY,
            'section' => 14,
            'source' => 'wizard',
            'type' => 'url',
            'default' => '',
            'label' => __("What is the URL of the Terms of Use?", 'complianz-gdpr'),
            'condition' => array('themes' => '2'),
            'callback_condition' => array('disclaimer' => 'yes'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => true,
        ),

        'wcag' => array(
            'step' => STEP_COMPANY,
            'section' => 14,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => 'The WCAG documents explain how to make web content more accessible to people with disabilities.',
            'label' => __("Is your website built according to WCAG 2.0 level AA guidelines?", 'complianz-gdpr'),
            'options' => $this->yes_no,
            'condition' => array('themes' => '7'),
            'callback_condition' => array('disclaimer' => 'yes'),
            'required' => true,
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'help' => $this->read_more('https://complianz.io/wcag-2-0-what-is-it/', false),

        ),

        // AUTEURSRECHTEN disclaimer
        'development' => array(
            'step' => STEP_COMPANY,
            'section' => 14,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => '',
            'label' => __("Who made the content of the website?", 'complianz-gdpr'),
            'options' => array(
                '1' => __('The content is being developed by ourselves', 'complianz-gdpr'),
                '2' => __('The content is being developed or posted by third parties', 'complianz-gdpr'),
                '3' => __('The content is being developed by ourselves and other parties', 'complianz-gdpr'),
            ),
            'callback_condition' => array('disclaimer' => 'yes'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => true,
        ),

        'ip-claims' => array(
            'step' => STEP_COMPANY,
            'section' => 14,
            'source' => 'wizard',
            'type' => 'radio',
            'default' => '',
            'required' => true,
            'label' => __("What do you want to do with any intellectual property claims?", 'complianz-gdpr'),
            'options' => array(
                '1' => __('All rights reserved', 'complianz-gdpr'),
                '2' => __('No rights reserved', 'complianz-gdpr'),
                '3' => __('Creative Commons - Attribution', 'complianz-gdpr'),
                '4' => __('Creative Commons - Share a like', 'complianz-gdpr'),
                '5' => __('Creative Commons - No derivatives', 'complianz-gdpr'),
                '6' => __('Creative Commons - Noncommercial', 'complianz-gdpr'),
                '7' => __('Creative Commons - Share a like, noncommercial', 'complianz-gdpr'),
            ),
            'callback_condition' => array('disclaimer' => 'yes'),
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'help' => __("Creative Commons (CC) is an American non-profit organization devoted to expanding the range of creative works available for others to build upon legally and to share.", 'complianz-gdpr').$this->read_more('https://complianz.io/creative-commons'),
        ),

    );


$this->fields = $this->fields + array(
        'wp_privacy_policies' => array(
            'step' => STEP_PLUGINS,
            'section' => 1,
            'source' => 'wizard',
            'type' => 'multiple',
            'label' => __("Do you want to add a disclaimer on your site?", 'complianz-gdpr'),
            'callback' => 'wp_privacy_policies',
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => false,
        ),
        'custom_privacy_policy_text' => array(
            'step' => STEP_PLUGINS,
            'section' => 1,
            'translatable' => true,
            'source' => 'wizard',
            'type' => 'editor',
            'label' => '',
            'time' => CMPLZ_MINUTES_PER_QUESTION,
            'required' => false,
            'media'=>false,
        ),
    );
