<?php
defined('ABSPATH') or die("you do not have acces to this page!");

add_action('cmplz_notice_use_country', 'cmplz_notice_use_country');
function cmplz_notice_use_country(){

    if (COMPLIANZ()->geoip->geoip_library_error()) {

        $error = get_option('cmplz_geoip_import_error');
        $folder = "/complianz/maxmind";
        cmplz_notice(sprintf(__("You have enabled Geo IP, but the GEO IP database hasn't been downloaded automatically. If you continue to see this message, download the file from %sMaxMind%s and put it in the %s folder in your WordPress uploads directory", 'complianz-gdpr'),'<a href="https://complianz.io/maxmind/GeoLite2-Country.mmdb">',"</a>", $folder),'warning');

        if ($error){
            cmplz_notice(sprintf(__("The following error was reported: %s", 'complianz-gdpr'),$error),'warning');
        }

    }

}


add_action('cmplz_notice_dpo_or_gdpr', 'cmplz_dpo_or_gdpr');
function cmplz_dpo_or_gdpr(){

    if (!cmplz_company_located_in_region('eu')){
        cmplz_notice(__("Your company is located outside the EU, so should appoint a GDPR representative in the EU.", 'complianz-gdpr'));
    } else {
        cmplz_notice(__("Your company is located in the EU, so you do not need to appoint a GDPR representative in the EU.", 'complianz-gdpr'));
    }
}


add_action('cmplz_notice_dpo_or_uk_gdpr', 'cmplz_dpo_or_uk_gdpr');
function cmplz_dpo_or_uk_gdpr(){

    if (!cmplz_company_located_in_region('uk')){
        cmplz_notice(__("Your company is located outside the United Kingdom, so should appoint a UK-GDPR representative in the United Kingdom.", 'complianz-gdpr'));
    } else {
        cmplz_notice(__("Your company is located in the United Kingdom, so you do not need to appoint a UK-GDPR representative in the United Kingdom.", 'complianz-gdpr'));
    }
}


add_filter('cmplz_default_value', 'cmplz_pro_set_default', 10, 2);
function cmplz_pro_set_default($value, $fieldname)
{

    if ($fieldname == 'dpo_or_gdpr') {
        if (!cmplz_company_located_in_region('eu')) return 'gdpr_rep';
    }

    if ($fieldname == 'dpo_or_uk_gdpr') {
        if (!cmplz_company_located_in_region('uk')) {
            return 'uk_gdpr_rep';
        }
    }

    return $value;
}