<?php


defined('ABSPATH') or die("you do not have acces to this page!");
add_action('admin_init', 'cmplz_change_free_actions');
function cmplz_change_free_actions()
{
    remove_action("cmplz_documents_footer", array(COMPLIANZ()->admin, 'documents_footer'));
    remove_action("cmplz_documents", array(COMPLIANZ()->admin, 'documents'));

    remove_action("cmplz_dashboard_second_block", array(COMPLIANZ()->admin, 'dashboard_second_block'));
    add_action("cmplz_dashboard_second_block", 'cmplz_pro_dashboard_second_block');

    remove_action('cmplz_dashboard_elements_error', array(COMPLIANZ()->admin, 'dashboard_elements'));


}


/*
 * Premium should respect Do Not Track settings in browsers, if the user has enabled this setting.
 *
 *
 * */
add_filter('cmplz_dnt_enabled', 'cmplz_dnt_enabled');
function cmplz_dnt_enabled()
{
    //only if the user has explicitly enabled this
    if (cmplz_get_value('respect_dnt')!=='no') return false;

    return (isset($_SERVER['HTTP_DNT']) && $_SERVER['HTTP_DNT'] == 1);
}

add_filter('cmplz_user_consenttype', 'cmplz_user_consenttype');
function cmplz_user_consenttype($consenttype)
{
    if (COMPLIANZ()->geoip->geoip_enabled()) {
        $region = COMPLIANZ()->geoip->region();
        //prevent cookie banner from showing if region is not selected in target regions
        if (!cmplz_has_region($region)) return '';
        $consenttype = cmplz_get_consenttype_for_region($region);
    }

    return $consenttype;
}


function cmplz_add_dashboard_elements_error()
{
    //page required checks EU region
    //if US only, we the privacy statement EU is not required.
    if (cmplz_has_region('eu') && !COMPLIANZ()->document->page_required('privacy-statement')) {
        COMPLIANZ()->admin->task_count++;
        COMPLIANZ()->admin->get_dashboard_element(__("You haven't enabled the privacy statement, so we can't determine if you need consent checkboxes", 'complianz-gdpr'), 'warning');
    }
}
add_action("cmplz_dashboard_elements_error", 'cmplz_add_dashboard_elements_error');


/**
 * Add some notices in the dashboard regarding the consentboxes
 */

function cmplz_add_dashboard_elements_success()
{
    //page required checks EU region
    if (COMPLIANZ()->document->page_required('privacy-statement')) {
        if (cmplz_forms_used_on_sites()) {
            if (cmplz_consent_box_required_on_form()) {
                return; //handled by warnings array.
            } else {
                COMPLIANZ()->admin->get_dashboard_element(__('Your contact forms do not require a consent checkbox', 'complianz-gdpr'), 'success');
            }
        } else {
            COMPLIANZ()->admin->get_dashboard_element(__('You have indicated no contact forms are used on the website', 'complianz-gdpr'), 'success');
        }
    }

}
add_action("cmplz_dashboard_elements_success", 'cmplz_add_dashboard_elements_success');

/*
 * For premium, check if the license is valid before showing the wizard.
 *
 *
 * */

add_filter('cmplz_show_wizard_page', 'cmplz_show_wizard_page');
function cmplz_show_wizard_page($show)
{
    if (!COMPLIANZ()->license->license_is_valid()) {
        $show = false;
    }
    return $show;
}



//Pro dashboard second block
function cmplz_pro_dashboard_second_block()
{
    ?>

    <div class="cmplz-header-top cmplz-dashboard-text">
        <div class="cmplz-dashboard-title"> <?php echo __('Tools', 'complianz-gdpr'); ?> </div>
    </div>
    <?php
    cmplz_notice(COMPLIANZ()->admin->error_message, 'warning');
    cmplz_notice(COMPLIANZ()->admin->success_message, 'success', true);
    COMPLIANZ()->admin->error_message = "";
    COMPLIANZ()->admin->success_message = "";
    ?>
    <div class="cmplz-dashboard-support-content cmplz-dashboard-text">
        <ul>
            <?php do_action('cmplz_tools') ?>
            <?php
                $regions = cmplz_get_regions();
                foreach ($regions as $region => $label) {
                    ?>
                    <li><i class="fas fa-plus"></i><a
                                href="<?php echo admin_url("admin.php?page=cmplz-dataleak-$region") ?>"><?php printf(__("Create dataleak report (%s)", 'complianz-gdpr'), $label); ?></a>
                    </li>
                    <li><i class="fas fa-plus"></i><a
                                href="<?php echo admin_url("admin.php?page=cmplz-processing-$region") ?>"><?php printf(__("Create processing agreement (%s)", 'complianz-gdpr'), $label); ?></a>
                    </li>
            <?php }?>
            <li><i class="fas fa-plus"></i><a href="#"
                                              id="cmplz-support-link"><?php _e("Need help? Quickly submit your support ticket", 'complianz-gdpr'); ?></a>
            </li>
        </ul>
        <form method="POST" id="cmplz-support-form" action="" class="hidden">
            <?php wp_nonce_field('cmplz_support', 'cmplz_nonce') ?>
            <input type="text" name="cmplz_support_subject"
                   required placeholder="<?php _e("Summarize your issue in a few words", 'complianz-gdpr') ?>">
            <input type="email" name="cmplz_support_email" required
                   placeholder="<?php _e('Your email address', 'complianz-gdpr') ?>"
                   value="<?php
                   $user = wp_get_current_user();
                   echo $user->user_email ?>">
            <textarea placeholder="<?php _e("Describe your issue", 'complianz-gdpr') ?>" name="cmplz_support_request"
                      required></textarea>
            <input class="cmplz button" type="submit"
                   value="<?php _e('Submit ticket', 'complianz-gdpr') ?>">
        </form>
    </div>

    <?php
}


/*
 * Override logo text
 * */

add_filter('cmplz_logo_extension', 'cmplz_logo_extension');
function cmplz_logo_extension($str)
{
    $str = __("Premium", 'complianz-gdpr');
    return $str;
}


/*
 * Add some warnings which are only needed in the premium plugin
 *
 *
 * */

add_filter('cmplz_warnings', 'cmplz_pro_warnings');
function cmplz_pro_warnings($warnings)
{

    if (cmplz_wp_privacy_version() && WP_Privacy_Policy_Content::text_change_check()) {
        $warnings[] = 'suggested-policy-text-changed';
    }

    if (cmplz_has_region('eu') && COMPLIANZ()->processing->missing_agreements_for_processors() > 0) {
        $warnings[] = 'missing-processing-agreements';
    }

    if (COMPLIANZ()->geoip->geoip_library_error()) {
        $warnings[] = 'geoip-database-error';
    }

    return $warnings;
}



add_filter('cmplz_get_banners', 'cmplz_get_banners_filter');
function cmplz_get_banners_filter($banners){
    $banners = cmplz_get_cookiebanners();
    return $banners;
}





/**
 * Check if the plugin was just upgraded from free to premium, and if so, handle some migration
 * @hooked admin_init
 * @return void
 */

function cmplz_check_upgrade_from_free(){

    if (get_option('cmplz_run_premium_install')){
        //we don't use geo location yet, (upgrading from free)
        // so we don't need to upgrade the region yet. We can do that on the enabling of the geoip

        //remove free language files on upgrade to premium
        if (cmplz_has_free_translation_files()){
            cmplz_remove_free_translation_files();
        }

        //default, privacy statement and disclaimer are set to disabled in free, but we might want them to be enabled by default
        //the disadvantage would be that pages would be generated as well. We'll leave it for now
//        COMPLIANZ()->field->save_field('privacy-statement', 'yes');
//        COMPLIANZ()->field->save_field('disclaimer', 'yes');

        //enable Geo IP
        cmplz_update_option('settings', 'use_country', true);
        //start download of geo db.
        update_option('cmplz_import_geoip_on_activation', true);

        //set the region as the new array type
        $regions = cmplz_get_value('regions', false, 'wizard');

        if (!empty($regions) && !is_array($regions)) {
            $regions = array($regions => 1);
            cmplz_update_option('wizard', 'regions', $regions);
        }

        delete_option('cmplz_run_premium_install');
    }
}
add_action('admin_init', 'cmplz_check_upgrade_from_free');

/**
 * Hooks in on the free plugin upgrade function
 * Runs when the plugin is updated in the dashboard.
 * @param $prev_version
 * @hooked cmplz_upgrade
 * @return void
 */

function cmplz_upgrade_premium($prev_version)
{
    if (version_compare($prev_version, '2.0.6', '<')) {
        //add category eu existing dataleaks and processing agreements.
        $posts = get_posts(array('post_type' => array('cmplz-dataleak', 'cmplz-processing'), 'post_status'=> array('publish', 'pending', 'draft', 'auto-draft'), 'posts_per_page'=>-1));
        foreach ($posts as $post){
            if (!COMPLIANZ()->document->get_region($post->ID)){
                COMPLIANZ()->document->set_region($post->ID, 'eu');
            }
        }
    }

    /*
    * To prevent the free from overriding the shipped premium translations, we rename the free translations.
    * remove free translation files, if existent.
    */
    if (version_compare($prev_version, '2.1.1', '<')) {
        //remove free language files
        if (cmplz_has_free_translation_files()){
            cmplz_remove_free_translation_files();
        }
    }

    //set a default region if this is an upgrade:
    if ($prev_version && version_compare($prev_version, '2.0.1', '<')) {
        $regions = cmplz_get_value('regions');
        if (empty($regions)) {
            $country =  cmplz_get_value('use_country');
            if (defined('cmplz_premium')) {
                if ($country){
                    cmplz_update_option('wizard', 'regions', array('eu'));
                } else {
                    cmplz_update_option('wizard', 'regions', 'eu');
                }
            }
        }
    }

    //make sure the maxmind db is downloaded on upgrade
    if ($prev_version && version_compare($prev_version, '2.0.2', '<') && cmplz_get_value('use_country')) {
        update_option('cmplz_import_geoip_on_activation', true);
    }

    if (version_compare($prev_version, '3.0.0', '<')) {
        $variations = COMPLIANZ()->statistics->get_variations();
        if (is_array($variations) && !count($variations)==0) {
            foreach ($variations as $variation_id) {
                COMPLIANZ()->cookie->migrate_legacy_cookie_settings($variation_id);
            }
        }
    }

}
add_action('cmplz_upgrade',  'cmplz_upgrade_premium', 10);
