<?php
defined('ABSPATH') or die("you do not have acces to this page!");

$this->steps['wizard'][STEP_COMPANY] = array(
    "id" => "company",
    "title" => __("General", 'complianz-gdpr'),
    'sections' => array(
        1 => array(
            'id' => 'general',
            'title' => __('Documents', 'complianz-gdpr'),
            'intro' => '<h1>'.__("Hi there!", 'complianz-gdpr').'</h1><p>'.
                _x('Welcome to the Complianz Privacy Suite Wizard.','intro first step', 'complianz-gdpr').'</p><p>'.
                sprintf(_x('We have tried to make our Wizard as simple and fast as possible. Although these questions are all necessary, if there’s any way you think we can improve the plugin, please let us %sknow%s!','intro first step', 'complianz-gdpr'),'<a target="_blank" href="https://complianz.io/contact">', '</a>').'<br>'.
                _x('The answers in the first step of the wizard are needed to configure your documents and consent banner specifically to your needs.','intro first step', 'complianz-gdpr').'</p><p>'.
                sprintf(_x('Please note that you can always save and finish the wizard later (if you need a break), use our %sdocumentation%s for additional information or log a %ssupport ticket%s if you need our assistance.', 'intro first step', 'complianz-gdpr'),'<a target="_blank" href="https://complianz.io/documentation">', '</a>','<a target="_blank" href="https://complianz.io/support">', '</a>').'</p>',

            ),
        2 => array(
            'id' => 'visitors',
            'title' => __('Visitors', 'complianz-gdpr'),
            'intro' => _x('To determine what laws apply, we need to know where your website visitors are coming from.', 'intro company info', 'complianz-gdpr'),
        ),
        3 => array(
            'id' => 'company_info',
            'title' => __('Website information', 'complianz-gdpr'),
            'intro' => _x('We need some information to be able to generate your documents.', 'intro company info', 'complianz-gdpr'),
        ),
        4 => array(
            'region' => 'eu',
            'id' => 'dpo',
            'title' => __('Data protection officer', 'complianz-gdpr'),
            //'intro' => _x( 'In this section, you can fill in information regarding your DPO or GDPR representative. Information that will be placed in your documents.', 'intro dpo', 'complianz-gdpr'),
        ),
        5 => array(
            'id' => 'purpose',
            'title' => __('Purpose', 'complianz-gdpr'),
            //'intro' => _x( 'In this section information regarding the purpose of processing personal data is asked.  ', 'intro purpose', 'complianz-gdpr'),
        ),
        6 => array(
            'region' => 'eu',
            'id' => 'details_per_purpose_eu',
            'title' => __('Details per purpose - EU', 'complianz-gdpr'),
            //'intro' => _x( 'In this section details regarding the purpose of processing personal data is asked.', 'intro details per purpose', 'complianz-gdpr'),
        ),
        7 => array(
            'region' => 'us',
            'id' => 'details_per_purpose_us',
            'title' => __('Details per purpose - US', 'complianz-gdpr'),
            //'intro' => _x( 'In this section details regarding the purpose of processing personal data is asked.', 'intro details per purpose', 'complianz-gdpr'),
        ),
        8 => array(
            'region' => 'eu',
            'id' => 'sharing_of_data_eu',
            'title' => __('Sharing of data - EU', 'complianz-gdpr'),
            'intro' => _x('In this section, we need you to fill in information about third parties and processors you’re working with.', 'intro third parties', 'complianz-gdpr'),
        ),
        9 => array(
            'region' => 'us',
            'title' => __('Sharing of data - US', 'complianz-gdpr'),
            'intro' => _x('In this section, we need you to fill in information about third parties and processors you’re working with.', 'intro third parties', 'complianz-gdpr'),
        ),
        10 => array(
            'title' => __('Security & Consent', 'complianz-gdpr'),
            //intro' => _x('In this section, we need you to fill in information about everything regarding security of data.', 'intro security', 'complianz-gdpr'),
        ),
        11 => array(
            'region' => 'us',
            'title' => __('Financial incentives', 'complianz-gdpr'),
//            'intro' => _x('In this section, we need you to fill in information about third parties and processors you’re working with.', 'intro third parties', 'complianz-gdpr'),
        ),
        12 => array(
            'region' => 'us',
            'law' => 'COPPA',
            'title' => __('Children', 'complianz-gdpr'),
            //'intro' => _x('In this section, we need you to fill in information about third parties and processors you’re working with.', 'intro third parties', 'complianz-gdpr'),
        ),
        13 => array(
            'region' => 'us',
            'law' => 'COPPA',
            'title' => __('Children: data processing purposes', 'complianz-gdpr'),
            //'intro' => _x('In this section, we need you to fill in information about third parties and processors you’re working with.', 'intro third parties', 'complianz-gdpr'),
        ),
        14 => array('title' => __('Disclaimer', 'complianz-gdpr'),
            'intro' => _x('Answers you will give below will be used to generate your disclaimer.', 'intro disclaimer', 'complianz-gdpr'),
        ),
    )
);

$this->steps['wizard'][STEP_PLUGINS] = array("title" => __("Plugins", 'complianz-gdpr'),
    'intro' => '<h1>'._x('Next!','intro plugins', 'complianz-gdpr').'</h1>'.
        _x('Plugins and themes can add their own suggested privacy paragraphs here. You can choose to add these to your privacy statement.', 'intro plugins', 'complianz-gdpr') .
        "&nbsp" . _x('You can also use the editor to add custom text to your privacy statement if you like.', 'intro plugins', 'complianz-gdpr')
);

$this->steps['processing-eu'] = array(
    1 => array(
        "title" => __("General", 'complianz-gdpr'),
        'region' => 'eu',

    ),
    2 => array("title" => __("Processing", 'complianz-gdpr'),
        'sections' => array(
            1 => array('title' => __('Data', 'complianz-gdpr'),
                'region' => 'eu',
            ),
            2 => array('title' => __('Handling of requests', 'complianz-gdpr'),
                'region' => 'eu',
            ),
            3 => array('title' => __('Right of audit', 'complianz-gdpr'),
                'region' => 'eu',
            ),
        ),
    ),
    3 => array("title" => __("Data breach", 'complianz-gdpr'),
        'region' => 'eu',
    ),
    4 => array("title" => __("Finish", 'complianz-gdpr'),
        'region' => 'eu',
    ),
);

$this->steps['processing-us'] = array(
    1 => array(
        "title" => __("General", 'complianz-gdpr'),
    ),
    2 => array("title" => __("Processing", 'complianz-gdpr'),
        'sections' => array(
            1 => array('title' => __('Data', 'complianz-gdpr'),
                'region' => 'us',
            ),
            2 => array('title' => __('Handling of requests', 'complianz-gdpr'),
                'region' => 'us',
            ),
            3 => array('title' => __('Right of audit', 'complianz-gdpr'),
                'region' => 'us',
            ),
        ),
    ),
    3 => array("title" => __("Data breach", 'complianz-gdpr'),
        'region' => 'us',
    ),
    4 => array("title" => __("Finish", 'complianz-gdpr'),
        'region' => 'us',
    ),
);

$this->steps['dataleak-eu'] = array(
    1 => array(
        "title" => __("General", 'complianz-gdpr'),
        'region' => 'eu',
    ),
    2 => array("title" => __("Necessity", 'complianz-gdpr'),
        'sections' => array(
            1 => array('title' => __('Incident', 'complianz-gdpr'),
                'region' => 'eu',
            ),
            2 => array('title' => __('Description of incident', 'complianz-gdpr'),
                'region' => 'eu',
            ),
        )),
    3 => array("title" => __("Options", 'complianz-gdpr'),
        'region' => 'eu',
    ),
    4 => array("title" => __("Finish", 'complianz-gdpr'),
        'region' => 'eu',
    ),
);

$this->steps['dataleak-us'] = array(
    1 => array(
        "title" => __("General", 'complianz-gdpr'),
        'region' => 'us'
    ),
    2 => array("title" => __("Necessity", 'complianz-gdpr'),
        'sections' => array(
            1 => array(
                'title' => __('Incident', 'complianz-gdpr'),
                'region' => 'us',
            ),
            2 => array(
                'title' => __('Description of incident', 'complianz-gdpr'),
                'region' => 'us',
            ),
        )),
    3 => array(
        "title" => __("Options", 'complianz-gdpr'),
        'region' => 'us',
    ),
    4 => array(
        "title" => __("Details", 'complianz-gdpr'),
        'region' => 'us',
    ),
    5 => array(
        "title" => __("Finish", 'complianz-gdpr'),
        'region' => 'us',
    ),
);


