<?php
defined('ABSPATH') or die("you do not have acces to this page!");
/*
 * Unique used names must be unique for this service. It is used to link the service to the cookie.
 * used names should contain all used cookie names
 * if match should be made on partial of cookiename only, prefix with "partial_"
 *
 * */
$this->ignore_cookie_list = array('wp-saving-post', 'wp-settings', 'redux_blast', 'wordpress_test_cookie', 'auto_saved_sql');

$this->known_cookie_keys = array(

    'wordPress_metrics' => array('functional' => true,
        'used_names' => array('tk_lr', 'tk_or', 'tk_r3d'),
        'unique_used_names' => array('tk_lr', 'tk_or', 'tk_r3d'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WordPress.com",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("Collection of internal metrics for user activity, used to improve user experience.", 'complianz-gdpr'),
    ),
    'paypal' => array(
        'functional' => false,
        'used_names' => array('paypal'),
        'unique_used_names' => array('x-pp-_partial', 'pypf'),
        'privacy_policy_url' => 'https://www.paypal.com/nl/webapps/mpp/ua/privacy-full',
        'label' => "PayPal",
        'purpose' => __("Processing payments", 'complianz-gdpr'),
        'storage_duration' => __("Session", 'complianz-gdpr'),
        'description' => __("We use PayPal to process secure payments.", 'complianz-gdpr'),
    ),

    'wordpress' => array(
        'functional' => true,
        'used_names' => array('_wordpress_'),
        'unique_used_names' => array('partial_wordpress_', 'WP_DATA_USER_partial_'),
        'label' => "WordPress",
        'privacy_policy_url' => '[privacy_policy_url]',
        'purpose' => __("WordPress log in cookie", 'complianz-gdpr'),
        'storage_duration' => __("30 days", 'complianz-gdpr'),
        'description' => __("Cookie to keep you logged in", 'complianz-gdpr'),
    ),

    'googlemaps' => array(
        'functional' => false,
        'used_names' => array(),
        'unique_used_names' => array(),
        'label' => "Google Maps",
        'privacy_policy_url' => 'https://myaccount.google.com/privacy',
        'purpose' => __("Display maps on our website", 'complianz-gdpr'),
        'storage_duration' => __("30 days", 'complianz-gdpr'),
        'description' => __("We have embedded Google Maps on our website. Our website connects to the Google Maps API to display these maps. The Google Maps API requests your IP address.", 'complianz-gdpr'),
    ),

    'youtube' => array(
        'functional' => false,
        'used_names' => array(''),
        'unique_used_names' => array(''),
        'label' => "YouTube",
        'privacy_policy_url' => 'https://myaccount.google.com/privacy',
        'purpose' => __("Youtube cookie to track individual users", 'complianz-gdpr'),
        'storage_duration' => __("30 days", 'complianz-gdpr'),
        'description' => __("Cookies to track individual users.", 'complianz-gdpr'),
    ),

    'vimeo' => array(
        'functional' => false,
        'used_names' => array('vuid  ', '__utma', '__utmt_player', '__utmz', '__utmc', '__utmb'),
        'unique_used_names' => array('vuid  ', '__utma', '__utmt_player'),
        'label' => "Vimeo",
        'privacy_policy_url' => 'https://vimeo.com/privacy',
        'purpose' => __("To display and deliver videos we use Vimeo, a video sharing website. The embedded Vimeo player uses cookies to check if certain features or preferences have been selected by the user.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Cookies to track individual users.", 'complianz-gdpr'),
    ),

    'videopress' => array('functional' => false,
        'used_names' => array('_utmb', '_utmz', '_utmc', '_utma'),
        'unique_used_names' => array(),
        'privacy_policy_url' => 'https://automattic.com/privacy/',
        'label' => "VideoPress",
        'purpose' => __("Display and host video's", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Display and host videos", 'complianz-gdpr'),
    ),

    'dailymotion' => array('functional' => false,
        'used_names' => array('dmvk', 'hist', 's_vi', 'ts', 'v1st'),
        'unique_used_names' => array('dmvk', 'hist', 's_vi', 'ts', 'v1st'),
        'privacy_policy_url' => 'https://www.dailymotion.com/legal/privacy',
        'label' => "Dailymotion",
        'purpose' => __("Display and host video's", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Display and host videos", 'complianz-gdpr'),
    ),

    'google-analytics' => array(
        'functional' => false,
        'used_names' => array('_ga', '_gid', '_gat', '_gaexp', '_utm', '__utmc', 'UTMD_', '__utmv', '__utmz', '_gat_gtag_UA_ID', 'gadwp_wg_default_view', 'gadwp_wg_default_swmetric', 'gadwp_wg_default_metric', 'gadwp_wg_default_dimension', 'gadwp_ir_default_dimension', 'gadwp_ir_default_swmetric', 'gadwp_ir_default_metric'),
        'unique_used_names' => array('partial_gat_UA', '_ga', '_gaexp', '_gid', '_gat', 'partial_utm', '__utmb', '__utmc', 'UTMD__', '__utmv', '__utmz', '_gat_gtag_UA_ID', 'gadwp_wg_default_view', 'gadwp_wg_default_swmetric', 'gadwp_wg_default_metric', 'gadwp_wg_default_dimension', 'gadwp_ir_default_dimension', 'gadwp_ir_default_swmetric', 'gadwp_ir_default_metric'),
        'privacy_policy_url' => 'https://policies.google.com/privacy',
        'label' => "Google Analytics",
        'purpose' => __("Performance", 'complianz-gdpr'),
        'storage_duration' => __("From session up to  two years", 'complianz-gdpr'),
        'description' => __("We use Google Analytics, a web analytics service provided by Google. Google Analytics uses cookies that allows us to analyze the use of our website and to compile reports on website activity and internet usage.", 'complianz-gdpr'),
    ),

    'google-fonts' => array(
        'functional' => false,
        'used_names' => array('tcb_google_fonts'),
        'unique_used_names' => array('tcb_google_fonts'),
        'privacy_policy_url' => 'https://policies.google.com/privacy',
        'label' => "Google Fonts",
        'purpose' => __("Display of fonts on our website", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("We use the Google Fonts API to display fonts on our website. The Google fonts API requests your IP address when visiting our website.", 'complianz-gdpr'),
    ),

    'google-recaptcha' => array(
        'functional' => false,
        'used_names' => array(),
        'unique_used_names' => array(),
        'privacy_policy_url' => 'https://policies.google.com/privacy',
        'label' => "Google Recaptcha",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'mixpanel' => array(
        'functional' => true,
        'used_names' => array('mixpanel'),
        'unique_used_names' => array('partial_mixpanel'),
        'privacy_policy_url' => '',
        'label' => "Mixpanel",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'matomo' => array(
        'functional' => true,
        'used_names' => array('_pk_ref', '_pk_cvar', '_pk_id', '_pk_ses', '_pk_hsr', 'piwik_ignore', 'PIWIK_SESSID'),
        'unique_used_names' => array('partial__pk_', 'partial_piwik', 'PIWIK_SESSID'),
        'privacy_policy_url' => 'https://matomo.org/privacy-policy/',
        'label' => "Matomo",
        'purpose' => __("Track statistics", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Track statistics for the website", 'complianz-gdpr'),
    ),

    'php-session' => array('functional' => true,
        'used_names' => array('PHPSESSID'),
        'unique_used_names' => array('PHPSESSID'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "PHP Session ID",
        'purpose' => __("Storing user data across pages for functional purposes", 'complianz-gdpr'),
        'storage_duration' => __("Store data for users to use in the web application", 'complianz-gdpr'),
        'description' => __("Sessions are a simple way to store data for individual users against a unique session ID. Session IDs are sent to the browser via session cookies and the ID is used to retrieve existing session data", 'complianz-gdpr'),
    ),

    'stripe' => array('functional' => true,
        'used_names' => array('__stripe_mid', '__stripe_sid'),
        'unique_used_names' => array('__stripe_mid', 'partial__stripe_'),
        'privacy_policy_url' => 'https://stripe.com/privacy/',
        'label' => "Stripe payment gateway",
        'purpose' => __("Fraud prevention", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("Stripe uses cookies to prevent fraud", 'complianz-gdpr'),
    ),

    'complianz' => array('functional' => true,
        'used_names' => array('cmplz_all', 'cmplz_event_xxx', 'cmplz_stats', 'cmplz_id', 'complianz_config', 'complianz_consent_status', 'complianz_policy_id'),
        'unique_used_names' => array('cmplz_all', 'partial_cmplz_', 'complianz_config', 'cmplz_id', 'cookieconsent_status', 'complianz_consent_status', 'complianz_policy_id'),
        'privacy_policy_url' => 'https://complianz.io/privacy-statement/',
        'label' => "Complianz",
        'purpose' => __("Remember the cookie warning choice", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Complianz stores the user preferences for the cookie warning banner", 'complianz-gdpr'),
    ),

    'affiliatewp' => array(
        'functional' => true,
        'used_names' => array('affwp_ref', 'affwp_campaign', 'affwp_ref_visit_id'),
        'unique_used_names' => array('affwp_ref', 'affwp_campaign', 'affwp_ref_visit_id'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Affiliate WP",
        'purpose' => __("track users to be able to pay a commission to affiliates", 'complianz-gdpr'),
        'storage_duration' => __("30 days", 'complianz-gdpr'),
        'description' => __("Affiliate WP tracks visits from users to be able to pay the affiliate a commission for a sale by a user coming from an affiliate's website.", 'complianz-gdpr'),
    ),
    'add-this' => array('functional' => false,
        'used_names' => array('__atuvs', '__atuvc', 'psc', 'uid', 'uit', 'uvc', 'cw_id', 'loc', 'mus', 'na_id', 'na_tc', 'uvc', 'uid', 'ouid', '__atssc', '_at.cww', '_at.hist.xxxxxx', 'at-lojson-cache-ra-xxxxxx', 'at-lojson-cache-wp-xxxxxx', 'at-rand'),
        'unique_used_names' => array('__atuvs', '__atuvc', 'cw_id', 'na_id', '__atssc', '_at.cww', '_at.hist._partial', 'at-lojson-cache-ra-_partial', 'at-lojson-cache-wp-_partial', 'at-rand'),
        'privacy_policy_url' => 'https://addthis.com',
        'label' => "Add This",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),
    'aelia_currency' => array('functional' => true,
        'used_names' => array('aelia_cs_selected_currency'),
        'unique_used_names' => array('aelia_cs_selected_currency'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Currency preference",
        'purpose' => __("Currency selection storage", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Store user preference for the selected currency", 'complianz-gdpr'),
    ),

    'adyen' => array('functional' => false,
        'used_names' => array('hppsession'),
        'unique_used_names' => array('hppsession'),
        'privacy_policy_url' => 'https://adyen.com',
        'label' => "Adyen",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),
    'facebook' => array('functional' => false,
        'used_names' => array('fbm_', 'actppresence', 'sb', 'csm', 'c_user', 'frstxs', 'datr', '_fbp'),
        'unique_used_names' => array('partial_fbm_', 'actppresence', 'sb', 'csm', 'c_user', 'frstxs', 'datr', '_fbp'),
        'privacy_policy_url' => 'https://www.facebook.com/policy/cookies',
        'label' => "Facebook",
        'purpose' => __("Personalised advertisements", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Facebook uses cookies to target users with personalised advertisements", 'complianz-gdpr'),
    ),

    'instagram' => array(
        'functional' => false,
        'used_names' => array('fbm_', 'actppresence', 'sb', 'csm', 'c_user', 'frstxs', 'datr', '_fbp'),
        'unique_used_names' => array('partial_fbm_', 'actppresence', 'sb', 'csm', 'c_user', 'frstxs', 'datr', '_fbp'),
        'privacy_policy_url' => 'https://www.instagram.com/legal/cookies/',
        'label' => "Instagram",
        'purpose' => __("Personalised advertisements", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Instagram uses cookies to target users with personalised advertisements", 'complianz-gdpr'),
    ),

    'criteo' => array('functional' => false,
        'used_names' => array('hid', 'has_js', 'tk', 'uic', 'ect', 'udc', 'dis', 'udi'),
        'unique_used_names' => array('hid', 'has_js', 'tk', 'uic', 'ect', 'udc', 'dis', 'udi'),
        'privacy_policy_url' => 'https://criteo.com',
        'label' => "Criteo",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'google' => array('functional' => false,
        'used_names' => array('PREF', 'NID', 'id', '_drt_', 'HSID', 'SSIDAPISID', 'SAPISID', '__ut', 'OGPC', 'SID', 'HSID', 'SSID', 'APISID', 'SNID', 'CONSENT', '_gat_gtag_UA_xxxxxx'),
        'unique_used_names' => array('PREF', 'NID', '_drt_', 'HSID', 'SSIDAPISID', 'SAPISID', '__ut', 'OGPC', 'SID', 'HSID', 'SSID', 'APISID', 'SNID', 'CONSENT', '_gat_gtag_UA_partial'),
        'privacy_policy_url' => 'https://policies.google.com/privacy',
        'label' => "Google Ads Optimization",
        'purpose' => __("Personalised advertisements", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Google tracks users across platforms to target users with highly personalised ads", 'complianz-gdpr'),
    ),

    'cloudflare' => array('functional' => false,
        'used_names' => array('__cfduid', '_sm_au_c'),
        'unique_used_names' => array('__cfduid', '_sm_au_c'),
        'privacy_policy_url' => 'https://www.cloudflare.com/privacypolicy/',
        'label' => "CloudFlare",
        'purpose' => __("Security and webspeed by delivering content from a distributed servers.", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("The __cfduid cookie is used to identify individual clients behind a shared IP address and apply security settings on a per-client basis. ", 'complianz-gdpr'),
    ),

    'whatsapp' => array(
        'functional' => false,
        'used_names' => array(''),
        'unique_used_names' => array(''),
        'privacy_policy_url' => 'https://www.whatsapp.com/legal/#privacy-policy',
        'label' => "Whatsapp",
        'purpose' => __("WhatsApp is a cross platform service suited for smartphones and computers, protected by end to end encryption.", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("The WhatsApp cookie makes it possible to share information with visitors’ friends & others.", 'complianz-gdpr'),
    ),

    'salesforce-liveagent' => array('functional' => false,
        'used_names' => array('liveagent_oref', 'liveagent_sid', 'liveagent_vc', 'liveagent_ptid'),
        'unique_used_names' => array('partial_liveagent_'),
        'privacy_policy_url' => 'https://www.salesforce.com/company/privacy/',
        'label' => "Salesforce Liveagent",
        'purpose' => __("Real-time chat cookie", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to chat real-time with employees.", 'complianz-gdpr'),
    ),

    'livechat' => array('functional' => false,
        'used_names' => array('hide_eye_catcher', 'autoinvite_callback', '__lc.visitor_id', 'hide_eye_catcher', 'autoinvite_callback', '__lc.visitor_id', 'lc_invitation_opened', 'lc_window_state', 'lc_sso9818825', '__lc_visitor_id'),
        'unique_used_names' => array('hide_eye_catcher', 'autoinvite_callback', 'wpfront-notification-bar-landingpage', 'partial__lc.visitor_id', 'partial_lc_'),
        'privacy_policy_url' => 'https://www.livechat.com/privacy/',
        'label' => "Livechat",
        'purpose' => __("Real-time chat cookie", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Live Chat is a chat system which can help users with questions regarding our products and website.", 'complianz-gdpr'),
    ),

    'doubleclick' => array('functional' => false,
        'used_names' => array('idIDE', 'test_cookie', 'id', '___gads', '_drt_', 'DSID', 'IDE', 'ar_v4'),
        'unique_used_names' => array('idIDE', 'DSID', 'ar_v4'),
        'privacy_policy_url' => 'https://policies.google.com/privacy',
        'label' => "DoubleClick",
        'purpose' => __("Advertisement", 'complianz-gdpr'),
        'storage_duration' => __("2 years", 'complianz-gdpr'),
        'description' => __("This cookie from Doubleclick.net helps us to understand the products you are viewing. We can show you relevant advertisements on our (partner) sites. We can also keep track of how many times you've seen an ad, whether you click on an ad and whether you place an order if you clicked on an ad.", 'complianz-gdpr'),
    ),

    'optimizely' => array('functional' => false,
        'used_names' => array('end_user_id', 'cdnoptimizely', 'ab_optimizely', 'optimizelyPendingLogEvents', 'optimizelyEndUserId', 'optimizelySegments', 'optimizelyBuckets', 'optimizelyPPID'),
        'unique_used_names' => array('cdnoptimizely', 'ab_optimizely'),
        'privacy_policy_url' => 'https://www.optimizely.com/privacy/',
        'label' => "Optimizely",
        'purpose' => __("Performance", 'complianz-gdpr'),
        'storage_duration' => __("From session up to ten years", 'complianz-gdpr'),
        'description' => __("Optimizely is a service that enables us to test the effectiveness of different versions of our website and/or content (A/B-testing). The cookies which are set may record your surf and click behavior and other activity.", 'complianz-gdpr'),
    ),

    'hotjar' => array('functional' => false,
        'used_names' => array('_hjUserId', '_hjIncludedInSample', '_hjMinimizedTestersWidgets', '_hjClosedSurveyInvites', '_hjDonePolls', '_hjMinimizedPolls', '_hjDoneTestersWidgets'),
        'unique_used_names' => array('_hjUserId', '_hjIncludedInSample', '_hjMinimizedTestersWidgets', '_hjClosedSurveyInvites', '_hjDonePolls', '_hjMinimizedPolls', '_hjDoneTestersWidgets'),
        'privacy_policy_url' => '',
        'label' => "Hotjar",
        'purpose' => __("Performance", 'complianz-gdpr'),
        'storage_duration' => __("session", 'complianz-gdpr'),
        'description' => __("On this website, we use Analytics and services from  Hotjar, a company based in Malta. HotJar helps us gain insight into how our website is used. We place this cookie ourselves.", 'complianz-gdpr'),
    ),

    'visual-website-optimizer' => array('functional' => false,
        'used_names' => array('_vis_opt_out', '_vis_opt_s', 'partial_vis_opt_exp', '_vis_opt_test_cookie', '_vis_opt_exp_[experiment_id]_goal_[goal_id]', 'partial_vwo_', '_vwo_uuid_v2'),
        'unique_used_names' => array('_vwo_uuid_v2'),
        'privacy_policy_url' => '',
        'label' => "Visual Website Optimizer",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'snoobi' => array('functional' => false,
        'used_names' => array('Snoobisession_adcalls_nl', 'SnoobiID', 'Snoop_testi'),
        'unique_used_names' => array('Snoobisession_adcalls_nl', 'SnoobiID', 'Snoop_testi'),
        'privacy_policy_url' => '',
        'label' => "Snoobi",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'adcalls' => array('functional' => false,
        'used_names' => array('acalltracker', 'acalltrackersession'),
        'unique_used_names' => array('acalltracker', 'acalltrackersession'),
        'privacy_policy_url' => '',
        'label' => "Adcalls",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'call-tracking-metrics' => array('functional' => false,
        'used_names' => array('ctm'),
        'unique_used_names' => array('ctm'),
        'privacy_policy_url' => '',
        'label' => "Call Tracking Metrics",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'tealium' => array('functional' => false,
        'used_names' => array('utag_main'),
        'unique_used_names' => array('utag_main'),
        'privacy_policy_url' => '',
        'label' => "Tealium",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'adkernel' => array('functional' => false,
        'used_names' => array('ADK_EX_15', 'ADKUID'),
        'unique_used_names' => array('ADK_EX_15', 'ADKUID'),
        'privacy_policy_url' => '',
        'label' => "Adkernel",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'gigya-com' => array('functional' => false,
        'used_names' => array('gig_hasGmid'),
        'unique_used_names' => array('gig_hasGmid'),
        'privacy_policy_url' => '',
        'label' => "Gigya.com",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'casalemedia-com' => array('functional' => false,
        'used_names' => array('CMDD', 'CMRUM3', 'CMSC'),
        'unique_used_names' => array('CMDD', 'CMRUM3', 'CMSC'),
        'privacy_policy_url' => '',
        'label' => "casalemedia.com",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'demdex-net' => array('functional' => false,
        'used_names' => array('dextp'),
        'unique_used_names' => array('dextp'),
        'privacy_policy_url' => '',
        'label' => "demdex.net",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),
    'everesttech-net' => array(
        'functional' => false,
        'used_names' => array('everest_g_v2', 'everest_session_v2', 'ev_sync_dd'),
        'unique_used_names' => array('everest_g_v2', 'everest_session_v2', 'ev_sync_dd'),
        'privacy_policy_url' => '',
        'label' => "everesttech.net",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'mathtag-com' => array('functional' => false,
        'used_names' => array('uuid', 'uuidc', 'HRL8'),
        'unique_used_names' => array('HRL8'),
        'privacy_policy_url' => '',
        'label' => "mathtag.com",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),
    'zopim' => array('functional' => false,
        'used_names' => array('__zlcmid', '__zprivacy', '__zlcstore'),
        'unique_used_names' => array('__zlcmid', '__zprivacy', '__zlcprivacy', '__zlcstore'),
        'privacy_policy_url' => 'https://www.zendesk.com/company/customers-partners/privacy-policy/',
        'label' => "Zopim",
        'purpose' => __("Security", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("to identify trusted webtraffic", 'complianz-gdpr'),
    ),

    'linkedin' => array('functional' => false,
        'used_names' => array('X-LI-IDC'),
        'unique_used_names' => array('X-LI-IDC'),
        'privacy_policy_url' => 'https://www.linkedin.com/legal/privacy-policy',
        'label' => "Linkedin",
        'purpose' => __("Linkedin places cookies to track users", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'twitter' => array('functional' => false,
        'used_names' => array('metrics_token'),
        'unique_used_names' => array('metrics_token'),
        'privacy_policy_url' => 'https://twitter.com/en/privacy',
        'label' => "Twitter",
        'purpose' => __("Target users with personalised ads", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Twitter tracks users to target them with personalised ads", 'complianz-gdpr'),
    ),

    'sharethis' => array('functional' => false,
        'used_names' => array('__stid', 'uset', '_utmb', '_utmz', '_utmc', '_utma', 'optimizelyPendingLogEvents', 'optimizelyBuckets', 'optimizelySegments', 'optimizelyEndUserId', '__uset', 'stdlxmap', '_stacxiommap', '_stamap', '_stgmap', '_stid', 'UID', 'UIDR'),
        'unique_used_names' => array('__sharethis_cookie_test__'),
        'privacy_policy_url' => '',
        'label' => "Share this",
        'purpose' => __("Target users with personalised ads", 'complianz-gdpr'),
        'storage_duration' => __("1 year", 'complianz-gdpr'),
        'description' => __("Share this gathers information on users to target them with personalised ads", 'complianz-gdpr'),
    ),

    'jetpack' => array('functional' => false,
        'used_names' => array('tk_tc', 'tk_qs', 'tk_ai', 'jetpackState'),
        'unique_used_names' => array('tk_tc', 'tk_qs', 'tk_ai', 'jetpackState'),
        'privacy_policy_url' => '',
        'label' => "JetPack",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'newrelic' => array('functional' => false,
        'used_names' => array('NRMLID', 'NRMPID', 'NRREFL', 'NRREFP', 'optimizelyEndUserId', 'optimizelySegments', 'optimizelyBuckets', '__qca', '__ar_v4', '_biz_uid', '_biz_sid', '_biz_nA', '_biz_pendingA', '_ceg.s', '_ceg.u', 'ajs_user_id', 'ajs_group_id', 'ajs_anonymous_id', '__distillery', '_mkto_trk', 'ei_client_id', 'wcsid', 'hblid', '_oklv', '_okdetect', 'olfsk', '_okbk', '_ok', 'optimizelyPendingLogEvents', '_gal'),
        'unique_used_names' => array('NRMLID', 'NRMPID', 'NRREFL', 'NRREFP'),
        'privacy_policy_url' => '',
        'label' => "Newrelic",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'slimstat' => array('functional' => false,
        'used_names' => array('slimstat_tracking_code'),
        'unique_used_names' => array('slimstat_tracking_code'),
        'privacy_policy_url' => '',
        'label' => "Slimstat Tracking Code",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),
    'wpdiscuz_last_visit' => array('functional' => false,
        'used_names' => array('wpdiscuz_last_visit'),
        'unique_used_names' => array('wpdiscuz_last_visit'),
        'privacy_policy_url' => '',
        'label' => "WP Discuz",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("", 'complianz-gdpr'),
    ),

    'wpml' => array('functional' => true,
        'used_names' => array('wpml_browser_redirect_test', '_icl_current_language', '_icl_visitor_lang_js', '_icl_current_admin_language_',),
        'unique_used_names' => array('partial_wpml', 'partial__icl_', '_icl_visitor_lang_js'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WPML",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("WPML is a cookie used to provide different languages for an user. Also it checks which language a user is using.", 'complianz-gdpr'),
    ),


    'heap' => array('functional' => true,
        'used_names' => array('_hp2_ses'),
        'unique_used_names' => array('partial_hp2'),
        'privacy_policy_url' => 'https://heapanalytics.com/privacy',
        'label' => "Heap Analytics",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("The Heap cookie captures every user interaction from web, mobile, and cloud services.", 'complianz-gdpr'),
    ),

    'wordfence' => array(
        'functional' => true,
        'used_names' => array('wfvt_xxxxxx', 'wordfence_verifiedHuman', 'wfwaf-authcookie', 'wfwaf-authcookie-partial_', 'wf-scan-issue-expanded-1'),
        'unique_used_names' => array('wfvt_partial_', 'wordfence_verifiedHuman', 'wfwaf-authcookie', 'wfwaf-authcookie-partial_', 'wf-scan-issue-expanded-1'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WordFence",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("Tracks a user duration so that so that the page views can be grouped together.", 'complianz-gdpr'),
    ),

    'mouseflow' => array('functional' => true,
        'used_names' => array('xxxxxx_mf'),
        'unique_used_names' => array('partial_mf'),
        'privacy_policy_url' => 'https://mouseflow.com/privacy/',
        'label' => "MouseFlow",
        'purpose' => __("", 'complianz-gdpr'),
        'storage_duration' => __("", 'complianz-gdpr'),
        'description' => __("A cookie for checking if the user is new or returning.", 'complianz-gdpr'),
    ),

    'sumo' => array('functional' => true,
        'used_names' => array('__smVID', '__smToken', 'partial_smSessionId', '__smScrollBoxShown', '__smListBuilderShown'),
        'unique_used_names' => array('__smVID', '__smToken', 'partial_smSessionId', '__smScrollBoxShown', '__smListBuilderShown'),
        'privacy_policy_url' => 'https://help.sumo.com/hc/en-us/articles/218958727-Privacy-Policy',
        'label' => "Sumo",
        'purpose' => __("Offer sharing options in a website", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Sumo uses cookies to control many different things in users browsers. These cookies control everything from determining if a visitor is opted-out of a certain popup to telling Sumo whether or not to display a Bar. ", 'complianz-gdpr'),
    ),
    'googleanalyticsdashboard' => array('functional' => true,
        'used_names' => array('gadwp_wg_default_metric', 'gadwp_wg_default_dimension', 'gadwp_wg_default_swmetric'),
        'unique_used_names' => array('gadwp_wg_default_metric', 'gadwp_wg_default_dimension', 'gadwp_wg_default_swmetric'),
        'privacy_policy_url' => 'https://exactmetrics.com/privacy-policy/',
        'label' => "GA - Dashboard",
        'purpose' => __("This cookie tracks visitor behavior, visited pages etc. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("We use Google Analytics via a Dashboard: a web analytics service provided by Google. Google Analytics uses cookies that allows us to analyze the use of our website and to compile reports on website activity and internet usage. ", 'complianz-gdpr'),
    ),
    'siteorigin' => array(
        'functional' => true,
        'used_names' => array('siteorigin_panels_live_editor'),
        'unique_used_names' => array('siteorigin_panels_live_editor'),
        'privacy_policy_url' => 'https://siteorigin.com',
        'label' => "Site Origin",
        'purpose' => __("This cookie makes it possible to make live changes to an online environment. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible for us to make live changes to the website via a simple Page Builder plugin.", 'complianz-gdpr'),
    ),
    'Page-ID' => array(
        'functional' => true,
        'used_names' => array('page_id'),
        'unique_used_names' => array('page_id'),
        'privacy_policy_url' => '',
        'label' => "Page ID",
        'purpose' => __("This cookie makes it possible to label several pages. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible for us to label several pages in our website.", 'complianz-gdpr'),
    ),

    'Preview' => array(
        'functional' => true,
        'used_names' => array('preview'),
        'unique_used_names' => array('preview'),
        'privacy_policy_url' => '',
        'label' => "Preview",
        'purpose' => __("This cookie makes it possible to preview several pages for admins. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible for us preview several pages.", 'complianz-gdpr'),
    ),

    'Viewed-Cookie-Policy' => array(
        'functional' => true,
        'used_names' => array('viewed_cookie_policy'),
        'unique_used_names' => array('viewed_cookie_policy'),
        'privacy_policy_url' => '',
        'label' => "Preview",
        'purpose' => __("This cookie makes it possible for us to keep track on who viewed the cookie policy. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible for us to keep track on who viewed the cookie policy.", 'complianz-gdpr'),
    ),

    'Customize' => array(
        'functional' => true,
        'used_names' => array('customize_changeset_uuid', 'customize_theme', 'customize_messenger_channel', 'customize_autosaved'),
        'unique_used_names' => array('customize_changeset_uuid', 'customize_theme', 'customize_messenger_channel', 'customize_autosaved'),
        'privacy_policy_url' => '',
        'label' => "Customize",
        'purpose' => __("This cookie makes it possible for us to customize themes, messenger channels etc. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible for us to customize themes, messenger channels etc.", 'complianz-gdpr'),
    ),

    'Easy-Digital-Downloads' => array(
        'functional' => true,
        'used_names' => array('edd_remove_from_cart_nonce'),
        'unique_used_names' => array('edd_remove_from_cart_nonce'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Remove item from cart",
        'purpose' => __("This cookie makes it possible to remove an article from your cart.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to remove an article from your cart.", 'complianz-gdpr'),
    ),

    'WF-Waf' => array('functional' => true,
        'used_names' => array('wfwaf-authcookie-id'),
        'unique_used_names' => array('wfwaf-authcookie-id'),
        'privacy_policy_url' => '',
        'label' => "WFWaf",
        'purpose' => __("This cookie makes it possible to save choices during your visit.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to save choices during your visit.", 'complianz-gdpr'),
    ),

    '1P-Google' => array('functional' => true,
        'used_names' => array('1P_JAR'),
        'unique_used_names' => array('1P_JAR'),
        'privacy_policy_url' => 'https://myaccount.google.com/privacy',
        'label' => "1P Google",
        'purpose' => __("This cookie makes it possible to show advertisements based on your search behavior on Google.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to show advertisements based on your search behavior on Google.", 'complianz-gdpr'),
    ),

    'MailMunch' => array('marketing' => true,
        'used_names' => array('mailmunch_second_pageview'),
        'unique_used_names' => array('mailmunch_second_pageview'),
        'privacy_policy_url' => 'https://legal.mailmunch.com/privacy/',
        'label' => "MailMunch",
        'purpose' => __("This cookie is used to manage subscription services to mailing lists of blogs.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to manage subscription services to mailing lists of blogs.", 'complianz-gdpr'),
    ),

    'MailChimp' => array('marketing' => true,
        'used_names' => array('mailchimp_landing_site', 'mailchimp.cart.current_email', 'mailchimp.cart.previous_email', 'mailchimp_user_email', 'mailchimp_user_previous_email', 'mailchimp_cart_current_email', 'mailchimp_cart_previous_email'),
        'unique_used_names' => array('mailchimp_landing_site', 'mailchimp.cart.current_email', 'mailchimp.cart.previous_email', 'mailchimp_user_email', 'mailchimp_user_previous_email', 'mailchimp_cart_current_email', 'mailchimp_cart_previous_email'),
        'privacy_policy_url' => 'https://mailchimp.com/legal/privacy/',
        'label' => "MailChimp",
        'purpose' => __("This cookie is used to keep track of newsletter sign ups.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("These cookies are used to keep track of newsletter sign ups and client emails at checkout, Mailchimp utilises cookies to store information captured from user input for remarketing purpose.", 'complianz-gdpr'),
    ),

    'Clicky-Web-Analytics' => array('functional' => true,
        'used_names' => array('_jsuid'),
        'unique_used_names' => array('_jsuid'),
        'privacy_policy_url' => 'https://www.optimizely.com/privacy/',
        'label' => "Clicky",
        'purpose' => __("This cookie is used to identify new or unique visitors.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to identify new or unique visitors.", 'complianz-gdpr'),
    ),

    'Hubspot' => array('functional' => true,
        'used_names' => array('hubspotutk', '__hssrc', '__hssc', '__hstc', 'hs-messages-is-open', '__hs_opt_out', 'messagesUtk'),
        'unique_used_names' => array('hubspotutk', '__hssrc', '__hssc', '__hstc', 'hs-messages-is-open', '__hs_opt_out', 'messagesUtk'),
        'privacy_policy_url' => 'https://legal.hubspot.com/privacy-policy',
        'label' => "HubSpot",
        'purpose' => __("This cookie is used to track visitors, keep track of sessions and recognize visitors.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to track visitors, keep track of sessions and recognize visitors.", 'complianz-gdpr'),
    ),

    'Fullstory' => array('functional' => true,
        'used_names' => array('fs_uid'),
        'unique_used_names' => array('fsuid'),
        'privacy_policy_url' => 'https://www.fullstory.com/legal/privacy/',
        'label' => "FullStory",
        'purpose' => __("This cookie is used by FullStory to track sessions.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by FullStory to track sessions.", 'complianz-gdpr'),
    ),

    'Quantcast' => array('marketing' => true,
        'used_names' => array('qca'),
        'unique_used_names' => array('qca'),
        'privacy_policy_url' => 'https://www.quantcast.com/privacy/',
        'label' => "QuantCast",
        'purpose' => __("This cookie is used by Quantcast to segmentate audiences and do targeted advertising.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Quantcast to segmentate audiences and do targeted advertising.", 'complianz-gdpr'),
    ),

    'Metorik-Sourcebuster' => array('functional' => true,
        'used_names' => array('metorik_http_referer', '	sbjs_current', 'sbjs_current_add', 'sbjs_first', 'sbjs_first_add', 'sbjs_migrations', 'sbjs_session', 'sbjs_udata'),
        'unique_used_names' => array('metorik_http_referer', '	sbjs_current', 'sbjs_current_add', 'sbjs_first', 'sbjs_first_add', 'sbjs_migrations', 'sbjs_session', 'sbjs_udata'),
        'privacy_policy_url' => 'https://www.quantcast.com/privacy/',
        'label' => "Metorik",
        'purpose' => __("This cookie is used to deliver a shopping cart and make it work, and also takes care of product statistics.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to deliver a shopping cart and make it work, and also takes care of product statistics.", 'complianz-gdpr'),
    ),

    'WP-Engine' => array('functional' => true,
        'used_names' => array('wpe_test_group', 'wpe-auth'),
        'unique_used_names' => array('wpe_test_group', 'wpe-auth'),
        'privacy_policy_url' => 'https://wpengine.com/legal/privacy/',
        'label' => "WP-Engine",
        'purpose' => __("This cookie is used to analyse the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to analyse the website.", 'complianz-gdpr'),
    ),

    'XSRF-TOKEN' => array('functional' => true,
        'used_names' => array('XSRF-TOKEN'),
        'unique_used_names' => array('XSRF-TOKEN'),
        'privacy_policy_url' => '/',
        'label' => "XSRF-TOKEN",
        'purpose' => __("This cookie is written to help with site security in preventing Cross-Site Request Forgery attacks.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is written to help with site security in preventing Cross-Site Request Forgery attacks.", 'complianz-gdpr'),
    ),

    'WooCommerce' => array('functional' => true,
        'used_names' => array('wc_cart_hash_xxxxxx', 'wpwoocommerce_session_xxxxxx', 'woocommerce_recently_viewed', 'woocommerce_items_in_cart', 'woocommerce_cart_hash', 'wp_woocommerce_session_xxxxxx'),
        'unique_used_names' => array('wc_partial_', 'wpwoocommerce_session_partial_', 'woocommerce_recently_viewed', 'woocommerce_items_in_cart', 'woocommerce_cart_hash', 'wp_woocommerce_session_partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WooCommerce",
        'purpose' => __("This cookie is placed to keep track of sales, shopping cart items.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is placed to keep track of sales, shopping cart items.", 'complianz-gdpr'),
    ),

    'WPForms' => array('functional' => true,
        'used_names' => array('_wpfuuid', 'wpforms_field_group_payment'),
        'unique_used_names' => array('_wpfuuid', 'wpforms_field_group_payment'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WPForms",
        'purpose' => __("This cookie is placed to place contact forms and follow submissions.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is placed to place contact forms and follow submissions.", 'complianz-gdpr'),
    ),

    'Beeketing' => array('functional' => true,
        'used_names' => array('_beeketing_cart_token', 'beeketing_show_review_request', 'beeketing_show_cross_sell', 'bk_show_tab_freeApps', 'bk_abtest_last_changed_time', 'bk_identify', 'bk_cart', 'bk_gs', 'bk_gs_time', 'beeketing_show_first_time', 'beeketing_activated_plugin', 'beeketing_hide_review_request', 'beeketing_cart_fragments_init', 'beeketing_hide_setup_notice'),
        'unique_used_names' => array('_beeketing_cart_token', 'beeketing_show_review_request', 'beeketing_show_cross_sell', 'bk_show_tab_freeApps', 'bk_abtest_last_changed_time', 'bk_identify', 'bk_cart', 'bk_gs', 'bk_gs_time', 'beeketing_show_first_time', 'beeketing_activated_plugin', 'beeketing_hide_review_request', 'beeketing_cart_fragments_init', 'beeketing_hide_setup_notice'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Beeketing",
        'purpose' => __("Beeketing uses cookies to enhance our users' and customers' experience on the internet.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Beeketing and is used to show more benefits of the products on the website. Also shows realtime sales, countdown clock for auctions and more.", 'complianz-gdpr'),
    ),

    'WPSmush' => array('functional' => true,
        'used_names' => array('_drip_client_6994213'),
        'unique_used_names' => array('_drip_client_6994213'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WPSmush",
        'purpose' => __("WPSmush uses cookies to compress images to be able to have lower loading time.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("WPSmush uses cookies to compress images to be able to have lower loading time.", 'complianz-gdpr'),
    ),

    'Cookie_Consent_Cookiebot' => array('functional' => true,
        'used_names' => array('CookieConsent'),
        'unique_used_names' => array('CookieConsent'),
        'privacy_policy_url' => 'https://www.cookiebot.com/en/privacy-policy/',
        'label' => "CookieBot",
        'purpose' => __("CookieBot uses cookies to be able to set up a cookie banner and block & place cookies.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("CookieBot uses cookies to be able to set up a cookie banner and block & place cookies.", 'complianz-gdpr'),
    ),

    'Pop_Up_Maker' => array('marketing' => true,
        'used_names' => array('pum-partial_'),
        'unique_used_names' => array('pum-partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Pop Up Maker",
        'purpose' => __("This is a WordPress plugin that is able to show popups while browsing on a website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This is a WordPress plugin that is able to show popups while browsing on a website.", 'complianz-gdpr'),
    ),
    'fomify' => array('marketing' => true,
        'used_names' => array('ibx_wpfomo_ip'),
        'unique_used_names' => array('ibx_wpfomo_ip'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Fomify",
        'purpose' => __("This is a WordPress plugin that is able to show popups containing information of recent purchases.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This is a WordPress plugin that is able to show popups containing information of recent purchases.", 'complianz-gdpr'),
    ),

    'Tawk' => array('marketing' => true,
        'used_names' => array('__tawkuuid', 'TawkConnectionTime', 'tawkUUID', 'tawk-partial_', 'twk-partial_', 'TawkWindowName'),
        'unique_used_names' => array('__tawkuuid', 'TawkConnectionTime', 'tawkUUID', 'tawk-partial_', 'twk-partial_', 'TawkWindowName'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Tawk",
        'purpose' => __("Tawk is a chatservice. It uses cookies to be able to assist you at any time.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Tawk is a chatservice. It uses cookies to be able to assist you at any time.", 'complianz-gdpr'),
    ),

    'Polylang' => array('functional' => true,
        'used_names' => array('pll_language'),
        'unique_used_names' => array('pll_language'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Polylang",
        'purpose' => __("This cookie determines which language should be used on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie determines which language should be used on the website.", 'complianz-gdpr'),
    ),

    'EU_Cookie_Law' => array('functional' => true,
        'used_names' => array('eucookielaw'),
        'unique_used_names' => array('eucookielaw'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "EU Cookie Law",
        'purpose' => __("The EU Cookie Law plugin is a plugin that places cookies to be able to show a cookie banner.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("The EU Cookie Law plugin is a plugin that places cookies to be able to show a cookie banner.", 'complianz-gdpr'),
    ),

    'GDPR_Plugin' => array(
        'functional' => true,
        'used_names' => array('gdpr', 'gdpr[consent_types]', 'gdpr[allowed_cookies]', 'gdpr[privacy_bar]', 'cookie_notice_accepted', 'cookies_accepted', 'gdpr[privacy_bar', 'gdpr[allowed_cookies', 'gdpr[consent_types'),
        'unique_used_names' => array('gdpr', 'gdpr[consent_types]', 'gdpr[allowed_cookies]', 'gdpr[privacy_bar]', 'cookie_notice_accepted', 'cookies_accepted'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "GDPR Plugin",
        'purpose' => __("The GDPR plugin is a plugin that places cookies to help DPOs in making a website compliant.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("The GDPR plugin is a plugin that places cookies to help DPOs in making a website compliant.", 'complianz-gdpr'),
    ),
    'ThriveLeads' => array('marketing' => true,
        'used_names' => array('tl_conversion', 'tl-conv-partial_'),
        'unique_used_names' => array('tl_conversion', 'tl-conv-partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Thrive Leads",
        'purpose' => __("This plugin assists website owners in getting more conversions via email marketing.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This plugin assists website owners in getting more conversions via email marketing.", 'complianz-gdpr'),
    ),

    'Contact_Form_plugin' => array('functional' => true,
        'used_names' => array('vchideactivationmsg_vc11'),
        'unique_used_names' => array('vchideactivationmsg_vc11'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Contact Form",
        'purpose' => __("This cookie aids in sending messages via the Contact Form plugin.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie aids in sending messages via the Contact Form plugin.", 'complianz-gdpr'),
    ),

    '240Plan' => array('functional' => true,
        'used_names' => array('240plan', '240planBAK'),
        'unique_used_names' => array('240plan', '240planBAK'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "240 Plan",
        'purpose' => __("This cookie aids in being able to fall back on the server which hosts this website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie aids in being able to fall back on the server which hosts this website.", 'complianz-gdpr'),
    ),

    'ithemes-Security' => array('functional' => true,
        'used_names' => array('itsec-hb-login-partial_'),
        'unique_used_names' => array('itsec-hb-login-partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "IThemes Security",
        'purpose' => __("This cookie is set by iThemes Security Plugin to change the backend login URL for additional security.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is set by iThemes Security Plugin to change the backend login URL for additional security.", 'complianz-gdpr'),
    ),

    'Yith_WooCommerce' => array('functional' => true,
        'used_names' => array('yith_wcwl_products'),
        'unique_used_names' => array('yith_wcwl_products'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Yith",
        'purpose' => __("This cookie is set by Yith WooCommerce and makes it possible for visitors to make their own wishlist.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is set by Yith WooCommerce and makes it possible for visitors to make their own wishlist.", 'complianz-gdpr'),
    ),

    'SlideCheck' => array('functional' => true,
        'used_names' => array('wpgb_visit_last-partial_', 'wpgb_visit_last_php-partial_'),
        'unique_used_names' => array('wpgb_visit_last-partial_', 'wpgb_visit_last_php-partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "SlideCheck",
        'purpose' => __("This cookie is set to be able to deliver slide shows in headers and other images.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is set to be able to deliver slide shows in headers and other images.", 'complianz-gdpr'),
    ),

    'Go_Daddy' => array('functional' => true,
        'used_names' => array('_tccl_visitor', '_tccl_visit'),
        'unique_used_names' => array('_tccl_visitor', '_tccl_visit'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Go Daddy",
        'purpose' => __("This cookie is a persistent Web Hosting Provider (GoDaddy) cookie to monitor website usage performance.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is a persistent Web Hosting Provider (GoDaddy) cookie to monitor website usage performance.", 'complianz-gdpr'),
    ),

    'SPU_Closing' => array('functional' => true,
        'used_names' => array('spu_closing', 'spu_closing-xxxxxx'),
        'unique_used_names' => array('spu_closing', 'spu_closing-partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "SPU Closing",
        'purpose' => __("This cookie is used to determine whether someone closes the web browser.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to determine whether someone closes the web browser.", 'complianz-gdpr'),
    ),

    'Smartlook' => array('functional' => true,
        'used_names' => array('SL_C_xxxxxx_SID', 'SL_C_xxxxxx_KEY', 'SL_C_xxxxxx_SID', 'SL_C_xxxxxx_VID', 'AWSELB'),
        'unique_used_names' => array('SL_C_partial_SID', 'SL_C_partial_KEY', 'SL_C_partial_SID', 'SL_C_partial_VID', 'AWSELB'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Smartlook",
        'purpose' => __("This cookie is used as a service to track visitor behavior on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used as a service to track visitor behavior on the website.", 'complianz-gdpr'),
    ),

    'BST_Systemtechnik' => array('functional' => true,
        'used_names' => array('bst_accepted'),
        'unique_used_names' => array('bst_accepted'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "BST Systemtechnik",
        'purpose' => __("This cookie is used to place a cookie banner.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to place a cookie banner.", 'complianz-gdpr'),
    ),

    'SmartSupp' => array('marketing' => true,
        'used_names' => array('ssupp.visits', 'ssupp.chatid', 'ssupp_vid', 'ssupp_visits', 'ssupp_chatid'),
        'unique_used_names' => array('ssupp.visits', 'ssupp.chatid', 'ssupp_vid', 'ssupp_visits', 'ssupp_chatid'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "SmartSupp",
        'purpose' => __("This cookie is used by Livechat and enables us to provide support to website visitors.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Livechat and enables us to provide support to website visitors.", 'complianz-gdpr'),
    ),

    'Redux' => array('functional' => true,
        'used_names' => array('redux_current_tab', 'redux_current_tab_get '),
        'unique_used_names' => array('redux_current_tab', 'redux_current_tab_get §'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Redux",
        'purpose' => __("Cookie to improve the user movement in the site. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Cookie to improve the user movement in the site.", 'complianz-gdpr'),
    ),
    'WP_Globus' => array('functional' => true,
        'used_names' => array('wpglobus-language-old', 'wpglobus-language'),
        'unique_used_names' => array('wpglobus-language-old', 'wpglobus-language'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP Globus",
        'purpose' => __("This is a cookie which makes it possible to view multiple languages on the website. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This is a cookie which makes it possible to view multiple languages on the website.", 'complianz-gdpr'),
    ),
    'Paid_Membership_Pro' => array('functional' => true,
        'used_names' => array('pmpro_visit'),
        'unique_used_names' => array('pmpro_visit'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Paid Membership Pro",
        'purpose' => __("This is a cookie makes it possible to subscribe to certain services with recurring payments. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This is a cookie makes it possible to subscribe to certain services with recurring payments.", 'complianz-gdpr'),
    ),
    'Active_Campaign' => array('marketing' => true,
        'used_names' => array('ac_enable_tracking'),
        'unique_used_names' => array('ac_enable_tracking'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Active Campaign",
        'purpose' => __("This is a cookie makes it possible to subscribe to certain services with recurring payments. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("ActiveCampaign stores the data collected on its servers which is used to personalize our communication, improve interaction, provide statistics on website usage, and improve our products, services and offers.", 'complianz-gdpr'),
    ),
    'LiteSpeed' => array('functional' => true,
        'used_names' => array('_lscache_vary'),
        'unique_used_names' => array('_lscache_vary'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "LiteSpeed",
        'purpose' => __("This is a cookie that stores users' login status and what the role of the current user is.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This is a cookie that stores users' login status and what the role of the current user is.", 'complianz-gdpr'),
    ),
    'Inspectlet' => array('functional' => true,
        'used_names' => array('__insp_norec_sess, __insp_nv, __insp_ref, __insp_slim, __insp_targetlpt, __insp _targlpu, __insp_wid'),
        'unique_used_names' => array('__insp_norec_sess, __insp_nv, __insp_ref, __insp_slim, __insp_targetlpt, __insp _targlpu, __insp_wid'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Inspectlet",
        'purpose' => __("These cookies are set by Inspectlet. These cookies are used to collect information about how visitors use our Website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("These cookies are set by Inspectlet. These cookies are used to collect information about how visitors use our Website.", 'complianz-gdpr'),
    ),

    'WordPress_API_Schema' => array('functional' => true,
        'used_names' => array('wp-api-schema-model', 'wp-api-schema-model_xxxxxx'),
        'unique_used_names' => array('wp-api-schema-model', 'wp-api-schema-model_partial'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP_API Schema",
        'purpose' => __("This cookie makes it possible to provide Schema JSON-LD / SEO markup for articles, events, local business, products, recipes, reviews and many more.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to provide Schema JSON-LD / SEO markup for articles, events, local business, products, recipes, reviews and many more.", 'complianz-gdpr'),
    ),

    'Advanced_Ads' => array('marketing' => true,
        'used_names' => array('advanced_ads_browser_width'),
        'unique_used_names' => array('advanced_ads_browser_width'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Advanced Ads",
        'purpose' => __("This cookie makes it possible to implement multiple advertisements om multiple pages on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to implement multiple advertisements om multiple pages on the website.", 'complianz-gdpr'),
    ),
    'Google_Captcha_Plugin' => array('functional' => true,
        'used_names' => array('gglcptch_hide_banner_on_plugin_page'),
        'unique_used_names' => array('gglcptch_hide_banner_on_plugin_page'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Google Captcha",
        'purpose' => __("This cookie makes it possible show Google Captcha's in a contactform, to determine whether you are a real user or a bot.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible show Google Captcha's in a contactform, to determine whether you are a real user or a bot.", 'complianz-gdpr'),
    ),
    'GDPR_Compliance_Popup' => array('functional' => true,
        'used_names' => array('moove_gdpr_popup'),
        'unique_used_names' => array('moove_gdpr_popup'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP_API Schema",
        'purpose' => __("This cookie makes it possible to show a cookie banner.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to show a cookie banner.", 'complianz-gdpr'),
    ),
    'Plugin_Organizer' => array('functional' => true,
        'used_names' => array('po_assigned_roles', 'po_assigned_roles'),
        'unique_used_names' => array('po_assigned_roles', 'po_assigned_roles'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Plugin Organizer",
        'purpose' => __("This cookie makes it possible to select which plugins will be loaded first.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to select which plugins will be loaded first.", 'complianz-gdpr'),
    ),
    'Custom_Field_Bulk_Editor' => array('functional' => true,
        'used_names' => array('bulkPage', 'bulkTime'),
        'unique_used_names' => array('bulkPage', 'bulkTime'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Custom Field Bulk Editor",
        'purpose' => __("This cookie is necessary for countdown timers.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is necessary for countdown timers.", 'complianz-gdpr'),
    ),
    'OptInMonster' => array(
        'functional' => false,
        'used_names' => array('_omappvp', '_omappvs'),
        'unique_used_names' => array('_omappvp', '_omappvs'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "OptInMonster",
        'purpose' => __("This cookie determines whether a visitor is a returning visitor or a new one.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie determines whether a visitor is a returning visitor or a new one.", 'complianz-gdpr'),
    ),
    'Force.com' => array(
        'functional' => false,
        'used_names' => array('BrowserId'),
        'unique_used_names' => array('BrowserId'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Force.com",
        'purpose' => __("This cookie registers an unique ID used to identify type of device used when returning to the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie registers an unique ID used to identify type of device used when returning to the website.", 'complianz-gdpr'),
    ),
    'CallRail' => array('functional' => false,
        'used_names' => array('calltrk_landing', 'calltrk_referrer', 'calltrk_session_id_xxxxxx'),
        'unique_used_names' => array('calltrk_landing', 'calltrk_referrer', 'calltrk_session_id_partial'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "CallRail",
        'purpose' => __("This cookie tracks the last website visited prior to landing on our website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie tracks the last website visited prior to landing on our website.", 'complianz-gdpr'),
    ),
    'Alexa' => array('functional' => false,
        'used_names' => array('__asc', '__auc'),
        'unique_used_names' => array('__asc', '__auc'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Alexa",
        'purpose' => __("This cookie is used to track and report information to the Alexa analytics service.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to track and report information to the Alexa analytics service.", 'complianz-gdpr'),
    ),

    'Crazy_Egg' => array('functional' => false,
        'used_names' => array('_ceir', '_ceg.s', '_ceg.u', '_ceg_s', '_ceg_u'),
        'unique_used_names' => array('_ceir', '_ceg.s', '_ceg.u', '_ceg_s', '_ceg_u'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Crazy_Egg",
        'purpose' => __("This cookie is providing web analytics that tracks how visitors interact with pages on a site.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is providing web analytics that tracks how visitors interact with pages on a site.", 'complianz-gdpr'),
    ),
    'AdRoll' => array('functional' => false,
        'used_names' => array('__adroll_fpc'),
        'unique_used_names' => array('__adroll_fpc'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "AdRoll",
        'purpose' => __("This cookie is used to track visitors and show advertisements later, based on browsing behavior.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to track visitors and show advertisements later, based on browsing behavior.", 'complianz-gdpr'),
    ),
    'Shopify' => array('functional' => true,
        'used_names' => array('_shopify_y', '_shopify_sa_t', '_shopify_sa_p', '_shopify_s', '_shopify_fs', '_orig_referrer'),
        'unique_used_names' => array('_shopify_y', '_shopify_sa_t', '_shopify_sa_p', '_shopify_s', '_shopify_fs', '_orig_referrer'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Shopify",
        'purpose' => __("This cookie is used to be able to deliver webshop functionalities to the website. You can place items in your cart, pay, choose payment methods, etc.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used be able to deliver webshop functionalities to the website. You can place items in your cart, pay, choose payment methods, etc.", 'complianz-gdpr'),
    ),
    'Algolia_Search' => array('functional' => true,
        'used_names' => array('algoliasearch-client-js'),
        'unique_used_names' => array('algoliasearch-client-js'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Algolia",
        'purpose' => __("This cookie is used to be able to use the Algolia search function on our website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to be able to use the Algolia search function on our website.", 'complianz-gdpr'),
    ),
    'Flow_Flow_Plugin' => array('marketing' => true,
        'used_names' => array('ff_news_session'),
        'unique_used_names' => array('ff_news_session'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Flow Flow",
        'purpose' => __("This cookie is used to be able to show social feeds on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to be able to show social feeds on the website.", 'complianz-gdpr'),
    ),
    'PayPal' => array('functional' => true,
        'used_names' => array('__paypal_storage__'),
        'unique_used_names' => array('__paypal_storage__'),
        'privacy_policy_url' => 'https://www.paypal.com/nl/webapps/mpp/ua/privacy-full',
        'label' => "PayPal",
        'purpose' => __("This cookie is used to be able to pay by PayPal.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to be able to pay by PayPal.", 'complianz-gdpr'),
    ),
    'Max_Mega_Menu' => array('functional' => true,
        'used_names' => array('maxmegamenu.themeeditor'),
        'unique_used_names' => array('maxmegamenu.themeeditor'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Max Mega Menu",
        'purpose' => __("This cookie is used to show a large top menu to improve the user experience.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to show a large top menu to improve the user experience.", 'complianz-gdpr'),
    ),
    'Intercom_Messenger' => array('functional' => true,
        'used_names' => array('intercom-id-xxxxxx', 'intercom-state', 'intercom-id-xxxxxx'),
        'unique_used_names' => array('intercom-id-xxxxxx', 'intercom-state', 'intercom-id_partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Intercom Messenger",
        'purpose' => __("This cookie is used by Intercom, which is a live chat plugin on our website. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Intercom, which is a live chat plugin on our website.", 'complianz-gdpr'),
    ),
    'Loggly' => array('functional' => true,
        'used_names' => array('logglytrackingsession'),
        'unique_used_names' => array('logglytrackingsession'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Loggly",
        'purpose' => __("This cookie is used by Loggly, which is tool that helps Github users to resolve coding errors on the website. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Loggly, which is tool that helps Github users to resolve coding errors on the website.", 'complianz-gdpr'),
    ),
    'Google_Adsense' => array('marketing' => true,
        'used_names' => array('google_experiment_mod', 'google_experiment_mod3'),
        'unique_used_names' => array('google_experiment_mod', 'google_experiment_mod3'),
        'privacy_policy_url' => 'https://policies.google.com/technologies/ads?hl=en',
        'label' => "Google Adsense",
        'purpose' => __("This cookie is used by Google Adsense, to show you advertisements based on browsing behavior. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Google Adsense, to show you advertisements based on browsing behavior.", 'complianz-gdpr'),
    ),
    'UK_Cookie_Plugin' => array('functional' => true,
        'used_names' => array('catAccCookies'),
        'unique_used_names' => array('catAccCookies'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "UK Cookie Plugin",
        'purpose' => __("This cookie is used by the UK Cookie Plugin to record the fact that you have accepted cookies. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by the UK Cookie Plugin to record the fact that you have accepted cookies.", 'complianz-gdpr'),
    ),

    'Q_Translate' => array('functional' => true,
        'used_names' => array('qtrans_front_language', 'qtrans_admin_language', 'qtrans_edit_language'),
        'unique_used_names' => array('qtrans_front_language', 'qtrans_admin_language', 'qtrans_edit_language'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Q Translate",
        'purpose' => __("This cookie is used to identify which language the page should be used.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to identify which language the page should be used.", 'complianz-gdpr'),
    ),

    'Under_Construction_Plugin' => array('functional' => true,
        'used_names' => array('ucp_tabs'),
        'unique_used_names' => array('ucp_tabs'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Under Construction Page",
        'purpose' => __("This cookie is used to show an under construction page.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to show an under construction page.", 'complianz-gdpr'),
    ),

    'Avada_Privacy_Bar' => array('functional' => true,
        'used_names' => array('privacy_embeds'),
        'unique_used_names' => array('privacy_embeds'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Avada Privacy Bar",
        'purpose' => __("This cookie is used when the Privacy Consent box is opened to remind your settings.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used when the Privacy Consent box is opened to remind your settings.", 'complianz-gdpr'),
    ),

    'Fusion_Theme' => array('functional' => true,
        'used_names' => array('fusionredux_current_tab', 'fusion_metabox_tab_10', 'fusion_metabox_tab_744', 'fusion_metabox_tab_16', 'fusion_metabox_tab_14', 'fusion_metabox_tab_2012', 'fusion_metabox_tab_8'),
        'unique_used_names' => array('fusionredux_current_tab', 'fusion_metabox_tab_10', 'fusion_metabox_tab_744', 'fusion_metabox_tab_16', 'fusion_metabox_tab_14', 'fusion_metabox_tab_2012', 'fusion_metabox_tab_8'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Fusion Theme",
        'purpose' => __("This cookie is used to use the core functionalities of the Avada Fusion theme. This cookie is strictly necessary to show you all functionalities on our website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to use the core functionalities of the Avada Fusion theme. This cookie is strictly necessary to show you all functionalities on our website.", 'complianz-gdpr'),
    ),

    'WP_GDPR' => array('functional' => true,
        'used_names' => array('wpgdprc-consent'),
        'unique_used_names' => array('wpgdprc-consent'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP GDPR",
        'purpose' => __("This cookie is used to display a cookie banner.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to display a cookie banner.", 'complianz-gdpr'),
    ),

    'Avia_Enfold' => array('functional' => true,
        'used_names' => array('avia_post_0_58', 'avia_post_0_647', 'avia_post_0_661', 'aviaenfoldchild1058095', 'aviaenfoldchild10647095'),
        'unique_used_names' => array('avia_post_0_58', 'avia_post_0_647', 'avia_post_0_661', 'aviaenfoldchild1058095', 'aviaenfoldchild10647095'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Avia Enfold",
        'purpose' => __("This cookie is used to enable core functionalities of the Avia Enfold theme. This is a strictly necessary cookie which makes the website perform better.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to enable core functionalities of the Avia Enfold theme. This is a strictly necessary cookie which makes the website perform better.", 'complianz-gdpr'),
    ),

    'Bleeper_Live_Chat' => array('functional' => true,
        'used_names' => array('bleeper_customerID-xxxxxx', 'bleeper_current', 'bleeper_first'),
        'unique_used_names' => array('bleeper_customerID_partial', 'bleeper_current', 'bleeper_first'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Bleeper Live Chat",
        'purpose' => __("This cookie is used by Bleeper Live Chat and shows you a Live Chat, to help you during your stay on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Bleeper Live Chat and shows you a Live Chat, to help you during your stay on the website.", 'complianz-gdpr'),
    ),

    'WP_Do_Not_Track' => array('functional' => true,
        'used_names' => array('wp-donottrack_feed', 'dont_track_me'),
        'unique_used_names' => array('wp-donottrack_feed', 'dont_track_me'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP Do Not Track",
        'purpose' => __("This cookie is used to stop plugins and themes from adding 3rd party tracking code and cookies. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to stop plugins and themes from adding 3rd party tracking code and cookies.", 'complianz-gdpr'),
    ),

    'Posts_View_Counter' => array('functional' => true,
        'used_names' => array('pvc_visits'),
        'unique_used_names' => array('pvc_visits'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Posts View Counter",
        'purpose' => __("This cookie is used to count the views on posts and helps the website to perform better. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to count the views on posts and helps the website to perform better.", 'complianz-gdpr'),
    ),
    'SPO' => array('functional' => true,
        'used_names' => array('spo_1_fa', 'spo_xxxxxx_fa'),
        'unique_used_names' => array('spo_1_fa', 'spo_partial_fa'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "SPO",
        'purpose' => __("This cookie is used to remember privacy settings on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to remember privacy settings on the website.", 'complianz-gdpr'),
    ),
    'Breeze' => array('functional' => true,
        'used_names' => array('breeze_active_tab'),
        'unique_used_names' => array('breeze_active_tab'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Breeze",
        'purpose' => __("This cookie speeds up the website by using cache memory.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie speeds up the website by using cache memory.", 'complianz-gdpr'),
    ),
    'Rank Math' => array('functional' => true,
        'used_names' => array('rank-math-option-search-index', 'rank-math-option-search-premium', 'rank-math-option-sitemap-index', 'rank-math-option-general-index', 'rank-math-option-titles-index'),
        'unique_used_names' => array('rank-math-option-search-index', 'rank-math-option-search-premium', 'rank-math-option-sitemap-index', 'rank-math-option-general-index', 'rank-math-option-titles-index'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Rank Math",
        'purpose' => __("This cookie is used by Rank Math, and is used to perform better in Google's search algoritm.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Rank Math, and is used to perform better in Google's search algoritm.", 'complianz-gdpr'),
    ),

    'Dyamar_Polls' => array('functional' => true,
        'used_names' => array('DYAMAR_POLL_16_VOTED', 'DYAMAR_POLL_xxxxxx_VOTED'),
        'unique_used_names' => array('DYAMAR_POLL_partial_VOTED'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Dyamar Polls",
        'purpose' => __("This cookie is used to set up a poll and track their results.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to set up a poll and track their results.", 'complianz-gdpr'),
    ),

    'WP_Reset' => array('functional' => true,
        'used_names' => array('wp-reset-tabs'),
        'unique_used_names' => array('wp-reset-tabs'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP_Reset",
        'purpose' => __("This cookie is used to quickly reset the website to the default installation. It speeds up the website and the debugging.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used to quickly reset the website to the default installation. It speeds up the website and the debugging.", 'complianz-gdpr'),
    ),


    'Gutenberg_Advanced' => array('functional' => true,
        'used_names' => array('advgbLeftTab', 'advgbRightTab'),
        'unique_used_names' => array('advgbLeftTab', 'advgbRightTab'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Gutenberg Advanced",
        'purpose' => __("This cookie is used by Gutenberg Advanced. It adds missing blocks and configuration for the website builder to deliver visitors the best experience.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by by Gutenberg Advanced. It adds missing blocks and configuration for the website builder to deliver visitors the best experience.", 'complianz-gdpr'),
    ),

    'Elementor' => array('functional' => true,
        'used_names' => array('elementor'),
        'unique_used_names' => array('elementor'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Elementor Page Builder",
        'purpose' => __("This cookie is used by Elementor, a WordPress theme. It's a live page builder which makes it easier for the website admin to set up a website that is best for user experience.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Elementor, a WordPress theme. It's a live page builder which makes it easier for the website admin to set up a website that is best for user experience.", 'complianz-gdpr'),
    ),

    'MaxButtons' => array('functional' => true,
        'used_names' => array('mb-col-preview'),
        'unique_used_names' => array('mb-col-preview'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "MaxButtons",
        'purpose' => __("This cookie is used by MaxButtons to optimize buttons on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by MaxButtons to optimize buttons on the website.", 'complianz-gdpr'),
    ),

    'Bloom' => array('marketing' => true,
        'used_names' => array('mb-col-preview'),
        'unique_used_names' => array('mb-col-preview'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Bloom",
        'purpose' => __("This cookie is used by Bloom and shows different features to gain email opt-ins on the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by Bloom and shows different features to gain email opt-ins on the website.", 'complianz-gdpr'),
    ),

    'One.com' => array('functional' => true,
        'used_names' => array('onecomThmActTab'),
        'unique_used_names' => array('onecomThmActTab'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "One.com",
        'purpose' => __("This cookie is used a default theme of One.com. It makes it easier for the website owner to make a website and develiver a good usability.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used a default theme of One.com. It makes it easier for the website owner to make a website and develiver a good usability.", 'complianz-gdpr'),
    ),

    'Incapsula' => array('functional' => true,
        'used_names' => array('incap_ses_xxxxxx', 'visid_incap_xxxxxx'),
        'unique_used_names' => array('incap_ses_partial_', 'visid_incap_partial_'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Incapsula",
        'purpose' => __("This cookie is used for the protection of the website. Incapsula is a security CDN that makes any website safer, faster and more reliable.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used for the protection of the website. Incapsula is a security CDN that makes any website safer, faster and more reliable.", 'complianz-gdpr'),
    ),

    'Amazon_Pay' => array('functional' => true,
        'used_names' => array('amazon-pay-connectedAuth', 'amazon-pay-abtesting-new-widgets'),
        'unique_used_names' => array('amazon-pay-connectedAuth', 'amazon-pay-abtesting-new-widgets'),
        'privacy_policy_url' => 'https://pay.amazon.com/us/help/201751600',
        'label' => "Amazon Pay",
        'purpose' => __("Amazon Pay is a service provided by Amazon, which makes it able to pay by Amazon Pay on this website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Amazon Pay is a service provided by Amazon, which makes it able to pay by Amazon Pay on this website.", 'complianz-gdpr'),
    ),


    'CleanTalk_Spam_Protect' => array('functional' => true,
        'used_names' => array('ct_sfw_pass_key', 'apbct_site_landing_ts', 'ct_checkjs', 'apbct_visible_fields', 'apbct_visible_fields_count', 'ct_fkp_timestamp', 'ct_pointer_data', 'ct_timezone', 'ct_ps_timestamp', 'apbct_timestamp', 'apbct_page_hits', 'apbct_cookies_test'),
        'unique_used_names' => array('ct_sfw_pass_key', 'apbct_site_landing_ts', 'ct_checkjs', 'apbct_visible_fields', 'apbct_visible_fields_count', 'ct_fkp_timestamp', 'ct_pointer_data', 'ct_timezone', 'ct_ps_timestamp', 'apbct_timestamp', 'apbct_page_hits', 'apbct_cookies_test'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "CleanTalk Spam Protect",
        'purpose' => __("CleanTalk Spam Protect is a service which helps fight spam without having the end-user to fill in ReCaptcha's. Therefor, it optimizes user experience as well. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("CleanTalk Spam Protect is a service which helps fight spam without having the end-user to fill in ReCaptcha's. Therefor, it optimizes user experience as well.", 'complianz-gdpr'),
    ),

    'WP_Rocket' => array('functional' => true,
        'used_names' => array('wpr-hash', 'wpr-show-sidebar'),
        'unique_used_names' => array('wpr-hash', 'wpr-show-sidebar'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP Rocket",
        'purpose' => __("WP Rocket places cookies to make use of caching. This means that the browser saves certain elements of the website, so the website will load faster when visiting again. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("WP Rocket places cookies to make use of caching. This means that the browser saves certain elements of the website, so the website will load faster when visiting again. ", 'complianz-gdpr'),
    ),

    'Uncode' => array('functional' => true,
        'used_names' => array('uncodeAI_css', 'uncodeAI_images', 'uncodeAI_screen', 'uncodeAI.css', 'uncodeAI.images', 'uncodeAI.screen'),
        'unique_used_names' => array('uncodeAI_css', 'uncodeAI_images', 'uncodeAI_screen', 'uncodeAI.css', 'uncodeAI.images', 'uncodeAI.screen'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Uncode",
        'purpose' => __("Uncode is a WordPress theme which is necessary for this website to deliver the best user experience. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Uncode is a WordPress theme which is necessary for this website to deliver the best user experience. ", 'complianz-gdpr'),
    ),

    'WOOBE' => array('functional' => true,
        'used_names' => array('woobe_calculator_operation', 'woobe_calculator_how'),
        'unique_used_names' => array('woobe_calculator_operation', 'woobe_calculator_how'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WOOBE",
        'purpose' => __("WOOBE is a WordPress plugin and enables website admins to easily add multiple products to their store at once. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("WOOBE is a WordPress plugin and enables website admins to easily add multiple products to their store at once.", 'complianz-gdpr'),
    ),


    'Auto_Optimize' => array('functional' => true,
        'used_names' => array('autoptimize_feed'),
        'unique_used_names' => array('autoptimize_feed'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Auto Optimize",
        'purpose' => __("This cookie makes it possible to aggregate, minify and cache scripts and styles. It also injects CSS in the page head by default, moves and defers scripts to the footer and minifies HTML. This means that it speeds up the website, and can therefor be considered as a functional cookie. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to aggregate, minify and cache scripts and styles. It also injects CSS in the page head by default, moves and defers scripts to the footer and minifies HTML. This means that it speeds up the website, and can therefor be considered as a functional cookie. ", 'complianz-gdpr'),
    ),

    'Awesome_Support' => array('functional' => true,
        'used_names' => array('awesome_support_newsfeed'),
        'unique_used_names' => array('awesome_support_newsfeed'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Awesome Support",
        'purpose' => __("This cookie makes it possible to send tickets via our ticketing system so that we are always able to help you during your visit on our website. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie makes it possible to send tickets via our ticketing system so that we are always able to help you during your visit on our website. ", 'complianz-gdpr'),
    ),

    'Option_Forms' => array('functional' => true,
        'used_names' => array('fca_eoi_pagecount'),
        'unique_used_names' => array('fca_eoi_pagecount'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Option Forms",
        'purpose' => __("This cookie tracks the number of page views for optimization purposes. ", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie tracks the number of page views for optimization purposes. ", 'complianz-gdpr'),
    ),

    'Wistia' => array('marketing' => true,
        'used_names' => array('wistia'),
        'unique_used_names' => array('wistia'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Wistia",
        'purpose' => __("Wistia makes it possible for the website admin to embed videos.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Wistia makes it possible for the website admin to embed videos.", 'complianz-gdpr'),
    ),

    'CP_Blocks' => array('marketing' => true,
        'used_names' => array('CP5XKN6QLDFWUC'),
        'unique_used_names' => array('CP5XKN6QLDFWUC'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "CP Blocks",
        'purpose' => __("CP Blocks makes it possible for the website admin to customize aspects on the website so the user experience will be better.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("CP Blocks makes it possible for the website admin to customize aspects on the website so the user experience will be better.", 'complianz-gdpr'),
    ),

    'ET_Editor' => array('functional' => true,
        'used_names' => array('et-editor-available-post', 'et-editor-available-post-xxxx-bb'),
        'unique_used_names' => array('et-editor-available-post', 'et-editor-available-post-_partial_-bb'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "ET Editor",
        'purpose' => __("This cookie is set by ET Editor and is being used as a session cookie.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("The cookie makes it possible for us to adjust the website in different manners via a Page Builder tool.", 'complianz-gdpr'),
    ),

    'WP_Autosave' => array('functional' => true,
        'used_names' => array('wp-autosave-1'),
        'unique_used_names' => array('wp-autosave-1'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP Autosave",
        'purpose' => __("We use this plugin for automatically saving a post from the editor to drafts by timer or by changes in editor.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("We use this plugin for automatically saving a post from the editor to drafts by timer or by changes in editor.", 'complianz-gdpr'),
    ),

    'Themeify' => array('functional' => true,
        'used_names' => array('themeify_is_free_parallax', 'themify-builder-tabs'),
        'unique_used_names' => array('themeify_is_free_parallax', 'themify-builder-tabs'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Themeify",
        'purpose' => __("Themeify is a theme for our website. It places cookies to deliver the users the best experience when visiting the website.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("Themeify is a theme for our website. It places cookies to deliver the users the best experience when visiting the website.", 'complianz-gdpr'),
    ),

    'Skype' => array('functional' => true,
        'used_names' => array('skype.fingerprint'),
        'unique_used_names' => array('skype.fingerprint'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Skype",
        'purpose' => __("We place cookies from Skype, so that you are able to call us via Skype, anytime.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("We place cookies from Skype, so that you are able to call us via Skype, anytime.", 'complianz-gdpr'),
    ),

    'ACF' => array('functional' => true,
        'used_names' => array('skype.fingerprint'),
        'unique_used_names' => array('skype.fingerprint'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "ACF Repeater",
        'purpose' => __("The ACF cookie helps us, the website owners, to develop the website in a more clean way so we can deliver the best user experience.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("The ACF cookie helps us, the website owners, to develop the website in a more clean way so we can deliver the best user experience.", 'complianz-gdpr'),
    ),

    'BuddyPress' => array('functional' => true,
        'used_names' => array('bp-activity-oldestpage'),
        'unique_used_names' => array('bp-activity-oldestpage'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "BuddyPress",
        'purpose' => __("With this cookie we are able to deliver a function on our website: We can edit your activity posts and replies.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("With this cookie we are able to deliver a function on our website: We can edit your activity posts and replies.", 'complianz-gdpr'),
    ),

    'WordPress Caching' => array('functional' => true,
        'used_names' => array('wpSGCacheBypass'),
        'unique_used_names' => array('wpSGCacheBypass'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WordPress Caching",
        'purpose' => __("With this cookie WordPress, the Content Management System, is able to remember certain settings on the website for the next visit.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("With this cookie WordPress, the Content Management System, is able to remember certain settings on the website for the next visit.", 'complianz-gdpr'),
    ),

    'WP Touch' => array('functional' => true,
        'used_names' => array('wptouch_customizer_mode'),
        'unique_used_names' => array('wptouch_customizer_mode'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "WP Touch",
        'purpose' => __("With this cookie we are able to make a mobile version of our website to deliver the best functionalities to our users.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("With this cookie we are able to make a mobile version of our website to deliver the best functionalities to our users.", 'complianz-gdpr'),
    ),

    'Cookie_Acceptation' => array('functional' => true,
        'used_names' => array('_cmpQcif3pcsupported '),
        'unique_used_names' => array('_cmpQcif3pcsupported '),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Cookie Acceptation",
        'purpose' => __("This cookie will be placed to decide whether all cookies have been accepted or just a few.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie will be placed to decide whether all cookies have been accepted or just a few.", 'complianz-gdpr'),
    ),

    'Tidio_Live_Chat' => array('functional' => true,
        'used_names' => array('tidio_state-xxxx'),
        'unique_used_names' => array('tidio_state_wrleof9vcp1iejohckihzh03jhonph3z', 'tidio_state_partial'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Tidio Live Chat",
        'purpose' => __("This cookie is used for being able to deliver the live chat functionality to our visitors. Via live chat we are able to help our visitors with questions at any time.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used for being able to deliver the live chat functionality to our visitors. Via live chat we are able to help our visitors with questions at any time.", 'complianz-gdpr'),
    ),

    'Iubenda' => array('functional' => true,
        'used_names' => array('_iub_cs-xxxx'),
        'unique_used_names' => array('_iub_cs_partial'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Iubenda Cookie Law Solution",
        'purpose' => __("This cookie is used for implementing the European Cookie Law and is obligatory to protect our customers' data.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used for implementing the European Cookie Law and is obligatory to protect our customers' data.", 'complianz-gdpr'),
    ),

    'AIT_Themes' => array(
        'functional' => true,
        'used_names' => array('AitShortcodesGenerator', 'ait-admin-theme-options-page', 'aitToggleUnsortables'),
        'unique_used_names' => array('AitShortcodesGenerator', 'ait-admin-theme-options-page', 'aitToggleUnsortables'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "AIT Themes",
        'purpose' => __("This cookie is used by our main theme: AIT Theme. It is necessary for us to place these cookies to deliver the best experience on our website. Think of search results refinery, a faster and better looking website and reviews.", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is used by our main theme: AIT Theme. It is necessary for us to place these cookies to deliver the best experience on our website. Think of search results refinery, a faster and better looking website and reviews.", 'complianz-gdpr'),

    ),

    'dont_track_me' => array(
        'functional' => true,
        'used_names' => array('dont_track_me'),
        'unique_used_names' => array('dont_track_me'),
        'privacy_policy_url' => '[privacy_policy_url]',
        'label' => "Do not track",
        'purpose' => __("Stores cookie consent", 'complianz-gdpr'),
        'storage_duration' => __("365 days", 'complianz-gdpr'),
        'description' => __("This cookie is placed whenever we detect a 'do not track me' signal from your browser and prevents tracking cookies from being placed.", 'complianz-gdpr'),
    ),
   
);
