<?php

namespace WP_CLI\Embeds;

use WP_CLI\Dispatcher\CommandNamespace;

/**
 * Inspects oEmbed providers, clears embed cache, and more.
 *
 * ## EXAMPLES
 *
 *     # Get embed HTML for a given URL.
 *     $ wp embed fetch https://www.youtube.com/watch?v=dQw4w9WgXcQ
 *     <iframe width="525" height="295" src="https://www.youtube.com/embed/dQw4w9WgXcQ?feature=oembed" ...
 *
 *     # Find cache post ID for a given URL.
 *     $ wp embed cache find https://www.youtube.com/watch?v=dQw4w9WgXcQ --width=500
 *     123
 *
 *     # List format,endpoint fields of available providers.
 *     $ wp embed provider list
 *     +------------------------------+-----------------------------------------+
 *     | format                       | endpoint                                |
 *     +------------------------------+-----------------------------------------+
 *     | #https?://youtu\.be/.*#i     | https://www.youtube.com/oembed          |
 *     | #https?://flic\.kr/.*#i      | https://www.flickr.com/services/oembed/ |
 *     | #https?://wordpress\.tv/.*#i | https://wordpress.tv/oembed/            |
 *
 *     # List id,regex,priority fields of available handlers.
 *     $ wp embed handler list --fields=priority,id
 *     +----------+-------------------+
 *     | priority | id                |
 *     +----------+-------------------+
 *     | 10       | youtube_embed_url |
 *     | 9999     | audio             |
 *     | 9999     | video             |
 *     +----------+-------------------+
 *
 * @package wp-cli
 */
class Embeds_Namespace extends CommandNamespace {
}
