<?php
defined('ABSPATH') or die("you do not have acces to this page!");
$this->fields = $this->fields + array(
		'has-wizard-been-completed-za' => array(
			'step' => 1,
			'source' => 'dataleak-za',
			'type' => 'radio',
			'default' => '',
			'callback' => 'is_wizard_completed',
		),

		'security-incident-occurred-za' => array(
			'step' => 2,
			'section' => 1,
			'source' => 'dataleak-za',
			'type' => 'radio',
			'required' => true,
			'default' => '',
			'label' => __("Has a security incident occurred?", 'complianz-gdpr'),
			'options' => $this->yes_no,
			'tooltip' => __("e.g. lost USB stick, break in, stolen laptop, password lost.", 'complianz-gdpr'),
		),

		'type-of-dataloss-za' => array(
			'step' => 2,
			'section' => 2,
			'source' => 'dataleak-za',
			'type' => 'radio',
			'default' => '',
			'required' => true,
			'label' => __("Which situation applies to the incident above.", 'complianz-gdpr'),
			'callback_condition' => array('security-incident-occurred-za' => 'yes'),
			'options' => array(
				'1' => __('Personal data has been lost, and there is no up to date back-up', 'complianz-gdpr'),
				'2' => __('It can not be excluded that unauthorized persons have gained access to personal data', 'complianz-gdpr'),
				'3' => __('The above alternatives do not apply.', 'complianz-gdpr'),
			),
		),
		'risk-of-data-loss-za' => array(
			'step' => 3,
			'source' => 'dataleak-za',
			'type' => 'radio',
			'required' => true,
			'options' => array(
				'1' => __("There is a real risk of significant harm, due to the probability that the personal information has been, is being or will be misused.", 'complianz-gdpr'),
				'2' => __("The databreach applies to (some) personal data that may be sensitive.", 'complianz-gdpr'),
				'3' => __("The data has been encrypted in such a way that it is not possible to abuse the data", 'complianz-gdpr'),
				'4' => __("The possible consequences have been minimized immediately, which effectively excludes the possibility of abuse by malicious parties", 'complianz-gdpr'),
			),
			'default' => '',
			'label' => __("What information was involved?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
			),
		),
		'can-reduce-risk' => array(
			'step' => 4,
			'source' => 'dataleak-za',
			'type' => 'radio',
			'required' => true,
			'options' =>$this->yes_no,
			'default' => '',
			'label' => __("Do you think any other organization, a government institution or a part of a government institution may be able to reduce the risk of harm from the breach or to mitigate that harm?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),
			),
		),


		'what-occurred-za' => array(
			'step' => 4,
			'source' => 'dataleak-za',
			'type' => 'text',
			'translatable' => false,
			'default' => '',
			'required' => true,
			'label' => __("What has occurred exactly?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),
			),
		),
		'consequences-za' => array(
			'step' => 4,
			'source' => 'dataleak-za',
			'type' => 'text',
			'translatable' => false,
			'required' => true,
			'default' => '',
			'label' => __("What are the possible consequences?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),

			),
		),
		'measures-za' => array(
			'step' => 4,
			'source' => 'dataleak-za',
			'type' => 'text',
			'translatable' => false,
			'default' => '',
			'required' => true,
			'label' => __("What measures have been taken after the breach?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),

			),
		),

		'measures_by_person_involved-za' => array(
			'step' => 4,
			'section' => 1,
			'source' => 'dataleak-za',
			'type' => 'text',
			'translatable' => false,
			'default' => '',
			'required' => true,
			'label' => __("What measures could a person involved take to minimize damage?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),

			),
		),

		'date-of-breach-za' => array(
			'step' => 4,
			'section' => 1,
			'source' => 'dataleak-za',
			'type' => 'text',
			'translatable' => false,
			'default' => '',
			'required' => true,
			'label' => __("Day on which, or period during which the breach occurred, or if neither is known, the approximate period.", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),

			),
		),



		'phone-url-inquiries-za' => array(
			'step' => 4,
			'section' => 1,
			'source' => 'dataleak-za',
			'type' => 'text',
			'translatable' => false,
			'default' => '',
			'required' => true,
			'label' => __("Through which email address can customers make inquiries about your system?", 'complianz-gdpr'),
			'callback_condition' => array(
				'type-of-dataloss-za' => 'NOT 3',
				'security-incident-occurred-za' => 'yes',
				'risk-of-data-loss-za' => array('NOT 3', 'NOT 4'),

			),
		),

		'conclusion-za' => array(
			'step' => 5,
			'source' => 'dataleak-za',
			'callback' => 'dataleak_conclusion',
			'type' => 'text',
			'default' => '',
		),
	);
