<?php

namespace Concept7\StatamicMultitenancy\Subscribers;

use Concept7\StatamicMultitenancy\Models\Tenant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Events\Dispatcher;
use Statamic\Events\CollectionCreated;
use Statamic\Events\GlobalVariablesCreated;
use Statamic\Events\NavTreeSaved;
use Statamic\Events\SubmissionCreated;
use Statamic\Events\TermCreated;

class TenantableSubscriber
{
    public function handle(Model $model): void
    {
        $model->tenants()->syncWithoutDetaching([
            Tenant::current()->getKey(),
        ]);
    }

    public function subscribe(Dispatcher $events): void
    {
        $events->listen(CollectionCreated::class, fn (CollectionCreated $event) => $this->handle($event->collection->model()));
        $events->listen(GlobalVariablesCreated::class, fn (GlobalVariablesCreated $event) => $this->handle($event->variables->model()));
        $events->listen(NavTreeSaved::class, fn (NavTreeSaved $event) => $this->handle($event->tree->model()));
        $events->listen(SubmissionCreated::class, fn (SubmissionCreated $event) => $this->handle($event->submission->toModel()));
        $events->listen(TermCreated::class, fn (TermCreated $event) => $this->handle($event->term->model()));
    }
}
