<?php

namespace Concept7\StatamicMultitenancy\Traits;

use Concept7\StatamicMultitenancy\Models\Tenant;

trait CanAttachOrCreate
{
    public function save(array $options = [])
    {
        if (! $this->exists && $this->withoutGlobalScope('tenant')->whereHandle($this->handle)->exists()) {
            $this->id = $this->withoutGlobalScope('tenant')
                ->whereHandle($this->handle)
                ->first()
                ->getKey();

            $freshAttributes = $this->newQueryWithoutScopes()
                ->whereKey($this->id)
                ->first()
                ->getAttributes();

            $this->setRawAttributes($freshAttributes);

            $this->syncOriginal();

            $this->exists = true;
        }

        parent::save($options);

        $this->tenants()
            ->syncWithoutDetaching([
                Tenant::current()->getKey(),
            ]);
    }
}
