<?php

namespace Concept7\StatamicMultitenancy\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphPivot;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Tenantable extends MorphPivot
{
    protected $table = 'tenantables';

    protected function casts(): array
    {
        return [
            'data' => 'array',
        ];
    }

    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    public function tenantable(): MorphTo
    {
        return $this->morphTo();
    }
}
