<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Statamic\Eloquent\Database\BaseMigration as Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table($this->prefix('sites'), function (Blueprint $table) {
            $table->dropUnique('sites_handle_unique');
        });

        Schema::table($this->prefix('trees'), function (Blueprint $table) {
            $table->dropUnique('trees_handle_type_locale_unique');
        });

        Schema::table($this->prefix('collections'), function (Blueprint $table) {
            $table->dropUnique('collections_handle_unique');
        });

        Schema::table($this->prefix('taxonomy_terms'), function (Blueprint $table) {
            $table->dropUnique('taxonomy_terms_slug_taxonomy_site_unique');
        });
    }
};
