<?php

namespace Concept7\StatamicMultitenancy\Models;

use Concept7\StatamicMultitenancy\Eloquent\Collections\CollectionModel;
use Concept7\StatamicMultitenancy\Eloquent\Sites\SiteModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Spatie\Multitenancy\Contracts\IsTenant;
use Spatie\Multitenancy\Models\Concerns\ImplementsTenant;
use Spatie\Multitenancy\Models\Concerns\UsesLandlordConnection;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Tenant extends Model implements IsTenant
{
    use HasSlug;
    use ImplementsTenant;
    use UsesLandlordConnection;

    protected $fillable = [
        'name',
        'domain',
        'is_landlord',
    ];

    public function users(): MorphToMany
    {
        return $this->morphedByMany(config('auth.providers.users.model'), 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }

    public function sites(): MorphToMany
    {
        return $this->morphedByMany(SiteModel::class, 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }

    public function collections(): MorphToMany
    {
        return $this->morphedByMany(CollectionModel::class, 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }
}
