<?php

namespace Concept7\StatamicMultitenancy\Eloquent\Assets;

use Concept7\StatamicMultitenancy\Models\Tenant;
use Illuminate\Support\Facades\Storage;
use Statamic\Eloquent\Assets;
use Statamic\Filesystem\FlysystemAdapter;

class Asset extends Assets\Asset
{
    public function disk()
    {
        $tenant = $this
            ->model()
            ->tenants()
            ->where('is_landlord', false)
            ->whereNot('id', Tenant::current()->getKey())
            ->first();

        if (blank($tenant)) {
            return $this->container()->disk();
        }

        return new FlysystemAdapter(
            Storage::build(
                array_replace(
                    config('filesystems.disks.assets'),
                    [
                        'root' => storage_path("app/{$tenant->slug}/assets"),
                        'url' => "https://{$tenant->domain}/assets",
                    ]
                )
            )
        );
    }
}
