<?php

namespace Concept7\StatamicMultitenancy\Traits;

use Concept7\StatamicMultitenancy\Models\Tenantable;
use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Spatie\Multitenancy\Contracts\IsTenant;

trait IsTenantAware
{
    public function tenants(): MorphToMany
    {
        return $this
            ->morphToMany(app(IsTenant::class)::class, 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }

    protected static function bootIsTenantAware(): void
    {
        if (app(IsTenant::class)::current()) {
            static::created(function (Model $model) {
                $model->tenants()->attach(app(IsTenant::class)::current()->getKey());
            });

            static::addGlobalScope('tenant', function (Builder $builder) {
                $builder
                    ->whereHas('tenants', function (Builder $query) {
                        $query->where('tenant_id', app(IsTenant::class)::current()->getKey());
                    });

                if (in_array(Authenticatable::class, class_uses_recursive(self::class))) {
                    $builder->orWhere('super', true);
                }
            });
        }
    }
}
