<?php

namespace Concept7\StatamicMultitenancy\Eloquent\Entries;

use Concept7\StatamicMultitenancy\Traits\IsTenantAware;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Spatie\Multitenancy\Contracts\IsTenant;
use Statamic\Eloquent\Entries;

class EntryModel extends Entries\EntryModel
{
    use IsTenantAware;

    protected function published(): Attribute
    {
        return Attribute::make(
            get: fn () => data_get(
                $this
                    ->tenants()
                    ->where('id', app(IsTenant::class)::current()->getKey())
                    ->first()
                    ->pivot
                    ->data,
                'published'),
            set: fn ($value) => $this->tenants()->updateExistingPivot(app(IsTenant::class)::current()->getKey(), ['data' => ['published' => $value]])
        );
    }
}
