<?php

namespace Concept7\StatamicMultitenancy\Models;

use Concept7\StatamicMultitenancy\Eloquent\Collections\CollectionModel;
use Concept7\StatamicMultitenancy\Eloquent\Sites\SiteModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Spatie\Multitenancy\Contracts\IsTenant;
use Spatie\Multitenancy\Models\Concerns\ImplementsTenant;
use Spatie\Multitenancy\Models\Concerns\UsesLandlordConnection;

class Tenant extends Model implements IsTenant
{
    use ImplementsTenant;
    use UsesLandlordConnection;

    protected $fillable = [
        'name',
        'domain',
    ];

    public function sites(): MorphToMany
    {
        return $this->morphedByMany(SiteModel::class, 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }

    public function collections(): MorphToMany
    {
        return $this->morphedByMany(CollectionModel::class, 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }
}
