<?php

namespace Concept7\StatamicMultitenancy\Traits;

use Concept7\StatamicMultitenancy\Models\Tenant;
use Concept7\StatamicMultitenancy\Models\Tenantable;
use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\MorphToMany;

trait IsTenantAware
{
    public function tenants(): MorphToMany
    {
        return $this
            ->morphToMany(Tenant::class, 'tenantable')
            ->withPivot('data')
            ->withTimestamps()
            ->using(Tenantable::class);
    }

    protected static function bootIsTenantAware(): void
    {
        if (Tenant::current()) {
            static::addGlobalScope('tenant', function (Builder $builder) {
                $builder
                    ->whereHas('tenants', function (Builder $query) {
                        $query->where('tenant_id', Tenant::current()->getKey());
                    });

                if (in_array(Authenticatable::class, class_uses_recursive(self::class))) {
                    $builder->orWhere('super', true);
                }
            });
        }
    }
}
