<?php

namespace Concept7\StatamicMultitenancy\Tasks;

use Spatie\Multitenancy\Contracts\IsTenant;
use Spatie\Multitenancy\Tasks\SwitchTenantTask;

class SwitchAssetsTask implements SwitchTenantTask
{
    public function __construct(protected ?string $originalAssetsRoot = null, protected ?string $originalAssetsUrl = null)
    {
        $this->originalAssetsRoot ??= config('filesystems.disks.assets.root');
        $this->originalAssetsUrl ??= config('filesystems.disks.assets.url');
    }

    public function makeCurrent(IsTenant $tenant): void
    {
        $scheme = request()->getScheme();
        $domain = "{$scheme}://{$tenant->domain}/assets";

        $this->setAssetsPath(storage_path('app/'.$tenant->domain.'/assets'));
        $this->setAssetsUrl($domain);
    }

    public function forgetCurrent(): void
    {
        $this->setAssetsPath($this->originalAssetsRoot);
        $this->setAssetsUrl($this->originalAssetsUrl);
    }

    private function setAssetsPath(string $path): void
    {
        config(['filesystems.disks.assets.root' => $path]);
    }

    private function setAssetsUrl(string $url): void
    {
        config(['filesystems.disks.assets.url' => $url]);
    }
}
