const defaultTheme = require("tailwindcss/defaultTheme");

module.exports = {
    content: [
        "./resources/**/*.antlers.html",
        "./resources/**/*.antlers.php",
        "./resources/**/*.blade.php",
        "./resources/**/*.vue",
        "./resources/**/*.yaml",
        "./content/**/*.md",
    ],
    theme: {
        container: {
            center: true,
            padding: {
                DEFAULT: "1rem",
                sm: "2rem",
            },
        },
        extend: {
            colors: {
                primary: {
                    100: "#E0E7FF",
                    300: "#A5B4FC",
                    500: "#6366F1",
                    700: "#4338CA",
                    900: "#312E81",
                },
                secondary: {
                    100: "#D1FAE5",
                    300: "#6EE7B7",
                    500: "#10B981",
                    700: "#047857",
                    900: "#064E3B",
                },
                tertiary: {
                    100: "#F3F4F6",
                    300: "#D1D5DB",
                    500: "#6B7280",
                    700: "#374151",
                    900: "#111827",
                },
            },
            fontFamily: {
                display: ['"Exo"', ...defaultTheme.fontFamily.sans],
                body: ['"Open Sans"', ...defaultTheme.fontFamily.sans],
            },
            gradientColorStopPositions: {
                "33%": "33.333333%",
                "66%": "66.666667%",
            },
            outlineWidth: {
                3: "3px",
            },
            typography: (theme) => ({
                DEFAULT: {
                    css: {
                        "--tw-prose-body": theme("colors.primary.900"),
                        "--tw-prose-headings": theme("colors.primary.900"),
                        "--tw-prose-lead": theme("colors.primary.900"),
                        "--tw-prose-links": theme("colors.primary.900"),
                        "--tw-prose-bold": theme("colors.primary.900"),
                        "--tw-prose-counters": theme("colors.primary.900"),
                        "--tw-prose-bullets": theme("colors.primary.900"),
                        "--tw-prose-hr": theme("colors.primary.900"),
                        "--tw-prose-quotes": theme("colors.primary.900"),
                        "--tw-prose-quote-borders": theme("colors.primary.900"),
                        "--tw-prose-captions": theme("colors.primary.900"),
                        "--tw-prose-code": theme("colors.primary.900"),
                        "--tw-prose-pre-code": theme("colors.primary.900"),
                        "--tw-prose-pre-bg": theme("colors.primary.900"),
                        "--tw-prose-th-borders": theme("colors.primary.900"),
                        "--tw-prose-td-borders": theme("colors.primary.900"),
                        fontFamily: theme("fontFamily.body").join(", "),
                        fontSize: theme("fontSize.base.0"),
                        lineHeight: theme("fontSize.base.1.lineHeight"),
                        h1: {
                            fontFamily: theme("fontFamily.display").join(", "),
                            fontSize: theme("fontSize.4xl.0"),
                            fontWeight: theme("fontWeight.extrabold"),
                            lineHeight: theme("fontSize.4xl.1.lineHeight"),
                        },
                        h2: {
                            fontFamily: theme("fontFamily.display").join(", "),
                            fontSize: theme("fontSize.2xl.0"),
                            fontWeight: theme("fontWeight.semibold"),
                            lineHeight: theme("fontSize.2xl.1.lineHeight"),
                        },
                        h3: {
                            fontFamily: theme("fontFamily.display").join(", "),
                            fontSize: theme("fontSize.xl.0"),
                            fontWeight: theme("fontWeight.semibold"),
                            lineHeight: theme("fontSize.xl.1.lineHeight"),
                        },
                        h4: {
                            fontFamily: theme("fontFamily.display").join(", "),
                            fontSize: theme("fontSize.lg.0"),
                            fontWeight: theme("fontWeight.semibold"),
                            lineHeight: theme("fontSize.lg.1.lineHeight"),
                        },
                        h5: {
                            fontWeight: theme("fontWeight.semibold"),
                            fontFamily: theme("fontFamily.display").join(", "),
                        },
                        h6: {
                            fontWeight: theme("fontWeight.normal"),
                            fontFamily: theme("fontFamily.display").join(", "),
                        },
                    },
                },
                lg: {
                    css: {
                        fontSize: theme("fontSize.lg.0"),
                        lineHeight: theme("fontSize.lg.1.lineHeight"),
                        h1: {
                            fontSize: theme("fontSize.6xl.0"),
                            lineHeight: theme("fontSize.6xl.1.lineHeight"),
                        },
                        h2: {
                            fontSize: theme("fontSize.5xl.0"),
                            lineHeight: theme("fontSize.5xl.1.lineHeight"),
                        },
                        h3: {
                            fontSize: theme("fontSize.4xl.0"),
                            lineHeight: theme("fontSize.4xl.1.lineHeight"),
                        },
                        h4: {
                            fontSize: theme("fontSize.3xl.0"),
                            lineHeight: theme("fontSize.3xl.1.lineHeight"),
                        },
                        h5: {
                            fontSize: theme("fontSize.2xl.0"),
                            lineHeight: theme("fontSize.2xl.1.lineHeight"),
                        },
                        h6: {
                            fontSize: theme("fontSize.xl.0"),
                            lineHeight: theme("fontSize.xl.1.lineHeight"),
                        },
                    },
                },
                white: {
                    css: {
                        "--tw-prose-body": theme("colors.white"),
                        "--tw-prose-headings": theme("colors.white"),
                        "--tw-prose-lead": theme("colors.white"),
                        "--tw-prose-links": theme("colors.white"),
                        "--tw-prose-bold": theme("colors.white"),
                        "--tw-prose-counters": theme("colors.white"),
                        "--tw-prose-bullets": theme("colors.white"),
                        "--tw-prose-hr": theme("colors.white"),
                        "--tw-prose-quotes": theme("colors.white"),
                        "--tw-prose-quote-borders": theme("colors.white"),
                        "--tw-prose-captions": theme("colors.white"),
                        "--tw-prose-code": theme("colors.white"),
                        "--tw-prose-pre-code": theme("colors.white"),
                        "--tw-prose-pre-bg": theme("colors.white"),
                        "--tw-prose-th-borders": theme("colors.white"),
                        "--tw-prose-td-borders": theme("colors.white"),
                    },
                },
            }),
        },
    },
    plugins: [
        require("@tailwindcss/forms"),
        require("@tailwindcss/typography"),
    ],
};
