<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Schemas;

use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class ScaleForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            Section::make()
                ->heading(trans('questionnaire-admin::translations.scale_details'))
                ->description(trans('questionnaire-admin::translations.provide_the_details_for_this_scale'))
                ->schema([
                    TextInput::make('name')->label(__('questionnaire-admin::translations.name')),
                    Textarea::make('description')->label(__('questionnaire-admin::translations.description')),
                ]),
        ]);
    }
}
