<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\RelationManagers;

use Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Schemas\AssessmentForm;
use Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Tables\AssesmentTable;
use Concept7\QuestionnaireAdmin\Filament\Widgets\AssessmentDetailChart;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Schemas\Schema;
use Filament\Tables\Table;

class AssessmentRelationManager extends RelationManager
{
    protected static string $relationship = 'assessments';

    protected static ?string $title = 'Assessments';

    // protected static ?string $relatedResource = QuestionnaireResource::class;

    public function table(Table $table): Table
    {
        return AssesmentTable::configure($table);
    }

    public function form(Schema $schema): Schema
    {
        return AssessmentForm::configure($schema);
    }

    protected function getHeaderWidgets(): array
    {
        if (class_exists(AssessmentDetailChart::class)) {
            return [
                AssessmentDetailChart::class,
            ];
        }

        return [];
    }
}
