<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Schemas;

use Concept7\LaravelQuestionnaire\Models\AssessmentAnswer;
use Concept7\QuestionnaireAdmin\Filament\Widgets\AssessmentDetailChart;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\HtmlString;

class AssessmentForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Section::make(__('questionnaire-admin::translations.assessment_visualisation'))
                    ->schema([
                        Placeholder::make('chart')
                            ->hiddenLabel()
                            ->content(function ($record) {
                                if (! $record) {
                                    return null;
                                }

                                $widgetClass = AssessmentDetailChart::class;
                                if (! class_exists($widgetClass)) {
                                    return null;
                                }

                                return new HtmlString(Blade::render(
                                    '@livewire($component, ["record" => $record])',
                                    ['component' => $widgetClass, 'record' => $record]
                                ));
                            })
                            ->columnSpanFull(),
                    ])
                    ->collapsible(),

                Section::make(__('questionnaire-admin::translations.assessment_details'))
                    ->schema([
                        Placeholder::make('participant_display')
                            ->label(__('questionnaire-admin::translations.participant'))
                            ->content(fn (Client $record) => $record->assessmentable?->name ?? __('questionnaire-admin::translations.guest')),

                        DateTimePicker::make('created_at')
                            ->label(__('questionnaire-admin::translations.completed_at'))
                            ->disabled(),
                    ])
                    ->columns(2),

                Section::make(__('questionnaire-admin::translations.results'))
                    ->schema([
                        Repeater::make('answers')
                            ->label(__('questionnaire-admin::translations.given_answers'))
                            ->relationship('answers')
                            ->schema([
                                Grid::make(3)->schema([
                                    TextInput::make('assessment_id')
                                        ->label(__('questionnaire-admin::translations.assessment_id'))
                                        ->columnSpan(1)
                                        ->disabled(),

                                    TextInput::make('answer')
                                        ->label(__('questionnaire-admin::translations.answer'))
                                        ->columnSpan(1)
                                        ->dehydrated(false)
                                        ->formatStateUsing(function (AssessmentAnswer $record) {
                                            $record->load('answer');

                                            return $record->answer?->text ?? '-';
                                        })
                                        ->disabled(),

                                    TextInput::make('score')
                                        ->label(__('questionnaire-admin::translations.score'))
                                        ->numeric()
                                        ->columnSpan(1)
                                        ->dehydrated(false)
                                        ->formatStateUsing(function (AssessmentAnswer $record) {
                                            $record->load('answer');

                                            return $record->answer?->score ?? 0;
                                        })
                                        ->disabled(),
                                ]),
                            ])
                            ->columnSpanFull(),
                    ])
                    ->collapsible(),
            ]);
    }
}
