<?php

namespace Concept7\QuestionnaireAdmin\Filament\Widgets;

use Concept7\LaravelQuestionnaire\Helpers\ChartHelper;
use Filament\Widgets\ChartWidget;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class QuestionnaireAverageScoresChart extends ChartWidget
{
    public ?Model $record = null;

    protected function getData(): array
    {
        if (! $this->record) {
            return [];
        }

        $assessmentResultClass = config('questionnaire.models.assessment_result');

        $averages = $assessmentResultClass::query()
            ->whereHas('assessment', function ($q) {
                $q->where('questionnaire_id', $this->record->id);
            })
            ->select('category_id', DB::raw('AVG(total_score) as average_score'))
            ->groupBy('category_id')
            ->with('category')
            ->get();

        if ($averages->isEmpty()) {
            return [];
        }

        $labels = $averages->map(fn ($item) => $item->category->name ?? __('questionnaire-admin::translations.unknown'));
        $data = $averages->map(fn ($item) => round($item->average_score, 1));

        $chartData = ChartHelper::getChartData($labels, $data);

        $chartData['datasets'][0]['label'] = __('questionnaire-admin::translations.average_score');

        return $chartData;
    }

    protected function getOptions(): array
    {
        return ChartHelper::getDefaultChartOptions(
            xTitle: __('questionnaire-admin::translations.category'),
            yTitle: __('questionnaire-admin::translations.average_score')
        );
    }

    public static function getModel(): string
    {
        return config('questionnaire.models.questionnaire');
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
