<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questions\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class QuestionsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('text')
                    ->label(__('questionnaire-admin::translations.text'))
                    ->formatStateUsing(fn ($state) => str($state)->limit(50)),

                TextColumn::make('type')
                    ->label(__('questionnaire-admin::translations.type')),

                TextColumn::make('weight')
                    ->label(__('questionnaire-admin::translations.weight')),

                TextColumn::make('category.name')
                    ->label(__('questionnaire-admin::translations.category')),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                CreateAction::make()->label(__('questionnaire-admin::translations.create_question')),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
