<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\RelationManagers;

use Concept7\QuestionnaireAdmin\Filament\Resources\Questions\Schemas\QuestionForm;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questions\Tables\QuestionsTable;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Schemas\Schema;
use Filament\Tables\Table;

class QuestionsRelationManager extends RelationManager
{
    protected static string $relationship = 'questions';

    public function table(Table $table): Table
    {
        return QuestionsTable::configure($table);
    }

    public function form(Schema $schema): Schema
    {
        return QuestionForm::configure($schema);
    }
}
