<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class InterpretationTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('min_score')
                    ->label(trans('questionnaire-admin::translations.min_score'))
                    ->limit(50)
                    ->wrap()
                    ->searchable(),

                TextColumn::make('max_score')
                    ->label(trans('questionnaire-admin::translations.max_score'))
                    ->limit(50)
                    ->wrap()
                    ->searchable(),

                TextColumn::make('category.name')
                    ->label(trans('questionnaire-admin::translations.category')),

                TextColumn::make('scale.name')
                    ->label(trans('questionnaire-admin::translations.scale')),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([DeleteBulkAction::make()]),
            ]);
    }
}
