<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations;

use BackedEnum;
use Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Pages\CreateInterpretation;
use Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Pages\EditInterpretation;
use Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Pages\ListInterpretations;
use Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Pages\ViewInterpretation;
use Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Schemas\InterpretationForm;
use Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Tables\InterpretationTable;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class InterpretationResource extends Resource
{
    protected static ?string $model = null;

    protected static string|UnitEnum|null $navigationGroup = null;

    protected static ?int $navigationSort = 3;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'id';

    public static function getModel(): string
    {
        return config('questionnaire.models.interpretation');
    }

    public static function getNavigationGroup(): string
    {
        return __('questionnaire-admin::translations.questionnaires');
    }

    public static function getNavigationLabel(): string
    {
        return __('questionnaire-admin::translations.interpretations');
    }

    public static function getLabel(): string
    {
        return __('questionnaire-admin::translations.interpretation');
    }

    public static function getPluralLabel(): string
    {
        return __('questionnaire-admin::translations.interpretations');
    }

    public static function form(Schema $schema): Schema
    {
        return InterpretationForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return InterpretationTable::configure($table);
    }

    public static function getPages(): array
    {
        return [
            'index' => ListInterpretations::route('/'),
            'create' => CreateInterpretation::route('/create'),
            'view' => ViewInterpretation::route('/{record}'),
            'edit' => EditInterpretation::route('/{record}/edit'),
        ];
    }
}
