<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questions\Schemas;

use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class QuestionForm
{
    public static function configure(Schema $schema): Schema
    {
        $categoryClass = config('questionnaire.models.category');

        return $schema
            ->components([
                Section::make([
                    TextInput::make('text')
                        ->translateLabel(),

                    TextInput::make('weight')
                        ->translateLabel()
                        ->numeric(),

                    Select::make('type')
                        ->translateLabel()
                        ->options(collect(InputTypeEnum::cases())->mapWithKeys(fn (InputTypeEnum $type) => [$type->value => $type->getLabel()])),

                    Select::make('category_id')
                        ->translateLabel()
                        ->options($categoryClass::all()->pluck('name', 'id')),
                ]),

                Section::make('Answers')
                    ->schema([
                        Repeater::make('answers')
                            ->relationship()
                            ->schema([
                                TextInput::make('text')
                                    ->required()
                                    ->label('Answer Text')
                                    ->translateLabel(),

                                TextInput::make('score')
                                    ->label('Score')
                                    ->translateLabel()
                                    ->numeric(),
                            ])
                            ->orderable('order'),
                    ])
                    ->collapsible()
                    ->hidden(fn ($get) => $get('type') === 'text'),
            ]);
    }
}
