<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Schemas;

use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class CategoryForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Section::make()
                    ->heading(trans('questionnaire-admin::translations.category_details'))
                    ->description(trans('questionnaire-admin::translations.provide_the_details_for_this_category'))
                    ->schema([
                        TextInput::make('name')
                            ->label(trans('questionnaire-admin::translations.name')),
                        Textarea::make('description')
                            ->label(trans('questionnaire-admin::translations.description')),
                    ])
                    ->columns(2),
            ]);
    }
}
