<?php

namespace Concept7\QuestionnaireAdmin\Filament\Widgets; // Your package namespace

use Concept7\LaravelQuestionnaire\Helpers\ChartHelper;
use Filament\Widgets\ChartWidget;
use Illuminate\Database\Eloquent\Model;

class AssessmentDetailChart extends ChartWidget
{
    public ?Model $record = null;

    protected function getData(): array
    {
        return ChartHelper::buildChartDataFromAssessment($this->record) ?? [];
    }

    protected function getOptions(): array
    {
        return ChartHelper::getDefaultChartOptions();
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
