<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Tables;

use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class AssesmentTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->label('ID')
                    ->translateLabel()
                    ->sortable(),

                TextColumn::make('assessmentable.name')
                    ->label('Participant')
                    ->searchable()
                    ->placeholder(__('Guest')),

                TextColumn::make('created_at')
                    ->label('Date')
                    ->translateLabel()
                    ->dateTime()
                    ->sortable(),
            ])
            ->actions([
                ViewAction::make(),
            ]);
    }
}
