<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Scales;

use BackedEnum;
use Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Pages\CreateScale;
use Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Pages\EditScale;
use Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Pages\ListScales;
use Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Pages\ViewScale;
use Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Schemas\ScaleForm;
use Concept7\QuestionnaireAdmin\Filament\Resources\Scales\Tables\ScaleTable;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class ScalesResource extends Resource
{
    protected static ?string $model = null;

    protected static string|UnitEnum|null $navigationGroup = null;

    protected static ?int $navigationSort = 4;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getModel(): string
    {
        return config('questionnaire.models.scale');
    }

    public static function getLabel(): string
    {
        return __('questionnaire-admin::translations.scale');
    }

    public static function getPluralLabel(): string
    {
        return __('questionnaire-admin::translations.scales');
    }

    public static function getNavigationGroup(): string
    {
        return __('questionnaire-admin::translations.questionnaires');
    }

    public static function getNavigationLabel(): string
    {
        return __('questionnaire-admin::translations.scales');
    }

    public static function form(Schema $schema): Schema
    {
        return ScaleForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ScaleTable::configure($table);
    }

    public static function getPages(): array
    {
        return [
            'index' => ListScales::route('/'),
            'create' => CreateScale::route('/create'),
            'view' => ViewScale::route('/{record}'),
            'edit' => EditScale::route('/{record}/edit'),
        ];
    }
}
